/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.IOException;
import java.security.Permission;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigConverterTestCommons;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterMain;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSConfigToCSConfigConverterMain {
    private FSConfigConverterTestCommons converterTestCommons;
    private SecurityManager originalSecurityManager;
    private ExitHandlerSecurityManager exitHandlerSecurityManager;

    @Before
    public void setUp() throws Exception {
        this.originalSecurityManager = System.getSecurityManager();
        this.exitHandlerSecurityManager = new ExitHandlerSecurityManager();
        System.setSecurityManager(this.exitHandlerSecurityManager);
        this.converterTestCommons = new FSConfigConverterTestCommons();
        this.converterTestCommons.setUp();
    }

    @After
    public void tearDown() throws Exception {
        QueueMetrics.clearQueueMetrics();
        System.setSecurityManager(this.originalSecurityManager);
        this.converterTestCommons.tearDown();
    }

    @Test
    public void testConvertFSConfigurationDefaults() throws Exception {
        FSConfigConverterTestCommons.setupFSConfigConversionFiles();
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"-o", FSConfigConverterTestCommons.OUTPUT_DIR, "-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE});
        boolean csConfigExists = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "capacity-scheduler.xml").exists();
        boolean yarnSiteConfigExists = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "yarn-site.xml").exists();
        Assert.assertTrue((String)"capacity-scheduler.xml was not generated", (boolean)csConfigExists);
        Assert.assertTrue((String)"yarn-site.xml was not generated", (boolean)yarnSiteConfigExists);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitHandlerSecurityManager.exitCode);
    }

    @Test
    public void testConvertFSConfigurationWithConsoleParam() throws Exception {
        FSConfigConverterTestCommons.setupFSConfigConversionFiles();
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"-p", "-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE});
        String stdout = this.converterTestCommons.getStdOutContent().toString();
        Assert.assertTrue((String)"Stdout doesn't contain yarn-site.xml", (boolean)stdout.contains("======= yarn-site.xml ======="));
        Assert.assertTrue((String)"Stdout doesn't contain capacity-scheduler.xml", (boolean)stdout.contains("======= capacity-scheduler.xml ======="));
    }

    @Test
    public void testShortHelpSwitch() {
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"-h"});
        this.verifyHelpText();
    }

    @Test
    public void testLongHelpSwitch() {
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"--help"});
        this.verifyHelpText();
    }

    @Test
    public void testConvertFSConfigurationWithLongSwitches() throws IOException {
        FSConfigConverterTestCommons.setupFSConfigConversionFiles();
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"--print", "--yarnsiteconfig", FSConfigConverterTestCommons.YARN_SITE_XML, "--fsconfig", FSConfigConverterTestCommons.FS_ALLOC_FILE, "--rulesconfig", FSConfigConverterTestCommons.CONVERSION_RULES_FILE});
        String stdout = this.converterTestCommons.getStdOutContent().toString();
        Assert.assertTrue((String)"Stdout doesn't contain yarn-site.xml", (boolean)stdout.contains("======= yarn-site.xml ======="));
        Assert.assertTrue((String)"Stdout doesn't contain capacity-scheduler.xml", (boolean)stdout.contains("======= capacity-scheduler.xml ======="));
    }

    private void verifyHelpText() {
        String stdout = this.converterTestCommons.getStdOutContent().toString();
        Assert.assertTrue((String)"Help was not displayed", (boolean)stdout.contains("General options are:"));
    }

    class ExitHandlerSecurityManager
    extends SecurityManager {
        int exitCode = Integer.MIN_VALUE;

        ExitHandlerSecurityManager() {
        }

        @Override
        public void checkExit(int status) {
            if (status != 0) {
                throw new IllegalStateException("Exit code is not 0, it was " + status);
            }
            this.exitCode = status;
        }

        @Override
        public void checkPermission(Permission perm) {
        }
    }
}

