/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;

public class AllocationFileQueuePlacementRule {
    private RuleName name;
    private boolean create = true;
    private String queue;
    private List<AllocationFileQueuePlacementRule> nestedRules = Lists.newArrayList();

    public AllocationFileQueuePlacementRule(RuleName name) {
        this.name = name;
    }

    public AllocationFileQueuePlacementRule create(boolean shouldCreate) {
        this.create = shouldCreate;
        return this;
    }

    public AllocationFileQueuePlacementRule queue(String selectedQueue) {
        this.queue = selectedQueue;
        return this;
    }

    public AllocationFileQueuePlacementRule addNestedRule(AllocationFileQueuePlacementRule rule) {
        this.nestedRules.add(rule);
        return this;
    }

    public String render() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.addStartTag(pw);
        this.addNestedRules(pw);
        this.addEndTag(pw);
        pw.close();
        return sw.toString();
    }

    private void addStartTag(PrintWriter pw) {
        pw.print("<rule name=\"" + this.name.toString() + "\" create=\"" + String.valueOf(this.create) + "\"");
        if (this.queue != null) {
            pw.print("queue=\"" + this.queue + "\"");
        }
        pw.println(">");
    }

    private void addNestedRules(PrintWriter pw) {
        if (this.nestedRules != null && !this.nestedRules.isEmpty()) {
            for (AllocationFileQueuePlacementRule rule : this.nestedRules) {
                pw.println(rule.render());
            }
        }
    }

    private void addEndTag(PrintWriter pw) {
        pw.println("</rule>");
    }

    public static enum RuleName {
        DEFAULT("default"),
        SPECIFIED("specified"),
        REJECT("reject"),
        NESTED("nestedUserQueue"),
        PRIMARY_GROUP("primaryGroup");

        private String name;

        private RuleName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

