/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.metrics.CustomResourceMetricValue;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSLeafQueue
extends FairSchedulerTestBase {
    private static final String ALLOC_FILE = new File(TEST_DIR, TestFSLeafQueue.class.getName() + ".xml").getAbsolutePath();
    private Resource maxResource = Resources.createResource((int)8192);
    private static final float MAX_AM_SHARE = 0.5f;
    private static final String CUSTOM_RESOURCE = "test1";

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        this.conf = null;
    }

    @Test
    public void testUpdateDemand() {
        this.conf.set("yarn.scheduler.fair.assignmultiple", "false");
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        String queueName = "root.queue1";
        FSLeafQueue schedulable = new FSLeafQueue(queueName, this.scheduler, null);
        schedulable.setMaxShare(new ConfigurableResource(this.maxResource));
        Assertions.assertThat((int)schedulable.getMetrics().getMaxApps()).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((String)schedulable.getMetrics().getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.DEFAULT_POLICY.getName());
        FSAppAttempt app = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        Mockito.when((Object)app.getDemand()).thenReturn((Object)this.maxResource);
        Mockito.when((Object)app.getResourceUsage()).thenReturn((Object)Resources.none());
        schedulable.addApp(app, true);
        schedulable.addApp(app, true);
        schedulable.updateDemand();
        Assert.assertTrue((String)"Demand is greater than max allowed ", (boolean)Resources.equals((Resource)schedulable.getDemand(), (Resource)this.maxResource));
    }

    @Test(timeout=5000L)
    public void test() {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().queueMaxAMShareDefault(0.5).addQueue(new AllocationFileQueue.Builder("queueA").build()).addQueue(new AllocationFileQueue.Builder("queueB").build()).writeToFile(ALLOC_FILE);
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        for (FSQueue queue : this.scheduler.getQueueManager().getQueues()) {
            Assertions.assertThat((int)queue.getMetrics().getMaxApps()).isEqualTo(Integer.MAX_VALUE);
            Assertions.assertThat((String)queue.getMetrics().getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.DEFAULT_POLICY.getName());
        }
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.update();
        this.createSchedulingRequest(3072, "queueA", "user1");
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentAccess() {
        this.conf.set("yarn.scheduler.fair.assignmultiple", "false");
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        String queueName = "root.queue1";
        final FSLeafQueue schedulable = this.scheduler.getQueueManager().getLeafQueue(queueName, true);
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        RMContext rmContext = this.resourceManager.getRMContext();
        final FSAppAttempt app = new FSAppAttempt(this.scheduler, applicationAttemptId, "user1", schedulable, null, rmContext);
        int testThreads = 2;
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        runnables.add(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 500; ++i) {
                    schedulable.addApp(app, true);
                }
            }
        });
        runnables.add(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 500; ++i) {
                    schedulable.getResourceUsage();
                }
            }
        });
        final List<InterruptedException> exceptions = Collections.synchronizedList(new ArrayList());
        ExecutorService threadPool = HadoopExecutors.newFixedThreadPool((int)testThreads);
        try {
            final CountDownLatch allExecutorThreadsReady = new CountDownLatch(testThreads);
            final CountDownLatch startBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(testThreads);
            for (final Runnable submittedTestRunnable : runnables) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allExecutorThreadsReady.countDown();
                        try {
                            startBlocker.await();
                            submittedTestRunnable.run();
                        }
                        catch (Throwable e) {
                            exceptions.add(e);
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            allExecutorThreadsReady.await();
            startBlocker.countDown();
            int testTimeout = 2;
            Assert.assertTrue((String)("Timeout waiting for more than " + testTimeout + " seconds"), (boolean)allDone.await(testTimeout, TimeUnit.SECONDS));
        }
        catch (InterruptedException ie) {
            exceptions.add(ie);
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)("Test failed with exception(s)" + exceptions), (boolean)exceptions.isEmpty());
    }

    @Test
    public void testCanRunAppAMReturnsTrue() {
        this.conf.set("yarn.resource-types", CUSTOM_RESOURCE);
        ResourceUtils.resetResourceTypes((Configuration)this.conf);
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        Resource maxShare = Resource.newInstance((long)8192L, (int)4, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)10L));
        this.addNodeToScheduler(Resource.newInstance((long)4096L, (int)10, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)25L)));
        FSLeafQueue queue = this.setupQueue(maxShare);
        Resource expectedAMShare = Resource.newInstance((long)2048L, (int)2, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)5L));
        Resource appAMResource = Resource.newInstance((long)2048L, (int)2, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)3L));
        Map<String, Long> customResourceValues = this.verifyQueueMetricsForCustomResources(queue);
        boolean result = queue.canRunAppAM(appAMResource);
        Assert.assertTrue((String)"AM should have been allocated!", (boolean)result);
        this.verifyAMShare(queue, expectedAMShare, customResourceValues);
    }

    private FSLeafQueue setupQueue(Resource maxShare) {
        String queueName = "root.queue1";
        FSLeafQueue schedulable = new FSLeafQueue(queueName, this.scheduler, null);
        schedulable.setMaxShare(new ConfigurableResource(maxShare));
        schedulable.setMaxAMShare(0.5f);
        return schedulable;
    }

    @Test
    public void testCanRunAppAMReturnsFalse() {
        this.conf.set("yarn.resource-types", CUSTOM_RESOURCE);
        ResourceUtils.resetResourceTypes((Configuration)this.conf);
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        Resource maxShare = Resource.newInstance((long)8192L, (int)4, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)10L));
        this.addNodeToScheduler(Resource.newInstance((long)4096L, (int)10, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)25L)));
        FSLeafQueue queue = this.setupQueue(maxShare);
        Resource expectedAMShare = Resource.newInstance((long)2048L, (int)2, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)5L));
        Resource appAMResource = Resource.newInstance((long)2048L, (int)2, (Map)ImmutableMap.of((Object)CUSTOM_RESOURCE, (Object)6L));
        Map<String, Long> customResourceValues = this.verifyQueueMetricsForCustomResources(queue);
        boolean result = queue.canRunAppAM(appAMResource);
        Assert.assertFalse((String)"AM should not have been allocated!", (boolean)result);
        this.verifyAMShare(queue, expectedAMShare, customResourceValues);
    }

    private void addNodeToScheduler(Resource node1Resource) {
        RMNode node1 = MockNodes.newNodeInfo(0, node1Resource, 1, "127.0.0.2");
        this.scheduler.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node1));
    }

    private void verifyAMShare(FSLeafQueue schedulable, Resource expectedAMShare, Map<String, Long> customResourceValues) {
        Resource actualAMShare = Resource.newInstance((long)schedulable.getMetrics().getMaxAMShareMB(), (int)schedulable.getMetrics().getMaxAMShareVCores(), customResourceValues);
        long customResourceValue = actualAMShare.getResourceValue(CUSTOM_RESOURCE);
        Assert.assertEquals((long)5L, (long)customResourceValue);
        Assert.assertEquals((String)"AM share is not the expected!", (Object)expectedAMShare, (Object)actualAMShare);
    }

    private Map<String, Long> verifyQueueMetricsForCustomResources(FSLeafQueue schedulable) {
        CustomResourceMetricValue maxAMShareCustomResources = schedulable.getMetrics().getCustomResources().getMaxAMShare();
        Map customResourceValues = maxAMShareCustomResources.getValues();
        Assert.assertNotNull((String)"Queue metrics for custom resources should not be null!", (Object)maxAMShareCustomResources);
        Assert.assertNotNull((String)"Queue metrics for custom resources resource values should not be null!", (Object)customResourceValues);
        return customResourceValues;
    }
}

