/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Deprecated
public class TestContinuousScheduling
extends FairSchedulerTestBase {
    private ControlledClock mockClock;
    private static int delayThresholdTimeMs = 1000;

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        conf.setInt("yarn.scheduler.fair.locality-delay-node-ms", delayThresholdTimeMs);
        conf.setInt("yarn.scheduler.fair.locality-delay-rack-ms", delayThresholdTimeMs);
        return conf;
    }

    @Before
    public void setup() {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.mockClock = new ControlledClock();
        this.conf = this.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        this.scheduler.setClock((Clock)this.mockClock);
        Assert.assertTrue((boolean)this.scheduler.isContinuousSchedulingEnabled());
        Assert.assertEquals((long)5L, (long)this.scheduler.getContinuousSchedulingSleepMs());
        Assert.assertEquals((Object)this.mockClock, (Object)this.scheduler.getClock());
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }

    @Test(timeout=60000L)
    public void testBasic() throws InterruptedException {
        String host = "127.0.0.1";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, host);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(appAttemptId);
        ApplicationPlacementContext placementCtx = new ApplicationPlacementContext("queue11");
        this.scheduler.addApplication(appAttemptId.getApplicationId(), "queue11", "user11", false, placementCtx);
        this.scheduler.addApplicationAttempt(appAttemptId, false, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(this.createResourceRequest(1024, 1, "*", 1, 1, true));
        this.scheduler.allocate(appAttemptId, ask, null, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.triggerSchedulingAttempt();
        this.checkAppConsumption(app, Resources.createResource((int)1024, (int)1));
    }

    @Test(timeout=10000L)
    public void testSortedNodes() throws Exception {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assertions.assertThat((long)this.scheduler.getClusterResource().getMemorySize()).isEqualTo(16384L);
        Assertions.assertThat((int)this.scheduler.getClusterResource().getVirtualCores()).isEqualTo(16);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(appAttemptId);
        ApplicationPlacementContext placementCtx = new ApplicationPlacementContext("queue11");
        this.scheduler.addApplication(appAttemptId.getApplicationId(), "queue11", "user11", false, placementCtx);
        this.scheduler.addApplicationAttempt(appAttemptId, false, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(1024, 1, "*", 1, 1, true);
        ask.add(request);
        this.scheduler.allocate(appAttemptId, ask, null, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.triggerSchedulingAttempt();
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.checkAppConsumption(app, Resources.createResource((int)1024, (int)1));
        request = this.createResourceRequest(1024, 1, "*", 2, 1, true);
        ask.clear();
        ask.add(request);
        this.scheduler.allocate(appAttemptId, ask, null, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.triggerSchedulingAttempt();
        this.checkAppConsumption(app, Resources.createResource((int)2048, (int)2));
        HashSet<NodeId> nodes = new HashSet<NodeId>();
        Iterator it = app.getLiveContainers().iterator();
        while (it.hasNext()) {
            nodes.add(((RMContainer)it.next()).getContainer().getNodeId());
        }
        Assert.assertEquals((long)2L, (long)nodes.size());
    }

    @Test
    public void testWithNodeRemoved() throws Exception {
        this.scheduler = new FairScheduler();
        this.conf = super.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.scheduler.setRMContext(this.resourceManager.getRMContext());
        Assert.assertTrue((String)"Continuous scheduling should be disabled.", (!this.scheduler.isContinuousSchedulingEnabled() ? 1 : 0) != 0);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((String)"We should have two alive nodes.", (long)2L, (long)this.scheduler.getNumClusterNodes());
        NodeRemovedSchedulerEvent removeNode1 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeNode1);
        Assert.assertEquals((String)"We should only have one alive node.", (long)1L, (long)this.scheduler.getNumClusterNodes());
        try {
            this.scheduler.continuousSchedulingAttempt();
        }
        catch (Exception e) {
            Assert.fail((String)("Exception happened when doing continuous scheduling. " + e.toString()));
        }
    }

    @Test
    public void testInterruptedException() throws Exception {
        this.scheduler = new FairScheduler();
        this.conf = super.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.scheduler.setRMContext(this.resourceManager.getRMContext());
        this.scheduler.init(this.conf);
        this.scheduler.start();
        FairScheduler spyScheduler = (FairScheduler)Mockito.spy((Object)this.scheduler);
        Assert.assertTrue((String)"Continuous scheduling should be disabled.", (!spyScheduler.isContinuousSchedulingEnabled() ? 1 : 0) != 0);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        spyScheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((String)"We should have one alive node.", (long)1L, (long)spyScheduler.getNumClusterNodes());
        InterruptedException ie = new InterruptedException();
        ((FairScheduler)Mockito.doThrow((Throwable[])new Throwable[]{new YarnRuntimeException((Throwable)ie)}).when((Object)spyScheduler)).attemptScheduling((FSSchedulerNode)ArgumentMatchers.isA(FSSchedulerNode.class));
        try {
            spyScheduler.continuousSchedulingAttempt();
            Assert.fail((String)"Expected InterruptedException to stop schedulingThread");
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)ie, (Object)e);
        }
    }

    @Test
    public void testSchedulerThreadLifeCycle() throws InterruptedException {
        this.scheduler.start();
        Thread schedulingThread = this.scheduler.schedulingThread;
        Assert.assertTrue((boolean)schedulingThread.isAlive());
        this.scheduler.stop();
        int numRetries = 100;
        while (numRetries-- > 0 && schedulingThread.isAlive()) {
            Thread.sleep(50L);
        }
        Assert.assertNotEquals((String)"The Scheduling thread is still alive", (long)0L, (long)numRetries);
    }

    @Test
    public void TestNodeAvailableResourceComparatorTransitivity() {
        final ClusterNodeTracker clusterNodeTracker = this.scheduler.getNodeTracker();
        List<RMNode> rmNodes = MockNodes.newNodes(2, 4000, Resource.newInstance((int)4096, (int)4));
        for (RMNode rmNode : rmNodes) {
            clusterNodeTracker.addNode((SchedulerNode)new FSSchedulerNode(rmNode, false));
        }
        new Thread(){

            @Override
            public void run() {
                for (int j = 0; j < 100; ++j) {
                    for (FSSchedulerNode node : clusterNodeTracker.getAllNodes()) {
                        int i = ThreadLocalRandom.current().nextInt(-30, 30);
                        node.deductUnallocatedResource(Resource.newInstance((int)(i * 1024), (int)i));
                    }
                }
            }
        }.start();
        try {
            this.scheduler.continuousSchedulingAttempt();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFairSchedulerContinuousSchedulingInitTime() throws Exception {
        this.scheduler.start();
        int priorityValue = 1;
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.createMockRMApp(id11);
        Priority priority2 = Priority.newInstance((int)priorityValue);
        ApplicationPlacementContext placementCtx = new ApplicationPlacementContext("root.queue1");
        this.scheduler.addApplication(id11.getApplicationId(), "root.queue1", "user1", false, placementCtx);
        this.scheduler.addApplicationAttempt(id11, false, false);
        final FSAppAttempt fsAppAttempt = (FSAppAttempt)this.scheduler.getApplicationAttempt(id11);
        String hostName = "127.0.0.1";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 1, hostName);
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(1024, 8, node1.getRackName(), priorityValue, 1, true);
        ResourceRequest request2 = this.createResourceRequest(1024, 8, "*", priorityValue, 1, true);
        ask1.add(request1);
        ask1.add(request2);
        this.scheduler.allocate(id11, ask1, null, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        FSSchedulerNode node = (FSSchedulerNode)this.scheduler.getSchedulerNode(node1.getNodeID());
        this.mockClock.tickSec(delayThresholdTimeMs / 1000);
        this.scheduler.attemptScheduling(node);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return fsAppAttempt.getLastScheduledContainer().size() != 0;
            }
        }, (long)10L, (long)4000L);
        Map lastScheduledContainer = fsAppAttempt.getLastScheduledContainer();
        long initSchedulerTime = (Long)lastScheduledContainer.get(TestUtils.toSchedulerKey(priority2));
        Assert.assertEquals((long)delayThresholdTimeMs, (long)initSchedulerTime);
    }

    private void triggerSchedulingAttempt() throws InterruptedException {
        Thread.sleep(2 * this.scheduler.getConf().getContinuousSchedulingSleepMs());
    }
}

