/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FakeSchedulable
implements Schedulable {
    private Resource usage;
    private final Resource demand;
    private final Resource minShare;
    private final Resource maxShare;
    private float weights;
    private final Priority priority;
    private Resource fairShare;
    private long startTime;

    public FakeSchedulable() {
        this(0, Integer.MAX_VALUE, 1.0f, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare) {
        this(minShare, Integer.MAX_VALUE, 1.0f, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, int maxShare) {
        this(minShare, maxShare, 1.0f, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, float memoryWeight) {
        this(minShare, Integer.MAX_VALUE, memoryWeight, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, int maxShare, float memoryWeight) {
        this(minShare, maxShare, memoryWeight, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, int maxShare, float weight, int fairShare, int usage, long startTime) {
        this(Resources.createResource((int)minShare, (int)0), Resources.createResource((int)maxShare, (int)0), weight, Resources.createResource((int)fairShare, (int)0), Resources.createResource((int)usage, (int)0), startTime);
    }

    public FakeSchedulable(Resource minShare, float weights) {
        this(minShare, Resources.createResource((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE), weights, Resources.createResource((int)0, (int)0), Resources.createResource((int)0, (int)0), 0L);
    }

    public FakeSchedulable(long minShare, long maxShare) {
        this(minShare, maxShare, 1.0f);
    }

    public FakeSchedulable(long minShare, long maxShare, float weights) {
        this(Resources.createResource((long)minShare, (int)0), Resources.createResource((long)maxShare, (int)0), weights, Resources.createResource((int)0, (int)0), Resources.createResource((int)0, (int)0), 0L);
    }

    public FakeSchedulable(Resource minShare, Resource maxShare, float weight, Resource fairShare, Resource usage, long startTime) {
        this.minShare = minShare;
        this.maxShare = maxShare;
        this.weights = weight;
        this.usage = usage;
        this.demand = Resources.multiply((Resource)usage, (double)2.0);
        this.priority = (Priority)Records.newRecord(Priority.class);
        this.setFairShare(fairShare);
        this.start(startTime);
    }

    public Resource assignContainer(FSSchedulerNode node) {
        return null;
    }

    public Resource getFairShare() {
        return this.fairShare;
    }

    public final void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
    }

    public Resource getDemand() {
        return this.demand;
    }

    public String getName() {
        return "FakeSchedulable" + this.hashCode();
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Resource getResourceUsage() {
        return this.usage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public float getWeight() {
        return this.weights;
    }

    public Resource getMinShare() {
        return this.minShare;
    }

    public Resource getMaxShare() {
        return this.maxShare;
    }

    public void updateDemand() {
    }

    public boolean isPreemptable() {
        return true;
    }

    public void setResourceUsage(Resource resourceUsage) {
        this.usage = resourceUsage;
    }

    public final void start(long time) {
        this.startTime = time;
    }
}

