/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.GenericDiagnosticsCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.MemoryPlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintsUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplicationsNamespace;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPlacementConstraintsUtil {
    private List<RMNode> rmNodes;
    private RMContext rmContext;
    private static final int GB = 1024;
    private ApplicationId appId1;
    private PlacementConstraint c1;
    private PlacementConstraint c2;
    private PlacementConstraint c3;
    private PlacementConstraint c4;
    private PlacementConstraint c5;
    private PlacementConstraint c6;
    private PlacementConstraint c7;
    private Set<String> sourceTag1;
    private Set<String> sourceTag2;
    private Map<Set<String>, PlacementConstraint> constraintMap1;
    private Map<Set<String>, PlacementConstraint> constraintMap2;
    private Map<Set<String>, PlacementConstraint> constraintMap3;
    private Map<Set<String>, PlacementConstraint> constraintMap4;
    private AtomicLong requestID = new AtomicLong(0L);

    @Before
    public void setup() {
        MockRM rm = new MockRM();
        rm.start();
        MockNodes.resetHostIds();
        this.rmNodes = MockNodes.newNodes(2, 2, Resource.newInstance((int)4096, (int)4));
        for (RMNode rmNode : this.rmNodes) {
            rm.getRMContext().getRMNodes().putIfAbsent(rmNode.getNodeID(), rmNode);
        }
        this.rmContext = rm.getRMContext();
        long ts = System.currentTimeMillis();
        this.appId1 = BuilderUtils.newApplicationId((long)ts, (int)123);
        this.c1 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})}));
        this.c2 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-rs"})}));
        this.c3 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})}));
        this.c4 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-rs"})}));
        this.c5 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[]{"spark"})}));
        this.c6 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-rs"})})}));
        this.c7 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})}), PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-rs"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})})})}));
        this.sourceTag1 = new HashSet<String>(Arrays.asList("spark"));
        this.sourceTag2 = new HashSet<String>(Arrays.asList("zk"));
        this.constraintMap1 = Stream.of(new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag1, this.c1), new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag2, this.c2)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.constraintMap2 = Stream.of(new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag1, this.c3), new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag2, this.c4)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.constraintMap3 = Stream.of(new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag1, this.c5)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.constraintMap4 = Stream.of(new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag1, this.c6), new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag2, this.c7)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private SchedulingRequest createSchedulingRequest(Set<String> allocationTags, PlacementConstraint constraint) {
        return SchedulingRequest.newInstance((long)this.requestID.incrementAndGet(), (Priority)Priority.newInstance((int)0), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance(), allocationTags, (ResourceSizing)ResourceSizing.newInstance((Resource)Resource.newInstance((int)1024, (int)3)), (PlacementConstraint)constraint);
    }

    private SchedulingRequest createSchedulingRequest(Set<String> allocationTags) {
        return this.createSchedulingRequest(allocationTags, null);
    }

    private ContainerId newContainerId(ApplicationId appId) {
        return ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0), (long)0L);
    }

    private ContainerId newContainerId(ApplicationId appId, int containerId) {
        return ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0), (long)containerId);
    }

    private SchedulerNode newSchedulerNode(String hostname, String rackName, NodeId nodeId) {
        SchedulerNode node = (SchedulerNode)Mockito.mock(SchedulerNode.class);
        Mockito.when((Object)node.getNodeName()).thenReturn((Object)hostname);
        Mockito.when((Object)node.getRackName()).thenReturn((Object)rackName);
        Mockito.when((Object)node.getNodeID()).thenReturn((Object)nodeId);
        return node;
    }

    @Test
    public void testNodeAffinityAssignment() throws InvalidAllocationTagsQueryException {
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        pcm.registerApplication(this.appId1, this.constraintMap1);
        for (RMNode currentNode : this.rmNodes) {
            SchedulerNode schedulerNode = this.newSchedulerNode(currentNode.getHostName(), currentNode.getRackName(), currentNode.getNodeID());
            Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
            Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        }
        RMNode n0_r1 = this.rmNodes.get(0);
        RMNode n1_r1 = this.rmNodes.get(1);
        RMNode n2_r2 = this.rmNodes.get(2);
        RMNode n3_r2 = this.rmNodes.get(3);
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0_r1.getHostName(), n0_r1.getRackName(), n0_r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1_r1.getHostName(), n1_r1.getRackName(), n1_r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2_r2.getHostName(), n2_r2.getRackName(), n2_r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3_r2.getHostName(), n3_r2.getRackName(), n3_r2.getNodeID());
        ContainerId hbase_m = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)this.appId1, (int)0), (long)0L);
        tm.addContainer(n0_r1.getNodeID(), hbase_m, (Set)ImmutableSet.of((Object)"hbase-m"));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        GenericDiagnosticsCollector collector = new GenericDiagnosticsCollector();
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm, Optional.of(collector)));
        Assert.assertNotNull((Object)collector.getDiagnostics());
        Assert.assertTrue((boolean)collector.getDiagnostics().contains("ALLOCATION_TAG"));
    }

    @Test
    public void testMultiTagsPlacementConstraints() throws InvalidAllocationTagsQueryException {
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        this.rmContext.setAllocationTagsManager(tm);
        this.rmContext.setPlacementConstraintManager((PlacementConstraintManager)pcm);
        HashSet<String> st1 = new HashSet<String>(Arrays.asList("X"));
        HashSet<String> st2 = new HashSet<String>(Arrays.asList("Y"));
        PlacementConstraint pc1 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"A", "B"})}));
        PlacementConstraint pc2 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"A", "B"})}));
        ImmutableMap constraintMap = ImmutableMap.of(st1, (Object)pc1, st2, (Object)pc2);
        pcm.registerApplication(this.appId1, (Map)constraintMap);
        RMNode n0_r1 = this.rmNodes.get(0);
        RMNode n1_r1 = this.rmNodes.get(1);
        RMNode n2_r2 = this.rmNodes.get(2);
        RMNode n3_r2 = this.rmNodes.get(3);
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0_r1.getHostName(), n0_r1.getRackName(), n0_r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1_r1.getHostName(), n1_r1.getRackName(), n1_r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2_r2.getHostName(), n2_r2.getRackName(), n2_r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3_r2.getHostName(), n3_r2.getRackName(), n3_r2.getNodeID());
        ContainerId ca = this.newContainerId(this.appId1, 0);
        tm.addContainer(n0_r1.getNodeID(), ca, (Set)ImmutableSet.of((Object)"A"));
        ContainerId cb = this.newContainerId(this.appId1, 1);
        tm.addContainer(n1_r1.getNodeID(), cb, (Set)ImmutableSet.of((Object)"B"));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        ContainerId ca1 = this.newContainerId(this.appId1, 2);
        tm.addContainer(n2_r2.getNodeID(), ca1, (Set)ImmutableSet.of((Object)"A"));
        ContainerId cb1 = this.newContainerId(this.appId1, 3);
        tm.addContainer(n2_r2.getNodeID(), cb1, (Set)ImmutableSet.of((Object)"B"));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(st2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
    }

    @Test
    public void testRackAffinityAssignment() throws InvalidAllocationTagsQueryException {
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        pcm.registerApplication(this.appId1, this.constraintMap1);
        RMNode n0_r1 = this.rmNodes.get(0);
        RMNode n1_r1 = this.rmNodes.get(1);
        RMNode n2_r2 = this.rmNodes.get(2);
        RMNode n3_r2 = this.rmNodes.get(3);
        ContainerId hbase_m = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)this.appId1, (int)0), (long)0L);
        tm.addContainer(n0_r1.getNodeID(), hbase_m, (Set)ImmutableSet.of((Object)"hbase-rs"));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0_r1.getHostName(), n0_r1.getRackName(), n0_r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1_r1.getHostName(), n1_r1.getRackName(), n1_r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2_r2.getHostName(), n2_r2.getRackName(), n2_r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3_r2.getHostName(), n3_r2.getRackName(), n3_r2.getNodeID());
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
    }

    @Test
    public void testNodeAntiAffinityAssignment() throws InvalidAllocationTagsQueryException {
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        pcm.registerApplication(this.appId1, this.constraintMap2);
        RMNode n0_r1 = this.rmNodes.get(0);
        RMNode n1_r1 = this.rmNodes.get(1);
        RMNode n2_r2 = this.rmNodes.get(2);
        RMNode n3_r2 = this.rmNodes.get(3);
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0_r1.getHostName(), n0_r1.getRackName(), n0_r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1_r1.getHostName(), n1_r1.getRackName(), n1_r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2_r2.getHostName(), n2_r2.getRackName(), n2_r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3_r2.getHostName(), n3_r2.getRackName(), n3_r2.getNodeID());
        ContainerId hbase_m = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)this.appId1, (int)0), (long)0L);
        tm.addContainer(n0_r1.getNodeID(), hbase_m, (Set)ImmutableSet.of((Object)"hbase-m"));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
    }

    @Test
    public void testRackAntiAffinityAssignment() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        pcm.registerApplication(this.appId1, this.constraintMap2);
        RMNode n0_r1 = this.rmNodes.get(0);
        RMNode n1_r1 = this.rmNodes.get(1);
        RMNode n2_r2 = this.rmNodes.get(2);
        RMNode n3_r2 = this.rmNodes.get(3);
        ContainerId hbase_m = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)this.appId1, (int)0), (long)0L);
        tm.addContainer(n0_r1.getNodeID(), hbase_m, (Set)ImmutableSet.of((Object)"hbase-rs"));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0_r1.getHostName(), n0_r1.getRackName(), n0_r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1_r1.getHostName(), n1_r1.getRackName(), n1_r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2_r2.getHostName(), n2_r2.getRackName(), n2_r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3_r2.getHostName(), n3_r2.getRackName(), n3_r2.getNodeID());
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
    }

    @Test
    public void testORConstraintAssignment() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        pcm.registerApplication(this.appId1, this.constraintMap4);
        RMNode n0r1 = this.rmNodes.get(0);
        RMNode n1r1 = this.rmNodes.get(1);
        RMNode n2r2 = this.rmNodes.get(2);
        RMNode n3r2 = this.rmNodes.get(3);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(this.appId1, 1), (Set)ImmutableSet.of((Object)"hbase-m"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(this.appId1, 2), (Set)ImmutableSet.of((Object)"hbase-rs"));
        Assert.assertEquals((long)1L, (long)((Long)tm.getAllocationTagsWithCount(n0r1.getNodeID()).get("hbase-m")));
        Assert.assertEquals((long)1L, (long)((Long)tm.getAllocationTagsWithCount(n2r2.getNodeID()).get("hbase-rs")));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1r1.getHostName(), n1r1.getRackName(), n1r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2r2.getHostName(), n2r2.getRackName(), n2r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3r2.getHostName(), n3r2.getRackName(), n3r2.getNodeID());
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        tm.addContainer(n3r2.getNodeID(), this.newContainerId(this.appId1, 2), (Set)ImmutableSet.of((Object)"hbase-rs"));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(this.appId1, 3), (Set)ImmutableSet.of((Object)"spark"));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
    }

    @Test
    public void testANDConstraintAssignment() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        pcm.registerApplication(this.appId1, this.constraintMap3);
        RMNode n0r1 = this.rmNodes.get(0);
        RMNode n1r1 = this.rmNodes.get(1);
        RMNode n2r2 = this.rmNodes.get(2);
        RMNode n3r2 = this.rmNodes.get(3);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(this.appId1, 0), (Set)ImmutableSet.of((Object)"hbase-m"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(this.appId1, 1), (Set)ImmutableSet.of((Object)"hbase-m"));
        Assert.assertEquals((long)1L, (long)((Long)tm.getAllocationTagsWithCount(n0r1.getNodeID()).get("hbase-m")));
        Assert.assertEquals((long)1L, (long)((Long)tm.getAllocationTagsWithCount(n2r2.getNodeID()).get("hbase-m")));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1r1.getHostName(), n1r1.getRackName(), n1r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2r2.getHostName(), n2r2.getRackName(), n2r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3r2.getHostName(), n3r2.getRackName(), n3r2.getNodeID());
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        for (int i = 0; i < 4; ++i) {
            tm.addContainer(n1r1.getNodeID(), this.newContainerId(this.appId1, i + 2), (Set)ImmutableSet.of((Object)"spark"));
        }
        Assert.assertEquals((long)4L, (long)((Long)tm.getAllocationTagsWithCount(n1r1.getNodeID()).get("spark")));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)this.appId1, (SchedulingRequest)this.createSchedulingRequest(this.sourceTag1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
    }

    @Test
    public void testGlobalAppConstraints() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        this.rmContext.setAllocationTagsManager(tm);
        this.rmContext.setPlacementConstraintManager((PlacementConstraintManager)pcm);
        long ts = System.currentTimeMillis();
        ApplicationId application1 = BuilderUtils.newApplicationId((long)ts, (int)100);
        ApplicationId application2 = BuilderUtils.newApplicationId((long)ts, (int)101);
        ApplicationId application3 = BuilderUtils.newApplicationId((long)ts, (int)102);
        RMNode n0r1 = this.rmNodes.get(0);
        RMNode n1r1 = this.rmNodes.get(1);
        RMNode n2r2 = this.rmNodes.get(2);
        RMNode n3r2 = this.rmNodes.get(3);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application1, 0), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application2, 1), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n1r1.getNodeID(), this.newContainerId(application3, 2), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n1r1.getNodeID(), this.newContainerId(application3, 3), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n1r1.getNodeID(), this.newContainerId(application3, 4), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(application1, 5), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(application1, 6), (Set)ImmutableSet.of((Object)"A"));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1r1.getHostName(), n1r1.getRackName(), n1r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2r2.getHostName(), n2r2.getRackName(), n2r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3r2.getHostName(), n3r2.getRackName(), n3r2.getNodeID());
        TargetApplicationsNamespace.All namespaceAll = new TargetApplicationsNamespace.All();
        PlacementConstraint constraint1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)namespaceAll.toString(), (String[])new String[]{"A"})}).build();
        HashMap<ImmutableSet, PlacementConstraint> constraintMap = new HashMap<ImmutableSet, PlacementConstraint>();
        ImmutableSet srcTags1 = ImmutableSet.of((Object)"A");
        constraintMap.put(srcTags1, constraint1);
        pcm.registerApplication(application1, constraintMap);
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application1);
        PlacementConstraint constraint2 = PlacementConstraints.maxCardinality((String)"node", (String)namespaceAll.toString(), (int)2, (String[])new String[]{"A"}).build();
        constraintMap.clear();
        ImmutableSet srcTags2 = ImmutableSet.of((Object)"foo");
        constraintMap.put(srcTags2, constraint2);
        pcm.registerApplication(application2, constraintMap);
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application2);
        PlacementConstraint constraint3 = PlacementConstraints.minCardinality((String)"node", (String)namespaceAll.toString(), (int)3, (String[])new String[]{"A"}).build();
        constraintMap.clear();
        ImmutableSet srcTags3 = ImmutableSet.of((Object)"foo");
        constraintMap.put(srcTags3, constraint3);
        pcm.registerApplication(application3, constraintMap);
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags3), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags3), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags3), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags3), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application3);
    }

    @Test
    public void testNotSelfAppConstraints() throws InvalidAllocationTagsQueryException {
        long ts = System.currentTimeMillis();
        ApplicationId application1 = BuilderUtils.newApplicationId((long)ts, (int)100);
        ApplicationId application2 = BuilderUtils.newApplicationId((long)ts, (int)101);
        ApplicationId application3 = BuilderUtils.newApplicationId((long)ts, (int)102);
        ConcurrentHashMap<ApplicationId, MockRMApp> allApps = new ConcurrentHashMap<ApplicationId, MockRMApp>();
        allApps.put(application1, new MockRMApp(123, 1000L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        allApps.put(application2, new MockRMApp(124, 1001L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        allApps.put(application3, new MockRMApp(125, 1002L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        RMContext mockedContext = (RMContext)Mockito.spy((Object)this.rmContext);
        Mockito.when((Object)mockedContext.getRMApps()).thenReturn(allApps);
        AllocationTagsManager tm = new AllocationTagsManager(mockedContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        mockedContext.setAllocationTagsManager(tm);
        mockedContext.setPlacementConstraintManager((PlacementConstraintManager)pcm);
        RMNode n0r1 = this.rmNodes.get(0);
        RMNode n1r1 = this.rmNodes.get(1);
        RMNode n2r2 = this.rmNodes.get(2);
        RMNode n3r2 = this.rmNodes.get(3);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application1), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application2), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n1r1.getNodeID(), this.newContainerId(application3), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n1r1.getNodeID(), this.newContainerId(application3), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n1r1.getNodeID(), this.newContainerId(application3), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(application1), (Set)ImmutableSet.of((Object)"A"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(application1), (Set)ImmutableSet.of((Object)"A"));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1r1.getHostName(), n1r1.getRackName(), n1r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2r2.getHostName(), n2r2.getRackName(), n2r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3r2.getHostName(), n3r2.getRackName(), n3r2.getNodeID());
        TargetApplicationsNamespace.NotSelf notSelf = new TargetApplicationsNamespace.NotSelf();
        PlacementConstraint constraint1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)notSelf.toString(), (String[])new String[]{"A"})}).build();
        HashMap<ImmutableSet, PlacementConstraint> constraintMap = new HashMap<ImmutableSet, PlacementConstraint>();
        ImmutableSet srcTags1 = ImmutableSet.of((Object)"A");
        constraintMap.put(srcTags1, constraint1);
        pcm.registerApplication(application1, constraintMap);
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags1), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application1);
        PlacementConstraint constraint2 = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)notSelf.toString(), (String[])new String[]{"A"})}).build();
        HashMap<ImmutableSet, PlacementConstraint> cm2 = new HashMap<ImmutableSet, PlacementConstraint>();
        ImmutableSet srcTags2 = ImmutableSet.of((Object)"A");
        cm2.put(srcTags2, constraint2);
        pcm.registerApplication(application1, cm2);
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application1);
    }

    @Test
    public void testInterAppConstraintsByAppID() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        this.rmContext.setAllocationTagsManager(tm);
        this.rmContext.setPlacementConstraintManager((PlacementConstraintManager)pcm);
        long ts = System.currentTimeMillis();
        ApplicationId application1 = BuilderUtils.newApplicationId((long)ts, (int)123);
        ApplicationId application2 = BuilderUtils.newApplicationId((long)ts, (int)124);
        ApplicationId application3 = BuilderUtils.newApplicationId((long)ts, (int)125);
        RMNode n0r1 = this.rmNodes.get(0);
        RMNode n1r1 = this.rmNodes.get(1);
        RMNode n2r2 = this.rmNodes.get(2);
        RMNode n3r2 = this.rmNodes.get(3);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application1, 0), (Set)ImmutableSet.of((Object)"hbase-m"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(application1, 1), (Set)ImmutableSet.of((Object)"hbase-m"));
        Assert.assertEquals((long)1L, (long)((Long)tm.getAllocationTagsWithCount(n0r1.getNodeID()).get("hbase-m")));
        Assert.assertEquals((long)1L, (long)((Long)tm.getAllocationTagsWithCount(n2r2.getNodeID()).get("hbase-m")));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1r1.getHostName(), n1r1.getRackName(), n1r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2r2.getHostName(), n2r2.getRackName(), n2r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3r2.getHostName(), n3r2.getRackName(), n3r2.getNodeID());
        TargetApplicationsNamespace.AppID namespace = new TargetApplicationsNamespace.AppID(application1);
        HashMap<HashSet<String>, PlacementConstraint> constraintMap = new HashMap<HashSet<String>, PlacementConstraint>();
        PlacementConstraint constraint2 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)namespace.toString(), (String[])new String[]{"hbase-m"})}).build();
        HashSet<String> srcTags2 = new HashSet<String>();
        srcTags2.add("app2");
        constraintMap.put(srcTags2, constraint2);
        pcm.registerApplication(application2, constraintMap);
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest(srcTags2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest(srcTags2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest(srcTags2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest(srcTags2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        TargetApplicationsNamespace.Self self = new TargetApplicationsNamespace.Self();
        PlacementConstraint constraint3 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)self.toString(), (String[])new String[]{"hbase-m"})}).build();
        HashSet<String> srcTags3 = new HashSet<String>();
        srcTags3.add("app3");
        constraintMap.put(srcTags3, constraint3);
        pcm.registerApplication(application3, constraintMap);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application3, 0), (Set)ImmutableSet.of((Object)"hbase-m"));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest(srcTags3), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest(srcTags3), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest(srcTags3), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application3, (SchedulingRequest)this.createSchedulingRequest(srcTags3), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application3);
    }

    @Test
    public void testInterAppConstriantsByAppTag() throws InvalidAllocationTagsQueryException {
        ApplicationId application1 = BuilderUtils.newApplicationId((long)1000L, (int)123);
        ApplicationId application2 = BuilderUtils.newApplicationId((long)1001L, (int)124);
        RMContext mockedContext = (RMContext)Mockito.spy((Object)this.rmContext);
        ConcurrentHashMap<ApplicationId, MockRMApp> allApps = new ConcurrentHashMap<ApplicationId, MockRMApp>();
        allApps.put(application1, new MockRMApp(123, 1000L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"test-tag")));
        allApps.put(application2, new MockRMApp(124, 1001L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        Mockito.when((Object)mockedContext.getRMApps()).thenReturn(allApps);
        AllocationTagsManager tm = new AllocationTagsManager(mockedContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        mockedContext.setAllocationTagsManager(tm);
        mockedContext.setPlacementConstraintManager((PlacementConstraintManager)pcm);
        RMNode n0r1 = this.rmNodes.get(0);
        RMNode n1r1 = this.rmNodes.get(1);
        RMNode n2r2 = this.rmNodes.get(2);
        RMNode n3r2 = this.rmNodes.get(3);
        tm.addContainer(n0r1.getNodeID(), this.newContainerId(application1), (Set)ImmutableSet.of((Object)"hbase-m"));
        tm.addContainer(n2r2.getNodeID(), this.newContainerId(application1), (Set)ImmutableSet.of((Object)"hbase-m"));
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        SchedulerNode schedulerNode1 = this.newSchedulerNode(n1r1.getHostName(), n1r1.getRackName(), n1r1.getNodeID());
        SchedulerNode schedulerNode2 = this.newSchedulerNode(n2r2.getHostName(), n2r2.getRackName(), n2r2.getNodeID());
        SchedulerNode schedulerNode3 = this.newSchedulerNode(n3r2.getHostName(), n3r2.getRackName(), n3r2.getNodeID());
        TargetApplicationsNamespace.AppTag namespace = new TargetApplicationsNamespace.AppTag("test-tag");
        HashMap<ImmutableSet, PlacementConstraint> constraintMap = new HashMap<ImmutableSet, PlacementConstraint>();
        PlacementConstraint constraint2 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)namespace.toString(), (String[])new String[]{"hbase-m"})}).build();
        ImmutableSet srcTags2 = ImmutableSet.of((Object)"app2");
        constraintMap.put(srcTags2, constraint2);
        pcm.registerApplication(application2, constraintMap);
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode1, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertFalse((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode2, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        Assert.assertTrue((boolean)PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application2, (SchedulingRequest)this.createSchedulingRequest((Set<String>)srcTags2), (SchedulerNode)schedulerNode3, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm));
        pcm.unregisterApplication(application1);
        pcm.unregisterApplication(application2);
    }

    @Test
    public void testInvalidAllocationTagNamespace() {
        AllocationTagsManager tm = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager pcm = new MemoryPlacementConstraintManager();
        this.rmContext.setAllocationTagsManager(tm);
        this.rmContext.setPlacementConstraintManager((PlacementConstraintManager)pcm);
        long ts = System.currentTimeMillis();
        ApplicationId application1 = BuilderUtils.newApplicationId((long)ts, (int)123);
        RMNode n0r1 = this.rmNodes.get(0);
        SchedulerNode schedulerNode0 = this.newSchedulerNode(n0r1.getHostName(), n0r1.getRackName(), n0r1.getNodeID());
        PlacementConstraint constraint1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)"unknown_namespace", (String[])new String[]{"hbase-m"})}).build();
        HashSet<String> srcTags1 = new HashSet<String>();
        srcTags1.add("app1");
        try {
            PlacementConstraintsUtil.canSatisfyConstraints((ApplicationId)application1, (SchedulingRequest)this.createSchedulingRequest(srcTags1, constraint1), (SchedulerNode)schedulerNode0, (PlacementConstraintManager)pcm, (AllocationTagsManager)tm);
            Assert.fail((String)"This should fail because we gave an invalid namespace");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidAllocationTagsQueryException));
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid namespace prefix: unknown_namespace"));
        }
    }
}

