/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TestPlacementProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.BatchedRequests;
import org.junit.Assert;
import org.junit.Test;

public class TestBatchedRequestsIterators {
    @Test
    public void testSerialIterator() throws Exception {
        List<SchedulingRequest> schedulingRequestList = Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo"));
        BatchedRequests batchedRequests = new BatchedRequests(BatchedRequests.IteratorType.SERIAL, null, schedulingRequestList, 1);
        Iterator requestIterator = batchedRequests.iterator();
        long prevAllocId = 0L;
        while (requestIterator.hasNext()) {
            SchedulingRequest request = (SchedulingRequest)requestIterator.next();
            Assert.assertTrue((request.getAllocationRequestId() > prevAllocId ? 1 : 0) != 0);
            prevAllocId = request.getAllocationRequestId();
        }
    }

    @Test
    public void testPopularTagsIterator() throws Exception {
        List<SchedulingRequest> schedulingRequestList = Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "pri", "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo", "pri"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "test"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "pri", "bar"));
        BatchedRequests batchedRequests = new BatchedRequests(BatchedRequests.IteratorType.POPULAR_TAGS, null, schedulingRequestList, 1);
        Iterator requestIterator = batchedRequests.iterator();
        long recCcount = 0L;
        while (requestIterator.hasNext()) {
            SchedulingRequest request = (SchedulingRequest)requestIterator.next();
            if (recCcount < 3L) {
                Assert.assertTrue((boolean)request.getAllocationTags().contains("pri"));
            } else {
                Assert.assertTrue((request.getAllocationTags().contains("bar") || request.getAllocationTags().contains("test") ? 1 : 0) != 0);
            }
            ++recCcount;
        }
    }
}

