/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.LinkedList;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ConfigurationStoreBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.TestFSSchedulerConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PersistentConfigurationStoreBaseTest
extends ConfigurationStoreBaseTest {
    abstract Version getVersion();

    @Test
    public void testGetConfigurationVersion() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        long v1 = this.confStore.getConfigVersion();
        Assert.assertEquals((long)1L, (long)v1);
        this.confStore.confirmMutation(this.prepareLogMutation("keyver", "valver"), true);
        long v2 = this.confStore.getConfigVersion();
        Assert.assertEquals((long)2L, (long)v2);
        this.confStore.close();
    }

    @Test
    public void testPersistConfiguration() throws Exception {
        this.schedConf.set("key", "val");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
        this.confStore = this.createConfStore();
        this.schedConf.set("key", "badVal");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
    }

    @Test
    public void testPersistUpdatedConfiguration() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertNull((Object)this.confStore.retrieve().get("key"));
        this.confStore.confirmMutation(this.prepareLogMutation("key", "val"), true);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
        this.confStore = this.createConfStore();
        this.schedConf.set("key", "badVal");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
    }

    @Test
    public void testVersion() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertNull((Object)this.confStore.getConfStoreVersion());
        this.confStore.checkVersion();
        Assert.assertEquals((Object)this.getVersion(), (Object)this.confStore.getConfStoreVersion());
        this.confStore.close();
    }

    @Test
    public void testMaxLogs() throws Exception {
        Assume.assumeFalse((String)"test should be skipped for TestFSSchedulerConfigurationStore", (boolean)(this instanceof TestFSSchedulerConfigurationStore));
        this.conf.setLong("yarn.scheduler.configuration.store.max-logs", 2L);
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        LinkedList logs = this.confStore.getLogs();
        Assert.assertEquals((long)0L, (long)logs.size());
        YarnConfigurationStore.LogMutation mutation = this.prepareLogMutation("key1", "val1");
        logs = this.confStore.getLogs();
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        this.confStore.confirmMutation(mutation, true);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        mutation = this.prepareLogMutation("key2", "val2");
        logs = this.confStore.getLogs();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key2"));
        this.confStore.confirmMutation(mutation, true);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key2"));
        mutation = this.prepareLogMutation("key3", "val3");
        logs = this.confStore.getLogs();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key2"));
        Assert.assertEquals((Object)"val3", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key3"));
        this.confStore.confirmMutation(mutation, true);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key2"));
        Assert.assertEquals((Object)"val3", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key3"));
        this.confStore.close();
    }
}

