/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCSQueueStore {
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private CSQueue root;
    private CapacitySchedulerContext csContext;

    @Before
    public void setUp() throws IOException {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration();
        RMContext rmContext = TestUtils.getMockRMContext();
        Resource clusterResource = Resources.createResource((int)163840, (int)320);
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)rmContext);
        CSQueueStore queues = new CSQueueStore();
        this.root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
    }

    public CSQueue createLeafQueue(String name, CSQueue parent) throws IOException {
        return new LeafQueue(this.csContext, name, parent, null);
    }

    public CSQueue createParentQueue(String name, CSQueue parent) throws IOException {
        return new ParentQueue(this.csContext, name, parent, null);
    }

    public void assertAccessibleByAllNames(CSQueueStore store, CSQueue queue) {
        Assert.assertEquals((Object)queue, (Object)store.get(queue.getQueueShortName()));
        Assert.assertEquals((Object)queue, (Object)store.get(queue.getQueuePath()));
    }

    public void assertAccessibleByFullNameOnly(CSQueueStore store, CSQueue queue) {
        Assert.assertFalse((boolean)store.isAmbiguous(queue.getQueueShortName()));
        Assert.assertNotEquals((Object)queue, (Object)store.get(queue.getQueueShortName()));
        Assert.assertEquals((Object)queue, (Object)store.get(queue.getQueuePath()));
    }

    public void assertAmbiguous(CSQueueStore store, CSQueue queue) {
        Assert.assertTrue((boolean)store.isAmbiguous(queue.getQueueShortName()));
        Assert.assertNull((Object)store.get(queue.getQueueShortName()));
        Assert.assertEquals((Object)queue, (Object)store.get(queue.getQueuePath()));
    }

    public void assertQueueNotPresent(CSQueueStore store, CSQueue queue) {
        Assert.assertNotEquals((Object)queue, (Object)store.get(queue.getQueueShortName()));
        Assert.assertNull((Object)store.get(queue.getQueuePath()));
    }

    @Test
    public void testSimpleMapping() throws IOException {
        CSQueueStore store = new CSQueueStore();
        CSQueue main = this.createParentQueue("main", this.root);
        CSQueue mainA = this.createLeafQueue("A", main);
        CSQueue mainB = this.createParentQueue("B", main);
        CSQueue mainBC = this.createLeafQueue("C", mainB);
        store.add(main);
        store.add(mainA);
        store.add(mainB);
        store.add(mainBC);
        this.assertAccessibleByAllNames(store, main);
        this.assertAccessibleByAllNames(store, mainA);
        this.assertAccessibleByAllNames(store, mainB);
        this.assertAccessibleByAllNames(store, mainBC);
    }

    @Test
    public void testAmbiguousMapping() throws IOException {
        CSQueueStore store = new CSQueueStore();
        CSQueue main = this.createParentQueue("main", this.root);
        CSQueue mainA = this.createParentQueue("A", main);
        CSQueue mainAC = this.createLeafQueue("C", mainA);
        CSQueue mainAD = this.createParentQueue("D", mainA);
        CSQueue mainADE = this.createLeafQueue("E", mainAD);
        CSQueue mainADF = this.createLeafQueue("F", mainAD);
        CSQueue mainB = this.createParentQueue("B", main);
        CSQueue mainBC = this.createLeafQueue("C", mainB);
        CSQueue mainBD = this.createParentQueue("D", mainB);
        CSQueue mainBDE = this.createLeafQueue("E", mainBD);
        CSQueue mainBDG = this.createLeafQueue("G", mainBD);
        store.add(main);
        store.add(mainA);
        store.add(mainAC);
        store.add(mainAD);
        store.add(mainADE);
        store.add(mainADF);
        store.add(mainB);
        store.add(mainBC);
        store.add(mainBD);
        store.add(mainBDE);
        store.add(mainBDG);
        this.assertAccessibleByAllNames(store, main);
        this.assertAccessibleByAllNames(store, mainA);
        this.assertAccessibleByAllNames(store, mainB);
        this.assertAccessibleByAllNames(store, mainADF);
        this.assertAccessibleByAllNames(store, mainBDG);
        this.assertAmbiguous(store, mainAC);
        this.assertAmbiguous(store, mainAD);
        this.assertAmbiguous(store, mainADE);
        this.assertAmbiguous(store, mainBC);
        this.assertAmbiguous(store, mainBD);
        this.assertAmbiguous(store, mainBDE);
    }

    @Test
    public void testDynamicModifications() throws IOException {
        CSQueueStore store = new CSQueueStore();
        CSQueue main = this.createParentQueue("main", this.root);
        CSQueue mainA = this.createParentQueue("A", main);
        CSQueue mainB = this.createParentQueue("B", main);
        CSQueue mainAC = this.createLeafQueue("C", mainA);
        CSQueue mainBC = this.createLeafQueue("C", mainB);
        store.add(main);
        store.add(mainA);
        store.add(mainB);
        this.assertAccessibleByAllNames(store, main);
        this.assertAccessibleByAllNames(store, mainA);
        this.assertAccessibleByAllNames(store, mainB);
        this.assertQueueNotPresent(store, mainAC);
        this.assertQueueNotPresent(store, mainBC);
        store.add(mainAC);
        this.assertAccessibleByAllNames(store, mainAC);
        this.assertQueueNotPresent(store, mainBC);
        store.add(mainBC);
        this.assertAmbiguous(store, mainAC);
        this.assertAmbiguous(store, mainBC);
        store.remove(mainAC);
        this.assertQueueNotPresent(store, mainAC);
        this.assertAccessibleByAllNames(store, mainBC);
        store.remove(mainBC);
        this.assertQueueNotPresent(store, mainAC);
        this.assertQueueNotPresent(store, mainBC);
    }

    @Test
    public void testQueueOverwrites() throws IOException {
        CSQueueStore store = new CSQueueStore();
        CSQueue main = this.createParentQueue("main", this.root);
        CSQueue mainA = this.createLeafQueue("A", main);
        CSQueue newA = this.createLeafQueue("A", main);
        store.add(main);
        store.add(mainA);
        this.assertAccessibleByAllNames(store, mainA);
        store.add(newA);
        this.assertAccessibleByAllNames(store, newA);
    }

    @Test
    public void testQueueReferencePrecedence() throws IOException {
        CSQueueStore store = new CSQueueStore();
        CSQueue main = this.createParentQueue("main", this.root);
        CSQueue mainA = this.createParentQueue("A", main);
        CSQueue mainAB = this.createLeafQueue("B", mainA);
        CSQueue second = this.createParentQueue("second", this.root);
        CSQueue secondA = this.createParentQueue("A", second);
        CSQueue secondAD = this.createParentQueue("D", secondA);
        CSQueue secondADB = this.createParentQueue("B", secondAD);
        CSQueue secondADBC = this.createLeafQueue("C", secondADB);
        store.add(main);
        store.add(mainA);
        store.add(mainAB);
        store.add(second);
        store.add(secondA);
        store.add(secondAD);
        store.add(secondADB);
        store.add(secondADBC);
        this.assertAccessibleByAllNames(store, main);
        this.assertAccessibleByAllNames(store, second);
        this.assertAmbiguous(store, mainA);
        this.assertAmbiguous(store, secondA);
        this.assertAmbiguous(store, mainAB);
        this.assertAccessibleByAllNames(store, secondAD);
        this.assertAmbiguous(store, secondADB);
        this.assertAccessibleByAllNames(store, secondADBC);
    }

    @Test
    public void testRootIsAlwaysAccesible() throws IOException {
        CSQueueStore store = new CSQueueStore();
        CSQueue rootroot = this.createParentQueue("root", this.root);
        store.add(this.root);
        store.add(rootroot);
        this.assertAccessibleByAllNames(store, this.root);
        this.assertAccessibleByFullNameOnly(store, rootroot);
        Assert.assertFalse((boolean)store.isAmbiguous("root"));
    }
}

