/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicyFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.DefaultConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.QueueAdminConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestConfigurationMutationACLPolicies {
    private ConfigurationMutationACLPolicy policy;
    private RMContext rmContext;
    private MutableConfScheduler scheduler;
    private static final UserGroupInformation GOOD_USER = UserGroupInformation.createUserForTesting((String)"goodUser", (String[])new String[0]);
    private static final UserGroupInformation BAD_USER = UserGroupInformation.createUserForTesting((String)"badUser", (String[])new String[0]);
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();

    @Before
    public void setUp() throws IOException {
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.scheduler = (MutableConfScheduler)Mockito.mock(MutableConfScheduler.class);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)this.scheduler);
        this.mockQueue("a", this.scheduler);
        this.mockQueue("b", this.scheduler);
        this.mockQueue("b1", this.scheduler);
    }

    private void mockQueue(String queueName, MutableConfScheduler scheduler) throws IOException {
        QueueInfo queueInfo = QueueInfo.newInstance((String)queueName, (float)0.0f, (float)0.0f, (float)0.0f, null, null, null, null, null, null, (boolean)false, null, (boolean)false);
        Mockito.when((Object)scheduler.getQueueInfo((String)ArgumentMatchers.eq((Object)queueName), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)queueInfo);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)queue.hasAccess((QueueACL)ArgumentMatchers.eq((Object)QueueACL.ADMINISTER_QUEUE), (UserGroupInformation)ArgumentMatchers.eq((Object)GOOD_USER))).thenReturn((Object)true);
        Mockito.when((Object)queue.hasAccess((QueueACL)ArgumentMatchers.eq((Object)QueueACL.ADMINISTER_QUEUE), (UserGroupInformation)ArgumentMatchers.eq((Object)BAD_USER))).thenReturn((Object)false);
        Mockito.when((Object)scheduler.getQueue((String)ArgumentMatchers.eq((Object)queueName))).thenReturn((Object)queue);
    }

    @Test
    public void testDefaultPolicy() {
        Configuration conf = new Configuration();
        conf.set("yarn.admin.acl", GOOD_USER.getShortUserName());
        conf.setClass("yarn.scheduler.configuration.mutation.acl-policy.class", DefaultConfigurationMutationACLPolicy.class, ConfigurationMutationACLPolicy.class);
        this.policy = ConfigurationMutationACLPolicyFactory.getPolicy((Configuration)conf);
        this.policy.init(conf, this.rmContext);
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, null));
        Assert.assertFalse((boolean)this.policy.isMutationAllowed(BAD_USER, null));
    }

    @Test
    public void testQueueAdminBasedPolicy() {
        Configuration conf = new Configuration();
        conf.setClass("yarn.scheduler.configuration.mutation.acl-policy.class", QueueAdminConfigurationMutationACLPolicy.class, ConfigurationMutationACLPolicy.class);
        this.policy = ConfigurationMutationACLPolicyFactory.getPolicy((Configuration)conf);
        this.policy.init(conf, this.rmContext);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        QueueConfigInfo configInfo = new QueueConfigInfo("root.a", EMPTY_MAP);
        updateInfo.getUpdateQueueInfo().add(configInfo);
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, updateInfo));
        Assert.assertFalse((boolean)this.policy.isMutationAllowed(BAD_USER, updateInfo));
    }

    @Test
    public void testQueueAdminPolicyAddQueue() {
        Configuration conf = new Configuration();
        conf.setClass("yarn.scheduler.configuration.mutation.acl-policy.class", QueueAdminConfigurationMutationACLPolicy.class, ConfigurationMutationACLPolicy.class);
        this.policy = ConfigurationMutationACLPolicyFactory.getPolicy((Configuration)conf);
        this.policy.init(conf, this.rmContext);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        QueueConfigInfo configInfo = new QueueConfigInfo("root.b.b2", EMPTY_MAP);
        updateInfo.getAddQueueInfo().add(configInfo);
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, updateInfo));
        Assert.assertFalse((boolean)this.policy.isMutationAllowed(BAD_USER, updateInfo));
    }

    @Test
    public void testQueueAdminPolicyAddNestedQueue() {
        Configuration conf = new Configuration();
        conf.setClass("yarn.scheduler.configuration.mutation.acl-policy.class", QueueAdminConfigurationMutationACLPolicy.class, ConfigurationMutationACLPolicy.class);
        this.policy = ConfigurationMutationACLPolicyFactory.getPolicy((Configuration)conf);
        this.policy.init(conf, this.rmContext);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        QueueConfigInfo configInfo = new QueueConfigInfo("root.b.b2.b21", EMPTY_MAP);
        updateInfo.getAddQueueInfo().add(configInfo);
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, updateInfo));
        Assert.assertFalse((boolean)this.policy.isMutationAllowed(BAD_USER, updateInfo));
    }

    @Test
    public void testQueueAdminPolicyRemoveQueue() {
        Configuration conf = new Configuration();
        conf.setClass("yarn.scheduler.configuration.mutation.acl-policy.class", QueueAdminConfigurationMutationACLPolicy.class, ConfigurationMutationACLPolicy.class);
        this.policy = ConfigurationMutationACLPolicyFactory.getPolicy((Configuration)conf);
        this.policy.init(conf, this.rmContext);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.b.b1");
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, updateInfo));
        Assert.assertFalse((boolean)this.policy.isMutationAllowed(BAD_USER, updateInfo));
    }

    @Test
    public void testQueueAdminPolicyGlobal() {
        Configuration conf = new Configuration();
        conf.set("yarn.admin.acl", GOOD_USER.getShortUserName());
        conf.setClass("yarn.scheduler.configuration.mutation.acl-policy.class", QueueAdminConfigurationMutationACLPolicy.class, ConfigurationMutationACLPolicy.class);
        this.policy = ConfigurationMutationACLPolicyFactory.getPolicy((Configuration)conf);
        this.policy.init(conf, this.rmContext);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, updateInfo));
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(BAD_USER, updateInfo));
        updateInfo.getGlobalParams().put("globalKey", "globalValue");
        Assert.assertTrue((boolean)this.policy.isMutationAllowed(GOOD_USER, updateInfo));
        Assert.assertFalse((boolean)this.policy.isMutationAllowed(BAD_USER, updateInfo));
    }
}

