/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.OpportunisticContainerAllocatorAMService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeDecommissioningEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockRM
extends ResourceManager {
    static final Logger LOG = LoggerFactory.getLogger(MockRM.class);
    static final String ENABLE_WEBAPP = "mockrm.webapp.enabled";
    private static final int SECOND = 1000;
    private static final int TIMEOUT_MS_FOR_ATTEMPT = 40000;
    private static final int TIMEOUT_MS_FOR_APP_REMOVED = 40000;
    private static final int TIMEOUT_MS_FOR_CONTAINER_AND_NODE = 20000;
    private static final int WAIT_MS_PER_LOOP = 10;
    static final String ENABLE_STATUS_SERVER = "mockrm.status.server.enabled";
    private final boolean useNullRMNodeLabelsManager;
    private boolean disableDrainEventsImplicitly;
    private boolean useRealElector = false;

    public MockRM() {
        this((Configuration)new YarnConfiguration());
    }

    public MockRM(Configuration conf) {
        this(conf, null);
    }

    public MockRM(Configuration conf, RMStateStore store) {
        this(conf, store, true, false);
    }

    public MockRM(Configuration conf, boolean useRealElector) {
        this(conf, null, true, useRealElector);
    }

    public MockRM(Configuration conf, RMStateStore store, boolean useRealElector) {
        this(conf, store, true, useRealElector);
    }

    public MockRM(Configuration conf, RMStateStore store, boolean useNullRMNodeLabelsManager, boolean useRealElector) {
        DefaultMetricsSystem.shutdown();
        QueueMetrics.clearQueueMetrics();
        if (conf.getBoolean("yarn.test.reset-resource-types", true)) {
            ResourceUtils.resetResourceTypes((Configuration)conf);
        }
        this.useNullRMNodeLabelsManager = useNullRMNodeLabelsManager;
        this.useRealElector = useRealElector;
        conf.set("yarn.webapp.api-service.enable", "false");
        this.init((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
        if (store != null) {
            this.setRMStateStore(store);
        } else {
            Class<?> storeClass = this.getRMContext().getStateStore().getClass();
            if (storeClass.equals(MemoryRMStateStore.class)) {
                MockMemoryRMStateStore mockStateStore = new MockMemoryRMStateStore();
                mockStateStore.init(conf);
                this.setRMStateStore((RMStateStore)mockStateStore);
            } else if (storeClass.equals(NullRMStateStore.class)) {
                MockRMNullStateStore mockStateStore = new MockRMNullStateStore();
                mockStateStore.init(conf);
                this.setRMStateStore((RMStateStore)mockStateStore);
            }
        }
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        this.disableDrainEventsImplicitly = false;
    }

    protected RMNodeLabelsManager createNodeLabelManager() throws InstantiationException, IllegalAccessException {
        if (this.useNullRMNodeLabelsManager) {
            NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
            mgr.init(this.getConfig());
            return mgr;
        }
        return super.createNodeLabelManager();
    }

    protected Dispatcher createDispatcher() {
        return new DrainDispatcher();
    }

    protected EmbeddedElector createEmbeddedElector() throws IOException {
        if (this.useRealElector) {
            return super.createEmbeddedElector();
        }
        return null;
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        return new EventHandler<SchedulerEvent>(){

            public void handle(SchedulerEvent event) {
                MockRM.this.scheduler.handle((Event)event);
            }
        };
    }

    public void drainEvents() {
        Dispatcher rmDispatcher = this.getRmDispatcher();
        if (!(rmDispatcher instanceof DrainDispatcher)) {
            throw new UnsupportedOperationException("Not a Drain Dispatcher!");
        }
        ((DrainDispatcher)rmDispatcher).await();
    }

    private void waitForState(ApplicationId appId, EnumSet<RMAppState> finalStates) throws InterruptedException {
        this.drainEventsImplicitly();
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        int timeoutMsecs = 80000;
        for (int timeWaiting = 0; !finalStates.contains(app.getState()) && timeWaiting < 80000; timeWaiting += 10) {
            LOG.info("App : " + appId + " State is : " + app.getState() + " Waiting for state : " + finalStates);
            Thread.sleep(10L);
        }
        LOG.info("App State is : " + app.getState());
        Assert.assertTrue((String)"App State is not correct (timeout).", (boolean)finalStates.contains(app.getState()));
    }

    public void waitForState(ApplicationId appId, RMAppState finalState) throws InterruptedException {
        this.drainEventsImplicitly();
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        int timeoutMsecs = 80000;
        for (int timeWaiting = 0; !finalState.equals((Object)app.getState()) && timeWaiting < 80000; timeWaiting += 10) {
            LOG.info("App : " + appId + " State is : " + app.getState() + " Waiting for state : " + finalState);
            Thread.sleep(10L);
        }
        LOG.info("App State is : " + app.getState());
        Assert.assertEquals((String)"App State is not correct (timeout).", (Object)finalState, (Object)app.getState());
    }

    public void waitForState(ApplicationAttemptId attemptId, RMAppAttemptState finalState) throws InterruptedException {
        this.waitForState(attemptId, finalState, 40000);
    }

    public void waitForState(ApplicationAttemptId attemptId, RMAppAttemptState finalState, int timeoutMsecs) throws InterruptedException {
        this.drainEventsImplicitly();
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(attemptId.getApplicationId());
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        RMAppAttempt attempt = app.getRMAppAttempt(attemptId);
        MockRM.waitForState(attempt, finalState, timeoutMsecs);
    }

    public static void waitForState(RMAppAttempt attempt, RMAppAttemptState finalState) throws InterruptedException {
        MockRM.waitForState(attempt, finalState, 40000);
    }

    public static void waitForState(RMAppAttempt attempt, RMAppAttemptState finalState, int timeoutMsecs) throws InterruptedException {
        for (int timeWaiting = 0; finalState != attempt.getAppAttemptState() && timeWaiting < timeoutMsecs; timeWaiting += 10) {
            LOG.info("AppAttempt : " + attempt.getAppAttemptId() + " State is : " + attempt.getAppAttemptState() + " Waiting for state : " + finalState);
            Thread.sleep(10L);
        }
        LOG.info("Attempt State is : " + attempt.getAppAttemptState());
        Assert.assertEquals((String)"Attempt state is not correct (timeout).", (Object)finalState, (Object)attempt.getState());
    }

    public void waitForContainerToComplete(RMAppAttempt attempt, NMContainerStatus completedContainer) throws InterruptedException {
        this.drainEventsImplicitly();
        for (int timeWaiting = 0; timeWaiting < 20000; timeWaiting += 10) {
            List containers = attempt.getJustFinishedContainers();
            LOG.info("Received completed containers " + containers);
            for (ContainerStatus container : containers) {
                if (!container.getContainerId().equals((Object)completedContainer.getContainerId())) continue;
                return;
            }
            Thread.sleep(10L);
        }
    }

    public MockAM waitForNewAMToLaunchAndRegister(ApplicationId appId, int attemptSize, MockNM nm) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((Object)app);
        for (int timeWaiting = 0; app.getAppAttempts().size() != attemptSize && timeWaiting < 40000; timeWaiting += 10) {
            LOG.info("Application " + appId + " is waiting for AM to restart. Current has " + app.getAppAttempts().size() + " attempts.");
            Thread.sleep(10L);
        }
        return MockRM.launchAndRegisterAM(app, this, nm);
    }

    public boolean waitForState(MockNM nm, ContainerId containerId, RMContainerState containerState) throws Exception {
        return this.waitForState(nm, containerId, containerState, 20000);
    }

    public boolean waitForState(MockNM nm, ContainerId containerId, RMContainerState containerState, int timeoutMsecs) throws Exception {
        return this.waitForState(Arrays.asList(nm), containerId, containerState, timeoutMsecs);
    }

    public boolean waitForState(Collection<MockNM> nms, ContainerId containerId, RMContainerState containerState) throws Exception {
        return this.waitForState(nms, containerId, containerState, 20000);
    }

    public boolean waitForState(Collection<MockNM> nms, ContainerId containerId, RMContainerState containerState, int timeoutMsecs) throws Exception {
        this.drainEventsImplicitly();
        RMContainer container = this.getResourceScheduler().getRMContainer(containerId);
        int timeWaiting = 0;
        while (container == null) {
            if (timeWaiting >= timeoutMsecs) {
                return false;
            }
            for (MockNM nm : nms) {
                nm.nodeHeartbeat(true);
            }
            this.drainEventsImplicitly();
            container = this.getResourceScheduler().getRMContainer(containerId);
            LOG.info("Waiting for container " + containerId + " to be " + containerState + ", container is null right now.");
            Thread.sleep(10L);
            timeWaiting += 10;
        }
        while (!containerState.equals((Object)container.getState())) {
            if (timeWaiting >= timeoutMsecs) {
                return false;
            }
            LOG.info("Container : " + containerId + " State is : " + container.getState() + " Waiting for state : " + containerState);
            for (MockNM nm : nms) {
                nm.nodeHeartbeat(true);
            }
            this.drainEventsImplicitly();
            Thread.sleep(10L);
            timeWaiting += 10;
        }
        LOG.info("Container State is : " + container.getState());
        return true;
    }

    public GetNewApplicationResponse getNewAppId() throws Exception {
        ClientRMService client = this.getClientRMService();
        return client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
    }

    public MockNM unRegisterNode(MockNM nm) throws Exception {
        nm.unRegisterNode();
        this.drainEventsImplicitly();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, this.getResourceTrackerService());
        nm.registerNode();
        this.drainEventsImplicitly();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, this.getResourceTrackerService());
        nm.registerNode();
        this.drainEventsImplicitly();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores, List<ApplicationId> runningApplications) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, this.getResourceTrackerService(), YarnVersionInfo.getVersion());
        nm.registerNode(runningApplications);
        this.drainEventsImplicitly();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, Resource nodeCapability) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, nodeCapability, this.getResourceTrackerService());
        nm.registerNode();
        this.drainEventsImplicitly();
        return nm;
    }

    public void sendNodeStarted(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        node.handle((RMNodeEvent)new RMNodeStartedEvent(nm.getNodeId(), null, null, mockNodeStatus));
        this.drainEventsImplicitly();
    }

    public void sendNodeLost(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle(new RMNodeEvent(nm.getNodeId(), RMNodeEventType.EXPIRE));
        this.drainEventsImplicitly();
    }

    private RMNode getRMNode(NodeId nodeId) {
        RMNode node = (RMNode)this.getRMContext().getRMNodes().get(nodeId);
        if (node == null) {
            node = (RMNode)this.getRMContext().getInactiveRMNodes().get(nodeId);
        }
        return node;
    }

    public void waitForState(NodeId nodeId, NodeState finalState) throws InterruptedException {
        int timeWaiting;
        this.drainEventsImplicitly();
        RMNode node = this.getRMNode(nodeId);
        for (timeWaiting = 0; node == null && timeWaiting < 20000; timeWaiting += 10) {
            node = this.getRMNode(nodeId);
            Thread.sleep(10L);
        }
        Assert.assertNotNull((String)"node shouldn't be null (timedout)", (Object)node);
        while (!finalState.equals((Object)node.getState()) && timeWaiting < 20000) {
            LOG.info("Node State is : " + node.getState() + " Waiting for state : " + finalState);
            Thread.sleep(10L);
            timeWaiting += 10;
        }
        LOG.info("Node " + nodeId + " State is : " + node.getState());
        Assert.assertEquals((String)"Node state is not correct (timedout)", (Object)finalState, (Object)node.getState());
    }

    public void sendNodeGracefulDecommission(MockNM nm, int timeout) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        Assert.assertNotNull((String)"node shouldn't be null", (Object)node);
        node.handle((RMNodeEvent)new RMNodeDecommissioningEvent(nm.getNodeId(), Integer.valueOf(timeout)));
    }

    public void sendNodeEvent(MockNM nm, RMNodeEventType event) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        Assert.assertNotNull((String)"node shouldn't be null", (Object)node);
        node.handle(new RMNodeEvent(nm.getNodeId(), event));
    }

    public Integer getDecommissioningTimeout(NodeId nodeid) {
        return ((RMNode)this.getRMContext().getRMNodes().get(nodeid)).getDecommissioningTimeout();
    }

    public KillApplicationResponse killApp(ApplicationId appId) throws Exception {
        ClientRMService client = this.getClientRMService();
        KillApplicationRequest req = KillApplicationRequest.newInstance((ApplicationId)appId);
        KillApplicationResponse response = client.forceKillApplication(req);
        this.drainEventsImplicitly();
        return response;
    }

    public FailApplicationAttemptResponse failApplicationAttempt(ApplicationAttemptId attemptId) throws Exception {
        ClientRMService client = this.getClientRMService();
        FailApplicationAttemptRequest req = FailApplicationAttemptRequest.newInstance((ApplicationAttemptId)attemptId);
        FailApplicationAttemptResponse response = client.failApplicationAttempt(req);
        this.drainEventsImplicitly();
        return response;
    }

    public MockAM sendAMLaunched(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        ((AbstractYarnScheduler)this.scheduler).update();
        this.waitForState(appAttemptId, RMAppAttemptState.ALLOCATED);
        Token amrmToken = this.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttemptId);
        ((RMAppAttemptImpl)((RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId())).getRMAppAttempt(appAttemptId)).setAMRMToken(amrmToken);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.LAUNCHED));
        this.drainEventsImplicitly();
        return am;
    }

    public void sendAMLaunchFailed(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        this.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.ALLOCATED);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.LAUNCH_FAILED, "Failed"));
        this.drainEventsImplicitly();
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.getRMContext(), (YarnScheduler)this.getResourceScheduler(), this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager()){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ResourceTrackerService createResourceTrackerService() {
        RMContainerTokenSecretManager containerTokenSecretManager = this.getRMContext().getContainerTokenSecretManager();
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = this.getRMContext().getNMTokenSecretManager();
        nmTokenSecretManager.rollMasterKey();
        return new ResourceTrackerService(this.getRMContext(), this.nodesListManager, this.nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterService createApplicationMasterService() {
        if (this.rmContext.getYarnConfiguration().getBoolean("yarn.resourcemanager.opportunistic-container-allocation.enabled", false)) {
            return new OpportunisticContainerAllocatorAMService(this.getRMContext(), (YarnScheduler)this.scheduler){

                protected void serviceStart() {
                }

                protected void serviceStop() {
                }
            };
        }
        return new ApplicationMasterService(this.getRMContext(), (YarnScheduler)this.scheduler){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.getRMContext()){

            protected void serviceStart() {
            }

            public void handle(AMLauncherEvent appEvent) {
            }

            protected void serviceStop() {
            }
        };
    }

    protected AdminService createAdminService() {
        return new AdminService(this){

            protected void startServer() {
            }

            protected void stopServer() {
            }
        };
    }

    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.getRMContext().getClientToAMTokenSecretManager();
    }

    public RMAppManager getRMAppManager() {
        return this.rmAppManager;
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    protected void startWepApp() {
        if (this.getConfig().getBoolean(ENABLE_WEBAPP, false)) {
            super.startWepApp();
            return;
        }
    }

    protected void startStatusServer(Configuration conf) throws Exception {
        if (this.getConfig().getBoolean(ENABLE_STATUS_SERVER, false)) {
            super.startStatusServer(conf);
        }
    }

    public static void finishAMAndVerifyAppState(RMApp rmApp, MockRM rm, MockNM nm, MockAM am) throws Exception {
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        am.unregisterAppAttempt(req, true);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHING);
        nm.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm.drainEventsImplicitly();
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        rm.waitForState(rmApp.getApplicationId(), RMAppState.FINISHED);
    }

    private static void waitForSchedulerAppAttemptAdded(ApplicationAttemptId attemptId, MockRM rm) throws InterruptedException {
        rm.drainEventsImplicitly();
        for (int tick = 0; null == ((AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(attemptId) && tick < 50; ++tick) {
            Thread.sleep(100L);
            if (tick % 10 != 0) continue;
            LOG.info("waiting for SchedulerApplicationAttempt=" + attemptId + " added.");
        }
        Assert.assertNotNull((String)("Timed out waiting for SchedulerApplicationAttempt=" + attemptId + " to be added."), (Object)((AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(attemptId));
    }

    public static MockAM launchAMWhenAsyncSchedulingEnabled(RMApp app, MockRM rm) throws Exception {
        int i = 0;
        while (app.getCurrentAppAttempt() == null) {
            if (i < 100) {
                ++i;
            }
            Thread.sleep(50L);
        }
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.ALLOCATED);
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        return am;
    }

    public static MockAM launchAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        rm.drainEventsImplicitly();
        RMAppAttempt attempt = MockRM.waitForAttemptScheduled(app, rm);
        LOG.info("Launch AM " + attempt.getAppAttemptId());
        nm.nodeHeartbeat(true);
        ((AbstractYarnScheduler)rm.getResourceScheduler()).update();
        rm.drainEventsImplicitly();
        nm.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        return am;
    }

    public static MockAM launchUAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        rm.drainEventsImplicitly();
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockRM.waitForSchedulerAppAttemptAdded(attempt.getAppAttemptId(), rm);
        LOG.info("Launch AM " + attempt.getAppAttemptId());
        nm.nodeHeartbeat(true);
        ((AbstractYarnScheduler)rm.getResourceScheduler()).update();
        rm.drainEventsImplicitly();
        nm.nodeHeartbeat(true);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.masterService, attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        return am;
    }

    public static RMAppAttempt waitForAttemptScheduled(RMApp app, MockRM rm) throws Exception {
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockRM.waitForSchedulerAppAttemptAdded(attempt.getAppAttemptId(), rm);
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        return attempt;
    }

    public static MockAM launchAndRegisterAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        MockAM am = MockRM.launchAM(app, rm, nm);
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }

    public static MockAM launchAndRegisterAM(RMApp app, MockRM rm, MockNM nm, Map<Set<String>, PlacementConstraint> constraints) throws Exception {
        MockAM am = MockRM.launchAM(app, rm, nm);
        for (Map.Entry<Set<String>, PlacementConstraint> e : constraints.entrySet()) {
            am.addPlacementConstraint(e.getKey(), e.getValue());
        }
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        ClientRMService client = this.getClientRMService();
        GetApplicationReportResponse response = client.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId));
        return response.getApplicationReport();
    }

    public void updateReservationState(ReservationUpdateRequest request) throws IOException, YarnException {
        ClientRMService client = this.getClientRMService();
        client.updateReservation(request);
        this.drainEventsImplicitly();
    }

    public void clearQueueMetrics(RMApp app) {
        ((SchedulerApplication)((AbstractYarnScheduler)this.getResourceScheduler()).getSchedulerApplications().get(app.getApplicationId())).getQueue().getMetrics();
        QueueMetrics.clearQueueMetrics();
    }

    public ResourceManager.RMActiveServices getRMActiveService() {
        return this.activeServices;
    }

    public void signalToContainer(ContainerId containerId, SignalContainerCommand command) throws Exception {
        ClientRMService client = this.getClientRMService();
        SignalContainerRequest req = SignalContainerRequest.newInstance((ContainerId)containerId, (SignalContainerCommand)command);
        client.signalToContainer(req);
        this.drainEventsImplicitly();
    }

    public void waitForAppRemovedFromScheduler(ApplicationId appId) throws InterruptedException {
        this.drainEventsImplicitly();
        Map apps = ((AbstractYarnScheduler)this.getResourceScheduler()).getSchedulerApplications();
        for (int timeWaiting = 0; apps.containsKey(appId) && timeWaiting < 40000; timeWaiting += 10) {
            LOG.info("wait for app removed, " + appId);
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"app is not removed from scheduler (timeout).", (!apps.containsKey(appId) ? 1 : 0) != 0);
        LOG.info("app is removed from scheduler, " + appId);
    }

    private void drainEventsImplicitly() {
        if (!this.disableDrainEventsImplicitly) {
            this.drainEvents();
        }
    }

    public void disableDrainEventsImplicitly() {
        this.disableDrainEventsImplicitly = true;
    }

    public void enableDrainEventsImplicityly() {
        this.disableDrainEventsImplicitly = false;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        if (this.getRmDispatcher() instanceof AsyncDispatcher) {
            ((AsyncDispatcher)this.getRmDispatcher()).disableExitOnDispatchException();
        }
    }

    public RMStateStore getRMStateStore() {
        return this.getRMContext().getStateStore();
    }

    public class MockRMNullStateStore
    extends NullRMStateStore {
        protected EventHandler getRMStateStoreEventHandler() {
            return this.rmStateStoreEventHandler;
        }
    }
}

