/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.metrics.OpportunisticSchedulerMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.CentralizedOpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.NodeQueueLoadMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.TestNodeQueueLoadMonitor;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCentralizedOpportunisticContainerAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(TestCentralizedOpportunisticContainerAllocator.class);
    private static final int GB = 1024;
    private CentralizedOpportunisticContainerAllocator allocator = null;
    private OpportunisticContainerContext oppCntxt = null;
    private static final Priority PRIORITY_NORMAL = Priority.newInstance((int)1);
    private static final Resource CAPABILITY_1GB = Resources.createResource((int)1024);
    private static final ResourceBlacklistRequest EMPTY_BLACKLIST_REQUEST = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());

    @Before
    public void setup() {
        final MasterKey mKey = new MasterKey(){

            public int getKeyId() {
                return 1;
            }

            public void setKeyId(int keyId) {
            }

            public ByteBuffer getBytes() {
                return ByteBuffer.allocate(8);
            }

            public void setBytes(ByteBuffer bytes) {
            }
        };
        BaseContainerTokenSecretManager secMan = new BaseContainerTokenSecretManager(new Configuration()){

            public MasterKey getCurrentKey() {
                return mKey;
            }

            public byte[] createPassword(ContainerTokenIdentifier identifier) {
                return new byte[]{1, 2};
            }
        };
        this.allocator = new CentralizedOpportunisticContainerAllocator(secMan);
        this.oppCntxt = new OpportunisticContainerContext();
        this.oppCntxt.getAppParams().setMinResource(Resource.newInstance((int)1024, (int)1));
        this.oppCntxt.getAppParams().setIncrementResource(Resource.newInstance((int)512, (int)1));
        this.oppCntxt.getAppParams().setMaxResource(Resource.newInstance((int)1024, (int)10));
    }

    @Test
    public void testSimpleAllocation() throws Exception {
        List<ResourceRequest> reqs = Collections.singletonList(this.createResourceRequest(1, "*", 1));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(1, 2, 100));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        Assert.assertEquals((long)1L, (long)containers.size());
        Assert.assertEquals((long)0L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testBlacklistRejection() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(Arrays.asList("h1", "h2"), new ArrayList());
        List<ResourceRequest> reqs = Collections.singletonList(this.createResourceRequest(1, "*", 1));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(2, 2, 100));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "user");
        Assert.assertEquals((long)0L, (long)containers.size());
        Assert.assertEquals((long)1L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testRoundRobinSimpleAllocation() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(1, "*", 1), this.createResourceRequest(2, "*", 1), this.createResourceRequest(3, "*", 1));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 3));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        HashSet<String> allocatedNodes = new HashSet<String>();
        for (Container c : containers) {
            allocatedNodes.add(c.getNodeId().toString());
        }
        Assert.assertTrue((boolean)allocatedNodes.contains("h1:1234"));
        Assert.assertTrue((boolean)allocatedNodes.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedNodes.contains("h3:1234"));
        Assert.assertEquals((long)3L, (long)containers.size());
    }

    @Test
    public void testNodeLocalAllocation() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(1, "*", 1), this.createResourceRequest(2, "/r1", 1), this.createResourceRequest(2, "h1", 1), this.createResourceRequest(2, "*", 1), this.createResourceRequest(3, "/r1", 1), this.createResourceRequest(3, "h1", 1), this.createResourceRequest(3, "*", 1));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 5));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)3L, (long)containers.size());
        for (Container c : containers) {
            if (c.getAllocationRequestId() != 2L && c.getAllocationRequestId() != 3L) continue;
            Assert.assertEquals((Object)"h1:1234", (Object)c.getNodeId().toString());
        }
    }

    @Test
    public void testNodeLocalAllocationSameSchedulerKey() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r1", 2), this.createResourceRequest(2, "h1", 2), this.createResourceRequest(2, "*", 2));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 5));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeId().toString());
        }
        Assert.assertEquals((long)2L, (long)containers.size());
        Assert.assertTrue((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
    }

    @Test
    public void testSimpleRackLocalAllocation() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r1", 1), this.createResourceRequest(2, "h4", 1), this.createResourceRequest(2, "*", 1));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        NodeQueueLoadMonitor selector = this.createNodeQueueLoadMonitor(Arrays.asList("h1", "h2", "h3"), Arrays.asList("/r2", "/r1", "/r3"), Arrays.asList(2, 2, 2), Arrays.asList(5, 5, 5));
        this.allocator.setNodeQueueLoadMonitor(selector);
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeId().toString());
        }
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testRoundRobinRackLocalAllocation() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(1, "/r1", 1), this.createResourceRequest(1, "h5", 1), this.createResourceRequest(1, "*", 1), this.createResourceRequest(2, "/r1", 1), this.createResourceRequest(2, "h5", 1), this.createResourceRequest(2, "*", 1));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        NodeQueueLoadMonitor selector = this.createNodeQueueLoadMonitor(Arrays.asList("h1", "h2", "h3", "h4"), Arrays.asList("/r2", "/r1", "/r3", "/r1"), Arrays.asList(4, 4, 4, 4), Arrays.asList(5, 5, 5, 5));
        this.allocator.setNodeQueueLoadMonitor(selector);
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeId().toString());
        }
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testRoundRobinRackLocalAllocationSameSchedulerKey() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r1", 2), this.createResourceRequest(2, "h5", 2), this.createResourceRequest(2, "*", 2));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        NodeQueueLoadMonitor selector = this.createNodeQueueLoadMonitor(Arrays.asList("h1", "h2", "h3", "h4"), Arrays.asList("/r2", "/r1", "/r3", "/r1"), Arrays.asList(4, 4, 4, 4), Arrays.asList(5, 5, 5, 5));
        this.allocator.setNodeQueueLoadMonitor(selector);
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeId().toString());
        }
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testOffSwitchAllocationWhenNoNodeOrRack() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r3", 2), this.createResourceRequest(2, "h6", 2), this.createResourceRequest(2, "*", 2));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        NodeQueueLoadMonitor selector = this.createNodeQueueLoadMonitor(Arrays.asList("h1", "h2", "h3", "h4"), Arrays.asList("/r2", "/r1", "/r2", "/r1"), Arrays.asList(4, 4, 4, 4), Arrays.asList(5, 5, 5, 5));
        this.allocator.setNodeQueueLoadMonitor(selector);
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testLotsOfContainersRackLocalAllocationSameSchedulerKey() throws Exception {
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r1", 1000), this.createResourceRequest(2, "h1", 1000), this.createResourceRequest(2, "*", 1000));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        NodeQueueLoadMonitor selector = this.createNodeQueueLoadMonitor(Arrays.asList("h1", "h2", "h3", "h4"), Arrays.asList("/r1", "/r1", "/r1", "/r2"), Arrays.asList(0, 0, 0, 0), Arrays.asList(500, 500, 500, 300));
        this.allocator.setNodeQueueLoadMonitor(selector);
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        HashMap<String, Integer> hostsToNumContainerMap = new HashMap<String, Integer>();
        for (Container c : containers) {
            String host = c.getNodeId().toString();
            int numContainers = 0;
            if (hostsToNumContainerMap.containsKey(host)) {
                numContainers = (Integer)hostsToNumContainerMap.get(host);
            }
            hostsToNumContainerMap.put(host, numContainers + 1);
        }
        Assert.assertEquals((long)1000L, (long)containers.size());
        Assert.assertEquals((long)500L, (long)((Integer)hostsToNumContainerMap.get("h1:1234")).intValue());
        Assert.assertFalse((boolean)hostsToNumContainerMap.containsKey("h4:1234"));
    }

    @Test
    public void testLotsOfContainersRackLocalAllocation() throws Exception {
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (int i = 0; i < 100; ++i) {
            reqs.add(this.createResourceRequest(i + 1, "*", 1));
            reqs.add(this.createResourceRequest(i + 1, "h5", 1));
            reqs.add(this.createResourceRequest(i + 1, "/r1", 1));
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        NodeQueueLoadMonitor selector = this.createNodeQueueLoadMonitor(Arrays.asList("h1", "h2", "h3", "h4"), Arrays.asList("/r1", "/r1", "/r1", "/r2"), Arrays.asList(0, 0, 0, 0), Arrays.asList(500, 500, 500, 300));
        this.allocator.setNodeQueueLoadMonitor(selector);
        List containers = new ArrayList();
        containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        Assert.assertEquals((long)100L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeat() throws Exception {
        this.allocator.setMaxAllocationsPerAMHeartbeat(2);
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r3", 3), this.createResourceRequest(2, "h6", 3), this.createResourceRequest(2, "*", 3));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 5));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, new ArrayList(), appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeatDifferentSchedKey() throws Exception {
        this.allocator.setMaxAllocationsPerAMHeartbeat(2);
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(1, "*", 1), this.createResourceRequest(2, "h6", 2), this.createResourceRequest(3, "/r3", 2));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 5));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, new ArrayList(), appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, new ArrayList(), appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeatWithNoLimit() throws Exception {
        this.allocator.setMaxAllocationsPerAMHeartbeat(-1);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        int numContainers = 20;
        for (int i = 0; i < 20; ++i) {
            reqs.add(this.createResourceRequest(i + 1, "h1", 1));
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 500));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        Assert.assertEquals((long)20L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeatWithHighLimit() throws Exception {
        this.allocator.setMaxAllocationsPerAMHeartbeat(100);
        int numContainers = 20;
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (int i = 0; i < 20; ++i) {
            reqs.add(this.createResourceRequest(i + 1, "h1", 1));
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 500));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        Assert.assertEquals((long)20L, (long)containers.size());
    }

    @Test
    public void testAllocationLatencyMetrics() throws Exception {
        this.oppCntxt = (OpportunisticContainerContext)Mockito.spy((Object)this.oppCntxt);
        OpportunisticSchedulerMetrics metrics = (OpportunisticSchedulerMetrics)Mockito.mock(OpportunisticSchedulerMetrics.class);
        Mockito.when((Object)this.oppCntxt.getOppSchedulerMetrics()).thenReturn((Object)metrics);
        List<ResourceRequest> reqs = Arrays.asList(this.createResourceRequest(2, "/r3", 2), this.createResourceRequest(2, "h6", 2), this.createResourceRequest(2, "*", 2));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.allocator.setNodeQueueLoadMonitor(this.createNodeQueueLoadMonitor(3, 2, 5));
        List containers = this.allocator.allocateContainers(EMPTY_BLACKLIST_REQUEST, reqs, appAttId, this.oppCntxt, 1L, "user");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        ((OpportunisticSchedulerMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)2))).addAllocateOLatencyEntry(ArgumentMatchers.anyLong());
    }

    private NodeQueueLoadMonitor createNodeQueueLoadMonitor(int numNodes, int queueLength, int queueCapacity) {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        for (int i = 1; i <= numNodes; ++i) {
            RMNode node = this.createRMNode("h" + i, 1234, queueLength, queueCapacity);
            selector.addNode(null, node);
            selector.updateNode(node);
        }
        selector.computeTask.run();
        return selector;
    }

    private NodeQueueLoadMonitor createNodeQueueLoadMonitor(List<String> hosts, List<String> racks, List<Integer> queueLengths, List<Integer> queueCapacities) {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        for (int i = 0; i < hosts.size(); ++i) {
            RMNode node = this.createRMNode(hosts.get(i), 1234, racks.get(i), queueLengths.get(i), queueCapacities.get(i));
            selector.addNode(null, node);
            selector.updateNode(node);
        }
        selector.computeTask.run();
        return selector;
    }

    private ResourceRequest createResourceRequest(int allocationId, String location, int numContainers) {
        return ResourceRequest.newBuilder().allocationRequestId((long)allocationId).priority(PRIORITY_NORMAL).resourceName(location).capability(CAPABILITY_1GB).relaxLocality(true).numContainers(numContainers).executionType(ExecutionType.OPPORTUNISTIC).build();
    }

    private RMNode createRMNode(String host, int port, int queueLength, int queueCapacity) {
        return this.createRMNode(host, port, "default", queueLength, queueCapacity);
    }

    private RMNode createRMNode(String host, int port, String rack, int queueLength, int queueCapacity) {
        RMNode node1 = (RMNode)Mockito.mock(RMNode.class);
        TestNodeQueueLoadMonitor.FakeNodeId nID1 = new TestNodeQueueLoadMonitor.FakeNodeId(host, port);
        Mockito.when((Object)node1.getHostName()).thenReturn((Object)host);
        Mockito.when((Object)node1.getRackName()).thenReturn((Object)rack);
        Mockito.when((Object)node1.getNodeID()).thenReturn((Object)nID1);
        Mockito.when((Object)node1.getState()).thenReturn((Object)NodeState.RUNNING);
        OpportunisticContainersStatus status1 = (OpportunisticContainersStatus)Mockito.mock(OpportunisticContainersStatus.class);
        Mockito.when((Object)status1.getEstimatedQueueWaitTime()).thenReturn((Object)-1);
        Mockito.when((Object)status1.getWaitQueueLength()).thenReturn((Object)queueLength);
        Mockito.when((Object)status1.getOpportQueueCapacity()).thenReturn((Object)queueCapacity);
        Mockito.when((Object)node1.getOpportunisticContainersStatus()).thenReturn((Object)status1);
        return node1;
    }
}

