/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.Records;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacitySchedulerQueueMappingFactory {
    private static final String QUEUE_MAPPING_NAME = "app-name";
    private static final String QUEUE_MAPPING_RULE_APP_NAME = "org.apache.hadoop.yarn.server.resourcemanager.placement.AppNameMappingPlacementRule";
    private static final String QUEUE_MAPPING_RULE_USER_GROUP = "org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule";
    public static final String USER = "user_";
    public static final String PARENT_QUEUE = "c";

    public static CapacitySchedulerConfiguration setupQueueMappingsForRules(CapacitySchedulerConfiguration conf, String parentQueue, boolean overrideWithQueueMappings, int[] sourceIds) {
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add(QUEUE_MAPPING_RULE_USER_GROUP);
        queuePlacementRules.add(QUEUE_MAPPING_RULE_APP_NAME);
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappingsForUG = conf.getQueueMappings();
        ArrayList<QueueMapping> queueMappingsForUG = new ArrayList<QueueMapping>();
        for (int i = 0; i < sourceIds.length; ++i) {
            QueueMapping userQueueMapping = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source(USER + sourceIds[i]).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, USER + sourceIds[i])).build();
            queueMappingsForUG.add(userQueueMapping);
        }
        existingMappingsForUG.addAll(queueMappingsForUG);
        conf.setQueueMappings(existingMappingsForUG);
        List existingMappingsForAN = conf.getQueueMappingEntity(QUEUE_MAPPING_NAME);
        ArrayList<QueueMapping> queueMappingsForAN = new ArrayList<QueueMapping>();
        for (int i = 0; i < sourceIds.length; ++i) {
            QueueMapping queueMapping = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.APPLICATION).source(USER + sourceIds[i]).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, USER + sourceIds[i])).build();
            queueMappingsForAN.add(queueMapping);
        }
        existingMappingsForAN.addAll(queueMappingsForAN);
        conf.setQueueMappingEntities(existingMappingsForAN, QUEUE_MAPPING_NAME);
        conf.setOverrideWithQueueMappings(overrideWithQueueMappings);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatePlacementRulesFactory() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerQueueMappingFactory.setupQueueMappingsForRules(conf, PARENT_QUEUE, true, new int[]{1, 2, 3});
        try (MockRM mockRM = null;){
            mockRM = new MockRM((Configuration)conf);
            CapacityScheduler cs = (CapacityScheduler)mockRM.getResourceScheduler();
            cs.updatePlacementRules();
            mockRM.start();
            cs.start();
            List rules = cs.getRMContext().getQueuePlacementManager().getPlacementRules();
            ArrayList<String> placementRuleNames = new ArrayList<String>();
            for (PlacementRule pr : rules) {
                placementRuleNames.add(pr.getName());
            }
            Assert.assertThat(placementRuleNames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{QUEUE_MAPPING_RULE_USER_GROUP}));
            Assert.assertThat(placementRuleNames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{QUEUE_MAPPING_RULE_APP_NAME}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedUserQueueWithStaticParentQueue() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add(QUEUE_MAPPING_RULE_USER_GROUP);
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappingsForUG = conf.getQueueMappings();
        ArrayList<QueueMapping> queueMappingsForUG = new ArrayList<QueueMapping>();
        QueueMapping userQueueMapping1 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user1").queue("b1").build();
        QueueMapping userQueueMapping2 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(PARENT_QUEUE, "%user")).build();
        queueMappingsForUG.add(userQueueMapping1);
        queueMappingsForUG.add(userQueueMapping2);
        existingMappingsForUG.addAll(queueMappingsForUG);
        conf.setQueueMappings(existingMappingsForUG);
        conf.setOverrideWithQueueMappings(true);
        try (MockRM mockRM = null;){
            mockRM = new MockRM((Configuration)conf);
            CapacityScheduler cs = (CapacityScheduler)mockRM.getResourceScheduler();
            cs.updatePlacementRules();
            mockRM.start();
            cs.start();
            ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
            asc.setQueue("default");
            List rules = cs.getRMContext().getQueuePlacementManager().getPlacementRules();
            UserGroupMappingPlacementRule r = (UserGroupMappingPlacementRule)rules.get(0);
            ApplicationPlacementContext ctx = r.getPlacementForApp(asc, "user1");
            Assert.assertEquals((String)"Queue", (Object)"b1", (Object)ctx.getQueue());
            ApplicationPlacementContext ctx2 = r.getPlacementForApp(asc, "user2");
            Assert.assertEquals((String)"Queue", (Object)"user2", (Object)ctx2.getQueue());
            Assert.assertEquals((String)"Queue", (Object)"root.c", (Object)ctx2.getParentQueue());
        }
    }

    @Test
    public void testNestedUserQueueWithPrimaryGroupAsDynamicParentQueue() throws Exception {
        ArrayList<QueueMapping> queueMappingsForUG = new ArrayList<QueueMapping>();
        QueueMapping userQueueMapping1 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping("%primary_group", "%user")).build();
        QueueMapping userQueueMapping2 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping("%secondary_group", "%user")).build();
        QueueMapping userQueueMapping3 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("b4").queue("%secondary_group").build();
        queueMappingsForUG.add(userQueueMapping1);
        queueMappingsForUG.add(userQueueMapping2);
        queueMappingsForUG.add(userQueueMapping3);
        this.testNestedUserQueueWithDynamicParentQueue(queueMappingsForUG, true, "f");
        try {
            this.testNestedUserQueueWithDynamicParentQueue(queueMappingsForUG, true, "g");
            Assert.fail((String)"Queue 'g' exists, but type is not Leaf Queue");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        try {
            this.testNestedUserQueueWithDynamicParentQueue(queueMappingsForUG, true, "a1");
            Assert.fail((String)"Actual Parent Queue of Leaf Queue 'a1' is 'a', but as per queue mapping it returns primary queue as 'a1group'");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedUserQueueWithSecondaryGroupAsDynamicParentQueue() throws Exception {
        ArrayList<QueueMapping> queueMappingsForUG = new ArrayList<QueueMapping>();
        QueueMapping userQueueMapping1 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping("%primary_group", "%user")).build();
        QueueMapping userQueueMapping2 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping("%secondary_group", "%user")).build();
        queueMappingsForUG.add(userQueueMapping2);
        queueMappingsForUG.add(userQueueMapping1);
        this.testNestedUserQueueWithDynamicParentQueue(queueMappingsForUG, false, "e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNestedUserQueueWithDynamicParentQueue(List<QueueMapping> mapping, boolean primary, String user) throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add(QUEUE_MAPPING_RULE_USER_GROUP);
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappingsForUG = conf.getQueueMappings();
        existingMappingsForUG.addAll(mapping);
        conf.setQueueMappings(existingMappingsForUG);
        conf.setOverrideWithQueueMappings(true);
        try (MockRM mockRM = null;){
            mockRM = new MockRM((Configuration)conf);
            CapacityScheduler cs = (CapacityScheduler)mockRM.getResourceScheduler();
            cs.updatePlacementRules();
            mockRM.start();
            cs.start();
            ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
            asc.setQueue("default");
            List rules = cs.getRMContext().getQueuePlacementManager().getPlacementRules();
            UserGroupMappingPlacementRule r = (UserGroupMappingPlacementRule)rules.get(0);
            ApplicationPlacementContext ctx = r.getPlacementForApp(asc, user);
            Assert.assertEquals((String)"Queue", (Object)user, (Object)ctx.getQueue());
            if (primary) {
                Assert.assertEquals((String)"Primary Group", (Object)("root." + user + "group"), (Object)ctx.getParentQueue());
            } else {
                Assert.assertEquals((String)"Secondary Group", (Object)("root." + user + "subgroup1"), (Object)ctx.getParentQueue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicPrimaryGroupQueue() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add(QUEUE_MAPPING_RULE_USER_GROUP);
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappingsForUG = conf.getQueueMappings();
        ArrayList<QueueMapping> queueMappingsForUG = new ArrayList<QueueMapping>();
        QueueMapping userQueueMapping1 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user1").queue("b1").build();
        QueueMapping userQueueMapping2 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a1").queue("%primary_group").build();
        queueMappingsForUG.add(userQueueMapping1);
        queueMappingsForUG.add(userQueueMapping2);
        existingMappingsForUG.addAll(queueMappingsForUG);
        conf.setQueueMappings(existingMappingsForUG);
        conf.setOverrideWithQueueMappings(true);
        try (MockRM mockRM = null;){
            mockRM = new MockRM((Configuration)conf);
            CapacityScheduler cs = (CapacityScheduler)mockRM.getResourceScheduler();
            cs.updatePlacementRules();
            mockRM.start();
            cs.start();
            ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
            asc.setQueue("default");
            List rules = cs.getRMContext().getQueuePlacementManager().getPlacementRules();
            UserGroupMappingPlacementRule r = (UserGroupMappingPlacementRule)rules.get(0);
            ApplicationPlacementContext ctx = r.getPlacementForApp(asc, "user1");
            Assert.assertEquals((String)"Queue", (Object)"b1", (Object)ctx.getQueue());
            ApplicationPlacementContext ctx1 = r.getPlacementForApp(asc, "a1");
            Assert.assertEquals((String)"Queue", (Object)"a1group", (Object)ctx1.getQueue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixedUserWithDynamicGroupQueue() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add(QUEUE_MAPPING_RULE_USER_GROUP);
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappingsForUG = conf.getQueueMappings();
        ArrayList<QueueMapping> queueMappingsForUG = new ArrayList<QueueMapping>();
        QueueMapping userQueueMapping1 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user1").queue("b1").build();
        QueueMapping userQueueMapping2 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a1").queue("%primary_group").build();
        QueueMapping userQueueMapping3 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("e").queue("%secondary_group").build();
        queueMappingsForUG.add(userQueueMapping1);
        queueMappingsForUG.add(userQueueMapping2);
        queueMappingsForUG.add(userQueueMapping3);
        existingMappingsForUG.addAll(queueMappingsForUG);
        conf.setQueueMappings(existingMappingsForUG);
        conf.setOverrideWithQueueMappings(true);
        try (MockRM mockRM = null;){
            mockRM = new MockRM((Configuration)conf);
            CapacityScheduler cs = (CapacityScheduler)mockRM.getResourceScheduler();
            cs.updatePlacementRules();
            mockRM.start();
            cs.start();
            ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
            asc.setQueue("default");
            List rules = cs.getRMContext().getQueuePlacementManager().getPlacementRules();
            UserGroupMappingPlacementRule r = (UserGroupMappingPlacementRule)rules.get(0);
            ApplicationPlacementContext ctx = r.getPlacementForApp(asc, "user1");
            Assert.assertEquals((String)"Queue", (Object)"b1", (Object)ctx.getQueue());
            ApplicationPlacementContext ctx1 = r.getPlacementForApp(asc, "a1");
            Assert.assertEquals((String)"Queue", (Object)"a1group", (Object)ctx1.getQueue());
            ApplicationPlacementContext ctx2 = r.getPlacementForApp(asc, "e");
            Assert.assertEquals((String)"Queue", (Object)"esubgroup1", (Object)ctx2.getQueue());
        }
    }
}

