/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.placement.AppNameMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPlacementManager {
    public static final String USER = "user_";
    public static final String APP_NAME = "DistributedShell";
    public static final String APP_ID1 = "1";
    public static final String USER1 = "user_1";
    public static final String APP_ID2 = "2";
    public static final String USER2 = "user_2";
    public static final String PARENT_QUEUE = "c";
    private MockRM mockRM = null;
    private CapacitySchedulerConfiguration conf;

    private String getQueueMapping(String parentQueue, String leafQueue) {
        return parentQueue + "." + leafQueue;
    }

    @Before
    public void setup() {
        this.conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(this.conf);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
    }

    @Test
    public void testPlaceApplicationWithPlacementRuleChain() throws Exception {
        this.mockRM = new MockRM((Configuration)this.conf);
        CapacityScheduler cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.mockRM.start();
        cs.start();
        PlacementManager pm = cs.getRMContext().getQueuePlacementManager();
        ArrayList<Object> queuePlacementRules = new ArrayList<Object>();
        QueueMapping userQueueMapping = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source(USER1).queue(this.getQueueMapping(PARENT_QUEUE, USER1)).build();
        UserGroupMappingPlacementRule ugRule = new UserGroupMappingPlacementRule(false, Arrays.asList(userQueueMapping), null);
        queuePlacementRules.add(ugRule);
        pm.updateRules(queuePlacementRules);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        asc.setQueue("default");
        asc.setApplicationName(APP_NAME);
        Assert.assertNull((String)"Placement should be null", (Object)pm.placeApplication(asc, USER2));
        QueueMapping queueMappingEntity = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.APPLICATION).source(APP_NAME).queue(USER1).parentQueue(PARENT_QUEUE).build();
        AppNameMappingPlacementRule anRule = new AppNameMappingPlacementRule(false, Arrays.asList(queueMappingEntity));
        queuePlacementRules.add(anRule);
        pm.updateRules(queuePlacementRules);
        try {
            ApplicationPlacementContext pc = pm.placeApplication(asc, USER2);
            Assert.assertNotNull((Object)pc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }

    @Test
    public void testPlacementRuleUpdationOrder() throws Exception {
        ArrayList<QueueMapping> queueMappings = new ArrayList<QueueMapping>();
        QueueMapping userQueueMapping = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source(USER1).queue(this.getQueueMapping(PARENT_QUEUE, USER1)).build();
        UserGroupMappingPlacementRule ugRule = new UserGroupMappingPlacementRule(false, Arrays.asList(userQueueMapping), null);
        this.conf.set("yarn.scheduler.queue-placement-rules", ugRule.getName());
        queueMappings.add(userQueueMapping);
        this.conf.setQueueMappings(queueMappings);
        this.mockRM = new MockRM((Configuration)this.conf);
        CapacityScheduler cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.mockRM.start();
        PlacementManager pm = cs.getRMContext().getQueuePlacementManager();
        Assert.assertEquals((long)1L, (long)pm.getPlacementRules().size());
        Assert.assertEquals((Object)ugRule.getName(), (Object)((PlacementRule)pm.getPlacementRules().get(0)).getName());
    }

    @After
    public void tearDown() {
        if (null != this.mockRM) {
            this.mockRM.stop();
        }
    }
}

