/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyIntraQueue
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", true);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testSimpleIntraQueuePreemption() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 79 110 0]);-a(=[11 100 11 50 0]);-b(=[40 100 38 50 0]);-c(=[20 100 10 10 0]);-d(=[29 100 20 0 0])";
        String appsConfig = "a\t(1,1,n1,,6,false,25);a\t(1,1,n1,,5,false,25);b\t(4,1,n1,,34,false,20);b\t(4,1,n1,,2,false,10);b\t(5,1,n1,,1,false,10);b\t(6,1,n1,,1,false,10);c\t(1,1,n1,,10,false,10);d\t(1,1,n1,,20,false,0)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNoIntraQueuePreemptionWithPreemptionDisabledOnQueues() throws IOException {
        this.conf.setPreemptionDisabled("root.a", true);
        this.conf.setPreemptionDisabled("root.b", true);
        this.conf.setPreemptionDisabled("root.c", true);
        this.conf.setPreemptionDisabled("root.d", true);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 80 110 0]);-a(=[11 100 11 50 0]);-b(=[40 100 38 50 0]);-c(=[20 100 10 10 0]);-d(=[29 100 20 0 0])";
        String appsConfig = "a\t(1,1,n1,,6,false,25);a\t(1,1,n1,,5,false,25);b\t(4,1,n1,,34,false,20);b\t(4,1,n1,,2,false,10);b\t(5,1,n1,,1,false,10);b\t(6,1,n1,,1,false,10);c\t(1,1,n1,,10,false,10);d\t(1,1,n1,,20,false,0)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNoPreemptionForSamePriorityApps() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 80 120 0]);-a(=[10 100 10 50 0]);-b(=[40 100 40 60 0]);-c(=[20 100 10 10 0]);-d(=[30 100 20 0 0])";
        String appsConfig = "a\t(1,1,n1,,6,false,25);a\t(1,1,n1,,5,false,25);b\t(1,1,n1,,34,false,20);b\t(1,1,n1,,2,false,10);b\t(1,1,n1,,1,false,20);b\t(1,1,n1,,1,false,10);c\t(1,1,n1,,10,false,10);d\t(1,1,n1,,20,false,0)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(6))));
    }

    @Test
    public void testNoPreemptionWhenQueueIsUnderCapacityLimit() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 35 80 0]);-a(=[40 100 10 50 0]);-b(=[60 100 25 30 0])";
        String appsConfig = "a\t(1,1,n1,,5,false,25);a\t(2,1,n1,,5,false,25);b\t(4,1,n1,,40,false,20);b\t(6,1,n1,,5,false,20)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testLimitPreemptionWithMaxIntraQueuePreemptableLimit() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 55 170 0]);-a(=[40 100 10 50 0]);-b(=[60 100 45 120 0])";
        String appsConfig = "a\t(1,1,n1,,5,false,25);a\t(2,1,n1,,5,false,25);b\t(4,1,n1,,40,false,20);b\t(6,1,n1,,5,false,100)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)30))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testLimitPreemptionWithTotalPreemptedResourceAllowed() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 0.1f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 55 170 0]);-a(=[40 100 10 50 0]);-b(=[60 100 45 120 0])";
        String appsConfig = "a\t(1,1,n1,,5,false,25);a\t(2,1,n1,,5,false,25);b\t(4,1,n1,,40,false,20);b\t(6,1,n1,,5,false,100)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)10))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testAlreadySelectedContainerFromInterQueuePreemption() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 95 170 0]);-a(=[60 100 70 35 0]);-b(=[40 100 25 120 0])";
        String appsConfig = "root.a\t(1,1,n1,,50,false,15);root.a\t(2,1,n1,,20,false,20);root.b\t(4,1,n1,,20,false,20);root.b\t(4,1,n1,,5,false,100)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)20))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testSkipAMContainersInInterQueuePreemption() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 170 0]);-a(=[60 100 60 50 0]);-b(=[40 100 40 120 0])";
        String appsConfig = "a\t(1,1,n1,,30,false,10);a\t(1,1,n1,,10,false,20);a\t(2,1,n1,,20,false,20);b\t(4,1,n1,,20,false,20);b\t(4,1,n1,,20,false,100)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)11))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)9))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testSkipAMContainersInInterQueuePreemptionSingleApp() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 170 0]);-a(=[50 100 50 50 0]);-b(=[50 100 50 120 0])";
        String appsConfig = "a\t(1,1,n1,,10,false,10);a\t(2,1,n1,,40,false,10);b\t(4,1,n1,,20,false,20);b\t(4,1,n1,,30,false,100)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)9))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNoPreemptionForSingleApp() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 20 50 0]);-a(=[60 100 20 50 0]);-b(=[40 100 0 0 0])";
        String appsConfig = "a\t(4,1,n1,,20,false,50)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testOverutilizedQueueResourceWithInterQueuePreemption() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 70 0]);-a(=[20 100 100 30 0]);-b(=[80 100 0 20 0])";
        String appsConfig = "a\t(1,1,n1,,50,false,0);a\t(3,1,n1,,50,false,30);b\t(4,1,n1,,0,false,20)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)20))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNodePartitionIntraQueuePreemption() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 50 50],x=[50 100 50 50]);-b(=[50 100 50 50],x=[50 100 50 50])";
        String appsConfig = "a\t(1,1,n1,x,50,false,10);a\t(2,1,n1,x,0,false,20);a\t(1,1,n2,,50,false);b\t(1,1,n1,x,50,false);b\t(1,1,n2,,50,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)20))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testComplexIntraQueuePreemption() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 0.5f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 75 130 0]);-a(=[10 100 5 50 0]);-b(=[40 100 35 60 0]);-c(=[20 100 10 10 0]);-d(=[30 100 25 10 0])";
        String appsConfig = "a\t(1,1,n1,,5,false,25);a\t(4,1,n1,,0,false,25);a\t(5,1,n1,,0,false,2);b\t(3,1,n1,,5,false,20);b\t(4,1,n1,,15,false,10);b\t(4,1,n1,,10,false,10);b\t(5,1,n1,,3,false,5);b\t(5,1,n1,,0,false,2);b\t(6,1,n1,,2,false,10);c\t(1,1,n1,,8,false,10);c\t(1,1,n1,,2,false,5);c\t(2,1,n1,,0,false,3);d\t(2,1,n1,,25,false,0);d\t(1,1,n1,,0,false,20)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)9))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(6))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(10))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(11))));
    }

    @Test
    public void testIntraQueuePreemptionWithTwoUsers() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 55 170 0]);-a(=[60 100 10 50 0]);-b(=[40 100 40 120 0])";
        String appsConfig = "a\t(1,1,n1,,5,false,25);a\t(2,1,n1,,5,false,25);b\t(4,1,n1,,35,false,20,user1);b\t(6,1,n1,,5,false,30,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)14))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testComplexNodePartitionIntraQueuePreemption() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 50 50],x=[50 100 40 50]);-b(=[50 100 35 50],x=[50 100 50 50])";
        String appsConfig = "a\t(1,1,n1,x,35,false,10);a\t(1,1,n1,x,5,false,10);a\t(2,1,n1,x,0,false,20);a\t(1,1,n2,,50,false);b\t(1,1,n1,x,50,false);b\t(1,1,n2,,25,false);b\t(1,1,n2,,3,false);b\t(1,1,n2,,2,false);b\t(5,1,n2,,5,false,30)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)16))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(8))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(7))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)22))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(6))));
    }

    @Test
    public void testIntraQueuePreemptionAfterQueueDropped() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 79 110 0]);-a(=[11 100 11 50 0]);-b(=[40 100 38 50 0]);-c(=[20 100 10 10 0]);-d(=[29 100 20 0 0])";
        String appsConfig = "a\t(1,1,n1,,6,false,25);a\t(1,1,n1,,5,false,25);b\t(4,1,n1,,34,false,20);b\t(4,1,n1,,2,false,10);b\t(5,1,n1,,1,false,10);b\t(6,1,n1,,1,false,10);c\t(1,1,n1,,10,false,10);d\t(1,1,n1,,20,false,0)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        queuesConfig = "root(=[100 100 69 100 0]);-a(=[11 100 11 50 0]);-b(=[40 100 38 50 0]);-d(=[49 100 20 0 0])";
        this.updateQueueConfig(queuesConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }
}

