/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementDynamicEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.GuaranteedOrZeroCapacityOverTimePolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueManagementDynamicEditPolicy
extends TestCapacitySchedulerAutoCreatedQueueBase {
    private QueueManagementDynamicEditPolicy policy = new QueueManagementDynamicEditPolicy();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.policy.init((Configuration)this.cs.getConfiguration(), this.cs.getRMContext(), (ResourceScheduler)this.cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditSchedule() throws Exception {
        try {
            this.policy.editSchedule();
            Assert.assertEquals((long)2L, (long)this.policy.getManagedParentQueues().size());
            CSQueue parentQueue = this.cs.getQueue("c");
            GuaranteedOrZeroCapacityOverTimePolicy autoCreatedQueueManagementPolicy = (GuaranteedOrZeroCapacityOverTimePolicy)((ManagedParentQueue)parentQueue).getAutoCreatedQueueManagementPolicy();
            Assert.assertEquals((float)0.0f, (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)1.0E-4f);
            ApplicationId user1AppId = this.submitApp(this.mockRM, parentQueue, "user_1", "user_1", 1, 1);
            Map<String, Float> expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(1);
            this.validateInitialQueueEntitlement(parentQueue, "user_1", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            ApplicationId user2AppId = this.submitApp(this.mockRM, parentQueue, "user_2", "user_2", 2, 1);
            expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(2);
            this.validateInitialQueueEntitlement(parentQueue, "user_2", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            Assert.assertEquals((float)0.2f, (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)1.0E-4f);
            this.submitApp(this.mockRM, parentQueue, "user_3", "user_3", 3, 1);
            CSQueue user3LeafQueue = this.cs.getQueue("user_3");
            this.validateCapacities((AutoCreatedLeafQueue)user3LeafQueue, 0.0f, 0.0f, 1.0f, 1.0f);
            Assert.assertEquals((float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)0.2f, (float)1.0E-4f);
            this.cs.killAllAppsInQueue("user_2");
            this.mockRM.waitForState(user2AppId, RMAppState.KILLED);
            this.cs.killAllAppsInQueue("user_1");
            this.mockRM.waitForState(user1AppId, RMAppState.KILLED);
            this.policy.editSchedule();
            this.waitForPolicyState(0.1f, autoCreatedQueueManagementPolicy, "", 1000);
            this.validateCapacities((AutoCreatedLeafQueue)user3LeafQueue, 0.5f, 0.1f, 1.0f, 1.0f);
            this.validateCapacitiesByLabel((ManagedParentQueue)parentQueue, (AutoCreatedLeafQueue)user3LeafQueue, "GPU");
        }
        finally {
            this.cleanupQueue("user_1");
            this.cleanupQueue("user_2");
            this.cleanupQueue("user_3");
        }
    }

    private void waitForPolicyState(float expectedVal, GuaranteedOrZeroCapacityOverTimePolicy queueManagementPolicy, String nodeLabel, int timesec) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)(timesec * 1000) && Math.abs(expectedVal - queueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(nodeLabel)) > 1.0E-4f) {
            Thread.sleep(100L);
        }
    }
}

