/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestReservationQueue {
    private CapacitySchedulerConfiguration csConf;
    private CapacitySchedulerContext csContext;
    static final int DEF_MAX_APPS = 10000;
    static final int GB = 1024;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private ReservationQueue autoCreatedLeafQueue;

    @Before
    public void setup() throws IOException {
        this.csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration();
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        RMContext mockRMContext = TestUtils.getMockRMContext();
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)mockRMContext);
        PlanQueue pq = new PlanQueue(this.csContext, "root", null, null);
        this.autoCreatedLeafQueue = new ReservationQueue(this.csContext, "a", pq);
    }

    private void validateAutoCreatedLeafQueue(double capacity) {
        Assert.assertTrue((String)(" actual capacity: " + this.autoCreatedLeafQueue.getCapacity()), ((double)this.autoCreatedLeafQueue.getCapacity() - capacity < (double)1.0E-4f ? 1 : 0) != 0);
        Assert.assertEquals((long)this.autoCreatedLeafQueue.maxApplications, (long)10000L);
        Assert.assertEquals((long)this.autoCreatedLeafQueue.maxApplicationsPerUser, (long)10000L);
    }

    @Test
    public void testAddSubtractCapacity() throws Exception {
        this.autoCreatedLeafQueue.setCapacity(1.0f);
        this.validateAutoCreatedLeafQueue(1.0);
        this.autoCreatedLeafQueue.setEntitlement(new QueueEntitlement(0.9f, 1.0f));
        this.validateAutoCreatedLeafQueue(0.9);
        this.autoCreatedLeafQueue.setEntitlement(new QueueEntitlement(1.0f, 1.0f));
        this.validateAutoCreatedLeafQueue(1.0);
        this.autoCreatedLeafQueue.setEntitlement(new QueueEntitlement(0.0f, 1.0f));
        this.validateAutoCreatedLeafQueue(0.0);
        try {
            this.autoCreatedLeafQueue.setEntitlement(new QueueEntitlement(1.1f, 1.0f));
            Assert.fail();
        }
        catch (SchedulerDynamicEditException iae) {
            this.validateAutoCreatedLeafQueue(1.0);
        }
        try {
            this.autoCreatedLeafQueue.setEntitlement(new QueueEntitlement(-0.1f, 1.0f));
            Assert.fail();
        }
        catch (SchedulerDynamicEditException iae) {
            this.validateAutoCreatedLeafQueue(1.0);
        }
    }
}

