/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyInterQueueWithDRF
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.resourceCalculator = new DominantResourceCalculator();
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testInterQueuePreemptionWithMultipleResource() throws Exception {
        String labelsConfig = "=100:200,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100:200 100:200 100:200 100:200]);-a(=[50:100 100:200 40:80 30:70]);-b(=[50:100 100:200 60:120 40:50])";
        String appsConfig = "a\t(1,2:4,n1,,20,false);b\t(1,2:4,n1,,30,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)5))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testInterQueuePreemptionWithNaturalTerminationFactor() throws Exception {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 0.2f);
        String labelsConfig = "=100:50,true;";
        String nodesConfig = "n1= res=100:50";
        String queuesConfig = "root(=[100:50 100:50 50:50 0:0]);-a(=[50:25 100:50 50:50 0:0]);-b(=[50:25 50:25 0:0 2:1]);";
        String appsConfig = "a\t(1,2:1,n1,,50,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void test3ResourceTypesInterQueuePreemption() throws IOException {
        String RESOURCE_1 = "res1";
        this.riMap.put(RESOURCE_1, ResourceInformation.newInstance((String)RESOURCE_1, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Integer.MAX_VALUE));
        ResourceUtils.initializeResourcesFromResourceInformationMap((Map)this.riMap);
        String labelsConfig = "=30:18:6,true;";
        String nodesConfig = "n1= res=30:18:6;";
        String queuesConfig = "root(=[30:18:6 30:18:6 12:12:6 1:1:1]);-a(=[10:7:2 10:6:3 6:6:3 0:0:0]);-b(=[10:6:2 10:6:3 6:6:3 0:0:0]);-c(=[10:5:2 10:6:2 0:0:0 1:1:1])";
        String appsConfig = "a\t(1,2:2:1,n1,,3,false);b\t(1,2:2:1,n1,,3,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testInterQueuePreemptionWithStrictAndRelaxedDRF() throws IOException {
        String labelsConfig = "=61440:600,true;";
        String nodesConfig = "n1= res=61440:600";
        String queuesConfig = "root(=[61440:600 61440:600 61440:600 20480:20 0]);-a(=[20480:200 61440:600 61440:60 0:0 0]);-b(=[20480:200 61440:600 0:0 20480:20 0]);-c(=[20480:200 61440:600 0:0 0:0 0])";
        String appsConfig = "a\t(1,1024:1,n1,,60,false,0:0,user1);b\t(1,0:0,n1,,0,false,20480:20,user2);";
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.conservative-drf", true);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        Resource ul = Resource.newInstance((int)20480, (int)20);
        Mockito.when((Object)((LeafQueue)this.cs.getQueue("root.a")).getResourceLimitForAllUsers((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SchedulingMode)ArgumentMatchers.any())).thenReturn((Object)ul);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.conservative-drf", false);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        ul = Resource.newInstance((int)20480, (int)20);
        Mockito.when((Object)((LeafQueue)this.cs.getQueue("root.a")).getResourceLimitForAllUsers((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SchedulingMode)ArgumentMatchers.any())).thenReturn((Object)ul);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)20))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }
}

