/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@XmlRootElement(name="appAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAttemptInfo {
    protected int id;
    protected long startTime;
    protected long finishedTime;
    protected String containerId;
    protected String nodeHttpAddress;
    protected String nodeId;
    protected String logsLink;
    protected String appAttemptId;

    public AppAttemptInfo() {
    }

    public AppAttemptInfo(RMAppAttempt attempt, String user) {
        this.startTime = 0L;
        this.containerId = "";
        this.nodeHttpAddress = "";
        this.nodeId = "";
        this.logsLink = "";
        if (attempt != null) {
            this.id = attempt.getAppAttemptId().getAttemptId();
            this.startTime = attempt.getStartTime();
            this.finishedTime = attempt.getFinishTime();
            Container masterContainer = attempt.getMasterContainer();
            if (masterContainer != null) {
                this.containerId = masterContainer.getId().toString();
                this.nodeHttpAddress = masterContainer.getNodeHttpAddress();
                this.nodeId = masterContainer.getNodeId().toString();
                this.logsLink = WebAppUtils.getRunningLogURL((String)("//" + masterContainer.getNodeHttpAddress()), (String)ConverterUtils.toString((ContainerId)masterContainer.getId()), (String)user);
            }
            this.appAttemptId = attempt.getAppAttemptId().toString();
        }
    }

    public int getAttemptId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }

    public String getLogsLink() {
        return this.logsLink;
    }
}

