/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCapacitySchedulerNodeLabelUpdate {
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;
    private static final String HOST = "127.0.0.1";

    @BeforeClass
    public static void beforeClass() {
        NetUtils.addStaticResolution((String)"h1", (String)HOST);
        NetUtils.addStaticResolution((String)"h2", (String)HOST);
        NetUtils.addStaticResolution((String)"h3", (String)HOST);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 100.0f);
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        conf.setCapacityByLabel("root.a", "y", 100.0f);
        conf.setCapacityByLabel("root.a", "z", 100.0f);
        return conf;
    }

    private Set<String> toSet(String ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    private void checkUsedResource(MockRM rm, String queueName, int memory) {
        this.checkUsedResource(rm, queueName, memory, "");
    }

    private void checkUsedResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = scheduler.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getUsed(label).getMemory());
    }

    @Test(timeout=30000L)
    public void testNodeUpdate() throws Exception {
        this.mgr.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 8000);
        MockNM nm2 = rm.registerNode("h2:1234", 8000);
        MockNM nm3 = rm.registerNode("h3:1234", 8000);
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "a");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm3);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkUsedResource(rm, "a", 1024, "x");
        this.checkUsedResource(rm, "a", 1024);
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("z")));
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.KILLED, 10000));
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 1024);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkUsedResource(rm, "a", 1024, "y");
        this.checkUsedResource(rm, "a", 1024);
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET));
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.KILLED, 10000));
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 0, "y");
        this.checkUsedResource(rm, "a", 1024);
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("z")));
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.KILLED, 10000));
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 0, "y");
        this.checkUsedResource(rm, "a", 0);
        rm.close();
    }
}

