/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacityScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacityScheduler.class);
    private final int GB = 1024;
    private static final String A = "root.a";
    private static final String B = "root.b";
    private static final String A1 = "root.a.a1";
    private static final String A2 = "root.a.a2";
    private static final String B1 = "root.b.b1";
    private static final String B2 = "root.b.b2";
    private static final String B3 = "root.b.b3";
    private static float A_CAPACITY = 10.5f;
    private static float B_CAPACITY = 89.5f;
    private static float A1_CAPACITY = 30.0f;
    private static float A2_CAPACITY = 70.0f;
    private static float B1_CAPACITY = 79.2f;
    private static float B2_CAPACITY = 0.8f;
    private static float B3_CAPACITY = 20.0f;
    private static final String HOST = "127.0.0.1";
    private ResourceManager resourceManager = null;
    private RMContext mockContext;

    @Before
    public void setUp() throws Exception {
        this.resourceManager = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.mockContext.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
    }

    @After
    public void tearDown() throws Exception {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
        }
    }

    @BeforeClass
    public static void beforeClass() {
        NetUtils.addStaticResolution((String)"host_0", (String)HOST);
        NetUtils.addStaticResolution((String)"host_1", (String)HOST);
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        CapacityScheduler scheduler = new CapacityScheduler();
        scheduler.setRMContext(this.resourceManager.getRMContext());
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            scheduler.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    @Test
    public void testCapacityScheduler() throws Exception {
        LOG.info("--- START: testCapacityScheduler ---");
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)2));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)2));
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        org.apache.hadoop.yarn.api.records.Priority priority_1 = Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)3072, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        LOG.info("Kick!");
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info("Adding new tasks...");
        Task task_1_1 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_1);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        application_0.schedule();
        LOG.info("Sending hb from " + nm_0.getHostName());
        this.nodeUpdate(nm_0);
        LOG.info("Sending hb from " + nm_1.getHostName());
        this.nodeUpdate(nm_1);
        LOG.info("Trying to allocate...");
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(5120, application_1);
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info("--- END: testCapacityScheduler ---");
    }

    private void nodeUpdate(NodeManager nm) {
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
    }

    private CapacitySchedulerConfiguration setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacity(A, A_CAPACITY);
        conf.setCapacity(B, B_CAPACITY);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, A1_CAPACITY);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, A2_CAPACITY);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, B1_CAPACITY);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, B2_CAPACITY);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, B3_CAPACITY);
        conf.setUserLimitFactor(B3, 100.0f);
        LOG.info("Setup top-level queues a and b");
        return conf;
    }

    @Test
    public void testMaximumCapacitySetup() {
        float delta = 1.0E-7f;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        Assert.assertEquals((float)100.0f, (float)conf.getNonLabeledQueueMaximumCapacity(A), (float)delta);
        conf.setMaximumCapacity(A, 50.0f);
        Assert.assertEquals((float)50.0f, (float)conf.getNonLabeledQueueMaximumCapacity(A), (float)delta);
        conf.setMaximumCapacity(A, -1.0f);
        Assert.assertEquals((float)100.0f, (float)conf.getNonLabeledQueueMaximumCapacity(A), (float)delta);
    }

    @Test
    public void testQueueMaximumAllocations() {
        CapacityScheduler scheduler = new CapacityScheduler();
        scheduler.setConf((Configuration)new YarnConfiguration());
        scheduler.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)A1) + "maximum-allocation-mb", "1024");
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)A1) + "maximum-allocation-vcores", "1");
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)A1) + "maximum-allocation-disks", "1");
        scheduler.init((Configuration)conf);
        scheduler.start();
        Resource maxAllocationForQueue = scheduler.getMaximumResourceCapability("a1");
        Resource maxAllocation1 = scheduler.getMaximumResourceCapability("");
        Resource maxAllocation2 = scheduler.getMaximumResourceCapability(null);
        Resource maxAllocation3 = scheduler.getMaximumResourceCapability();
        Assert.assertEquals((Object)maxAllocation1, (Object)maxAllocation2);
        Assert.assertEquals((Object)maxAllocation1, (Object)maxAllocation3);
        Assert.assertEquals((long)8192L, (long)maxAllocation1.getMemory());
        Assert.assertEquals((long)4L, (long)maxAllocation1.getVirtualCores());
        Assert.assertEquals((double)4.0, (double)maxAllocation1.getDisks(), (double)0.01);
        Assert.assertEquals((long)1024L, (long)maxAllocationForQueue.getMemory());
        Assert.assertEquals((long)1L, (long)maxAllocationForQueue.getVirtualCores());
        Assert.assertEquals((double)1.0, (double)maxAllocationForQueue.getDisks(), (double)0.01);
    }

    @Test
    public void testRefreshQueues() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        conf.setCapacity(A, 80.0f);
        conf.setCapacity(B, 20.0f);
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.checkQueueCapacities(cs, 80.0f, 20.0f);
        cs.stop();
    }

    void checkQueueCapacities(CapacityScheduler cs, float capacityA, float capacityB) {
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = this.findQueue(rootQueue, A);
        CSQueue queueB = this.findQueue(rootQueue, B);
        CSQueue queueA1 = this.findQueue(queueA, A1);
        CSQueue queueA2 = this.findQueue(queueA, A2);
        CSQueue queueB1 = this.findQueue(queueB, B1);
        CSQueue queueB2 = this.findQueue(queueB, B2);
        CSQueue queueB3 = this.findQueue(queueB, B3);
        float capA = capacityA / 100.0f;
        float capB = capacityB / 100.0f;
        this.checkQueueCapacity(queueA, capA, capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB, capB, capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueA1, A1_CAPACITY / 100.0f, A1_CAPACITY / 100.0f * capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueA2, A2_CAPACITY / 100.0f, A2_CAPACITY / 100.0f * capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB1, B1_CAPACITY / 100.0f, B1_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB2, B2_CAPACITY / 100.0f, B2_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB3, B3_CAPACITY / 100.0f, B3_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
    }

    private void checkQueueCapacity(CSQueue q, float expectedCapacity, float expectedAbsCapacity, float expectedMaxCapacity, float expectedAbsMaxCapacity) {
        float epsilon = 1.0E-5f;
        Assert.assertEquals((String)"capacity", (float)expectedCapacity, (float)q.getCapacity(), (float)1.0E-5f);
        Assert.assertEquals((String)"absolute capacity", (float)expectedAbsCapacity, (float)q.getAbsoluteCapacity(), (float)1.0E-5f);
        Assert.assertEquals((String)"maximum capacity", (float)expectedMaxCapacity, (float)q.getMaximumCapacity(), (float)1.0E-5f);
        Assert.assertEquals((String)"absolute maximum capacity", (float)expectedAbsMaxCapacity, (float)q.getAbsoluteMaximumCapacity(), (float)1.0E-5f);
    }

    private CSQueue findQueue(CSQueue root, String queuePath) {
        if (root.getQueuePath().equals(queuePath)) {
            return root;
        }
        List childQueues = root.getChildQueues();
        if (childQueues != null) {
            for (CSQueue q : childQueues) {
                CSQueue result;
                if (!queuePath.startsWith(q.getQueuePath()) || (result = this.findQueue(q, queuePath)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private void checkApplicationResourceUsage(int expected, Application application) {
        Assert.assertEquals((long)expected, (long)application.getUsedResources().getMemory());
    }

    private void checkNodeResourceUsage(int expected, NodeManager node) {
        Assert.assertEquals((long)expected, (long)node.getUsed().getMemory());
        node.checkResourceUsage();
    }

    @Test(expected=IOException.class)
    public void testParseQueue() throws IOException {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.init((Configuration)conf);
        cs.start();
        conf.setQueues(A1, new String[]{"b1"});
        conf.setCapacity("root.a.a1.b1", 100.0f);
        conf.setUserLimitFactor("root.a.a1.b1", 100.0f);
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
    }

    @Test
    public void testReconnectedNode() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)csConf);
        cs.start();
        cs.reinitialize((Configuration)csConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null));
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1);
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Assert.assertEquals((long)6144L, (long)cs.getClusterResource().getMemory());
        n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 1);
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        Assert.assertEquals((long)4096L, (long)cs.getClusterResource().getMemory());
        cs.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshQueuesWithNewQueue() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        String B4 = "root.b.b4";
        float B4_CAPACITY = 10.0f;
        B3_CAPACITY -= B4_CAPACITY;
        try {
            conf.setCapacity(A, 80.0f);
            conf.setCapacity(B, 20.0f);
            conf.setQueues(B, new String[]{"b1", "b2", "b3", "b4"});
            conf.setCapacity(B1, B1_CAPACITY);
            conf.setCapacity(B2, B2_CAPACITY);
            conf.setCapacity(B3, B3_CAPACITY);
            conf.setCapacity(B4, B4_CAPACITY);
            cs.reinitialize((Configuration)conf, this.mockContext);
            this.checkQueueCapacities(cs, 80.0f, 20.0f);
            CSQueue rootQueue = cs.getRootQueue();
            CSQueue queueB = this.findQueue(rootQueue, B);
            CSQueue queueB4 = this.findQueue(queueB, B4);
            Assert.assertEquals((Object)queueB, (Object)queueB4.getParent());
        }
        finally {
            B3_CAPACITY += B4_CAPACITY;
            cs.stop();
        }
    }

    @Test
    public void testCapacitySchedulerInfo() throws Exception {
        QueueInfo queueInfo = this.resourceManager.getResourceScheduler().getQueueInfo("a", true, true);
        Assert.assertEquals((Object)queueInfo.getQueueName(), (Object)"a");
        Assert.assertEquals((long)queueInfo.getChildQueues().size(), (long)2L);
        List userACLInfo = this.resourceManager.getResourceScheduler().getQueueUserAclInfo();
        Assert.assertNotNull((Object)userACLInfo);
        for (QueueUserACLInfo queueUserACLInfo : userACLInfo) {
            Assert.assertEquals((long)this.getQueueCount(userACLInfo, queueUserACLInfo.getQueueName()), (long)1L);
        }
    }

    private int getQueueCount(List<QueueUserACLInfo> queueInformation, String queueName) {
        int result = 0;
        for (QueueUserACLInfo queueUserACLInfo : queueInformation) {
            if (!queueName.equals(queueUserACLInfo.getQueueName())) continue;
            ++result;
        }
        return result;
    }

    @Test
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        String host = HOST;
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        RMAppAttemptMetrics attemptMetric = new RMAppAttemptMetrics(appAttemptId, rm.getRMContext());
        RMAppImpl app = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        rm.getRMContext().getRMApps().put(appId, app);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "default", "user");
        cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        cs.handle((SchedulerEvent)addAttemptEvent);
        cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null);
        Assert.assertTrue((boolean)cs.getApplicationAttempt(appAttemptId).isBlacklisted(host));
        cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host));
        Assert.assertFalse((boolean)cs.getApplicationAttempt(appAttemptId).isBlacklisted(host));
        rm.stop();
    }

    @Test
    public void testResourceOverCommit() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)2048L, (long)report_nm1.getAvailableResource().getMemory());
        am1.addRequests(new String[]{HOST, "127.0.0.2"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(100L);
            alloc1Response = am1.schedule();
        }
        List allocated1 = alloc1Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated1.size());
        Assert.assertEquals((long)2048L, (long)((Container)allocated1.get(0)).getResource().getMemory());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated1.get(0)).getNodeId());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemory());
        Assert.assertEquals((long)4096L, (long)report_nm1.getUsedResource().getMemory());
        Container c1 = (Container)allocated1.get(0);
        Assert.assertEquals((long)2048L, (long)c1.getResource().getMemory());
        HashMap<NodeId, ResourceOption> nodeResourceMap = new HashMap<NodeId, ResourceOption>();
        nodeResourceMap.put(nm1.getNodeId(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)1), (int)-1));
        UpdateNodeResourceRequest request = UpdateNodeResourceRequest.newInstance(nodeResourceMap);
        AdminService as = rm.getAdminService();
        as.updateNodeResource(request);
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)4096L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)-2048L, (long)report_nm1.getAvailableResource().getMemory());
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)c1.getId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0);
        nm1.containerStatus(containerStatus);
        int waitCount = 0;
        while (attempt1.getJustFinishedContainers().size() < 1 && waitCount++ != 20) {
            LOG.info("Waiting for containers to be finished for app 1... Tried " + waitCount + " times already..");
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)attempt1.getJustFinishedContainers().size());
        Assert.assertEquals((long)1L, (long)am1.schedule().getCompletedContainersStatuses().size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemory());
        am1.addRequests(new String[]{HOST, "127.0.0.2"}, 3072, 1, 1);
        alloc1Response = am1.schedule();
        Assert.assertEquals((String)"Shouldn't have enough resource to allocate containers", (long)0L, (long)alloc1Response.getAllocatedContainers().size());
        int times = 0;
        while (alloc1Response.getAllocatedContainers().size() < 1 && times++ < 10) {
            LOG.info("Waiting for containers to be allocated for app 1... Tried " + times + " times already..");
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Shouldn't have enough resource to allocate containers", (long)0L, (long)alloc1Response.getAllocatedContainers().size());
        rm.stop();
    }

    @Test(timeout=5000L)
    public void testApplicationComparator() {
        CapacityScheduler cs = new CapacityScheduler();
        Comparator appComparator = cs.getApplicationComparator();
        ApplicationId id1 = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationId id2 = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationId id3 = ApplicationId.newInstance((long)2L, (int)1);
        FiCaSchedulerApp app1 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)id1);
        FiCaSchedulerApp app2 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app2.getApplicationId()).thenReturn((Object)id2);
        FiCaSchedulerApp app3 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app3.getApplicationId()).thenReturn((Object)id3);
        Assert.assertTrue((appComparator.compare(app1, app2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((appComparator.compare(app1, app3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((appComparator.compare(app2, app3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        Application application_1 = new Application("user_0", "a2", this.resourceManager);
        application_1.submit();
        Application application_2 = new Application("user_0", "b2", this.resourceManager);
        application_2.submit();
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(application_0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInA.contains(application_1.getApplicationAttemptId()));
        Assert.assertEquals((long)2L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(application_0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInRoot.contains(application_1.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInRoot.contains(application_2.getApplicationAttemptId()));
        Assert.assertEquals((long)3L, (long)appsInRoot.size());
        Assert.assertNull((Object)scheduler.getAppsInQueue("nonexistentqueue"));
    }

    @Test
    public void testAddAndRemoveAppFromCapacityScheduler() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        AbstractYarnScheduler cs = (AbstractYarnScheduler)rm.getResourceScheduler();
        SchedulerApplication<SchedulerApplicationAttempt> app = TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(cs.getSchedulerApplications(), (EventHandler<SchedulerEvent>)cs, "a1");
        Assert.assertEquals((Object)"a1", (Object)app.getQueue().getQueueName());
    }

    @Test
    public void testAsyncScheduling() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        int NODES = 100;
        for (i = 0; i < 100; ++i) {
            String host = "192.168.1." + i;
            RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
            cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        }
        for (i = 0; i < 100; ++i) {
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
    }

    private MockAM launchAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        nm.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }

    private void waitForAppPreemptionInfo(RMApp app, Resource preempted, int numAMPreempted, int numTaskPreempted, Resource currentAttemptPreempted, boolean currentAttemptAMPreempted, int numLatestAttemptTaskPreempted) throws InterruptedException {
        while (true) {
            RMAppMetrics appPM = app.getRMAppMetrics();
            RMAppAttemptMetrics attemptPM = app.getCurrentAppAttempt().getRMAppAttemptMetrics();
            if (appPM.getResourcePreempted().equals((Object)preempted) && appPM.getNumAMContainersPreempted() == numAMPreempted && appPM.getNumNonAMContainersPreempted() == numTaskPreempted && attemptPM.getResourcePreempted().equals((Object)currentAttemptPreempted) && app.getCurrentAppAttempt().getRMAppAttemptMetrics().getIsPreempted() == currentAttemptAMPreempted && attemptPM.getNumNonAMContainersPreempted() == numLatestAttemptTaskPreempted) {
                return;
            }
            Thread.sleep(500L);
        }
    }

    private void waitForNewAttemptCreated(RMApp app, ApplicationAttemptId previousAttemptId) throws InterruptedException {
        while (app.getCurrentAppAttempt().equals(previousAttemptId)) {
            Thread.sleep(500L);
        }
    }

    @Test(timeout=30000L)
    public void testAllocateDoesNotBlockOnSchedulerLock() throws Exception {
        final YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS((Configuration)conf, containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        RMApp app = rm.submitApp(1024, "appname", "appuser", acls);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        int msecToSleep = 100;
        for (int msecToWait = 10000; attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && msecToWait > 0; msecToWait -= msecToSleep) {
            LOG.info("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState());
            Thread.sleep(msecToSleep);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        final InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
        Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, rmBindAddress, (Configuration)conf);
            }
        });
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance((String)"localhost", (int)12345, (String)"");
        client.registerApplicationMaster(request);
        final CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread otherThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CapacityScheduler capacityScheduler = cs;
                synchronized (capacityScheduler) {
                    try {
                        barrier.await();
                        barrier.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (BrokenBarrierException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        otherThread.start();
        barrier.await();
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        client.allocate(allocateRequest);
        barrier.await();
        otherThread.join();
        rm.stop();
    }

    @Test
    public void testNumClusterNodes() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)conf);
        RMContext rmContext = TestUtils.getMockRMContext();
        cs.setRMContext(rmContext);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        cs.init((Configuration)csConf);
        cs.start();
        Assert.assertEquals((long)0L, (long)cs.getNumClusterNodes());
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1);
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Assert.assertEquals((long)2L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        Assert.assertEquals((long)1L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        Assert.assertEquals((long)2L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n2));
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        Assert.assertEquals((long)0L, (long)cs.getNumClusterNodes());
        cs.stop();
    }

    @Test(timeout=120000L)
    public void testPreemptionInfo() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 3);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        int CONTAINER_MEMORY = 1024;
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, 7.0, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = rm1.submitApp(CONTAINER_MEMORY);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        FiCaSchedulerApp schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app0.getApplicationId())).getCurrentAppAttempt();
        List<Container> allocatedContainers = am0.allocateAndWaitForContainers(3, CONTAINER_MEMORY, 1, 0.5, nm1);
        for (Container c : allocatedContainers) {
            cs.killContainer(schedulerAppAttempt.getRMContainer(c.getId()));
        }
        this.waitForAppPreemptionInfo(app0, Resource.newInstance((int)(CONTAINER_MEMORY * 3), (int)3, (double)1.5), 0, 3, Resource.newInstance((int)(CONTAINER_MEMORY * 3), (int)3, (double)1.5), false, 3);
        cs.killContainer(schedulerAppAttempt.getRMContainer(app0.getCurrentAppAttempt().getMasterContainer().getId()));
        this.waitForNewAttemptCreated(app0, am0.getApplicationAttemptId());
        this.waitForAppPreemptionInfo(app0, Resource.newInstance((int)(CONTAINER_MEMORY * 4), (int)4, (double)1.5), 1, 3, Resource.newInstance((int)0, (int)0, (double)0.0), false, 0);
        MockAM am1 = this.launchAM(app0, rm1, nm1);
        schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app0.getApplicationId())).getCurrentAppAttempt();
        allocatedContainers = am1.allocateAndWaitForContainers(3, CONTAINER_MEMORY, 1, 0.5, nm1);
        for (Container c : allocatedContainers) {
            cs.killContainer(schedulerAppAttempt.getRMContainer(c.getId()));
        }
        this.waitForAppPreemptionInfo(app0, Resource.newInstance((int)(CONTAINER_MEMORY * 7), (int)7, (double)3.0), 1, 6, Resource.newInstance((int)(CONTAINER_MEMORY * 3), (int)3, (double)1.5), false, 3);
        rm1.stop();
    }

    @Test(timeout=30000L)
    public void testRecoverRequestAfterPreemption() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = rm1.submitApp(1024);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        am1.allocate(HOST, 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId1, RMContainerState.ALLOCATED);
        RMContainer rmContainer = cs.getRMContainer(containerId1);
        List requests = rmContainer.getResourceRequests();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerNode node = cs.getNode(rmContainer.getAllocatedNode());
        for (ResourceRequest request : requests) {
            if (request.getResourceName().equals(node.getRackName()) || request.getResourceName().equals("*")) continue;
            Assert.assertNull((Object)app.getResourceRequest(request.getPriority(), request.getResourceName()));
        }
        cs.killContainer(rmContainer);
        Assert.assertEquals((long)3L, (long)requests.size());
        for (ResourceRequest request : requests) {
            Assert.assertEquals((long)1L, (long)app.getResourceRequest(request.getPriority(), request.getResourceName()).getNumContainers());
        }
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertTrue((containers.size() == 1 ? 1 : 0) != 0);
    }

    private MockRM setUpMove() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        return this.setUpMove((Configuration)conf);
    }

    private MockRM setUpMove(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        this.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        return rm;
    }

    @Test
    public void testMoveAppBasic() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("a1"));
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        scheduler.moveApplication(app.getApplicationId(), "b1");
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertEquals((long)1L, (long)appsInB1.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInB1.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("b1"));
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInB.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertTrue((boolean)appsInA1.isEmpty());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        rm.stop();
    }

    @Test
    public void testMoveAppSameParent() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("a1"));
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        List appsInA2 = scheduler.getAppsInQueue("a2");
        Assert.assertTrue((boolean)appsInA2.isEmpty());
        scheduler.moveApplication(app.getApplicationId(), "a2");
        appsInA2 = scheduler.getAppsInQueue("a2");
        Assert.assertEquals((long)1L, (long)appsInA2.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA2.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("a2"));
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertTrue((boolean)appsInA1.isEmpty());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        rm.stop();
    }

    @Test
    public void testMoveAppForMoveToQueueWithFreeCap() throws Exception {
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)3));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)2));
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        org.apache.hadoop.yarn.api.records.Priority priority_1 = Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)1024, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(1024, application_1);
        this.checkNodeResourceUsage(2048, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        scheduler.moveApplication(application_0.getApplicationId(), "b1");
        Task task_1_1 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_1);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        application_0.schedule();
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(3072, application_0);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
    }

    @Test
    public void testMoveAppSuccess() throws Exception {
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1));
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        org.apache.hadoop.yarn.api.records.Priority priority_1 = Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)3072, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)1024, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        scheduler.moveApplication(application_0.getApplicationId(), "b2");
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(0, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(1024, application_1);
        this.checkNodeResourceUsage(1024, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        scheduler.moveApplication(application_0.getApplicationId(), "a2");
        application_0.schedule();
        this.nodeUpdate(nm_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(3072, application_0);
        this.checkNodeResourceUsage(1024, nm_0);
        this.checkNodeResourceUsage(3072, nm_1);
    }

    @Test(expected=YarnException.class)
    public void testMoveAppViolateQueueState() throws Exception {
        this.resourceManager = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        StringBuilder qState = new StringBuilder();
        qState.append("yarn.scheduler.capacity.").append(B).append(".").append("state");
        csConf.set(qState.toString(), QueueState.STOPPED.name());
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.mockContext.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)6144, (int)1));
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        org.apache.hadoop.yarn.api.records.Priority priority_1 = Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        Resource capability_0_0 = Resources.createResource((int)3072, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0});
        application_0.addTask(task_0_0);
        application_0.schedule();
        this.nodeUpdate(nm_0);
        application_0.schedule();
        this.checkApplicationResourceUsage(3072, application_0);
        this.checkNodeResourceUsage(3072, nm_0);
        scheduler.moveApplication(application_0.getApplicationId(), "b1");
    }

    @Test
    public void testMoveAppQueueMetricsCheck() throws Exception {
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)2));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)2));
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        org.apache.hadoop.yarn.api.records.Priority priority_1 = Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)3072, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)1024, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        CapacityScheduler cs = (CapacityScheduler)this.resourceManager.getResourceScheduler();
        CSQueue origRootQ = cs.getRootQueue();
        CapacitySchedulerInfo oldInfo = new CapacitySchedulerInfo(origRootQ);
        int origNumAppsA = this.getNumAppsInQueue("a", origRootQ.getChildQueues());
        int origNumAppsRoot = origRootQ.getNumApplications();
        scheduler.moveApplication(application_0.getApplicationId(), "a2");
        CSQueue newRootQ = cs.getRootQueue();
        int newNumAppsA = this.getNumAppsInQueue("a", newRootQ.getChildQueues());
        int newNumAppsRoot = newRootQ.getNumApplications();
        CapacitySchedulerInfo newInfo = new CapacitySchedulerInfo(newRootQ);
        CapacitySchedulerLeafQueueInfo origOldA1 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a1", oldInfo.getQueues());
        CapacitySchedulerLeafQueueInfo origNewA1 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a1", newInfo.getQueues());
        CapacitySchedulerLeafQueueInfo targetOldA2 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a2", oldInfo.getQueues());
        CapacitySchedulerLeafQueueInfo targetNewA2 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a2", newInfo.getQueues());
        Assert.assertEquals((long)1L, (long)origOldA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)origNumAppsA);
        Assert.assertEquals((long)2L, (long)origNumAppsRoot);
        Assert.assertEquals((long)0L, (long)origNewA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)newNumAppsA);
        Assert.assertEquals((long)2L, (long)newNumAppsRoot);
        Assert.assertEquals((long)3072L, (long)origOldA1.getResourcesUsed().getMemory());
        Assert.assertEquals((long)1L, (long)origOldA1.getResourcesUsed().getvCores());
        Assert.assertEquals((long)0L, (long)origNewA1.getResourcesUsed().getMemory());
        Assert.assertEquals((long)0L, (long)origNewA1.getResourcesUsed().getvCores());
        Assert.assertEquals((long)3072L, (long)targetNewA2.getResourcesUsed().getMemory());
        Assert.assertEquals((long)1L, (long)targetNewA2.getResourcesUsed().getvCores());
        Assert.assertEquals((long)0L, (long)targetOldA2.getNumApplications());
        Assert.assertEquals((long)0L, (long)targetOldA2.getResourcesUsed().getMemory());
        Assert.assertEquals((long)0L, (long)targetOldA2.getResourcesUsed().getvCores());
        Assert.assertEquals((long)1L, (long)targetNewA2.getNumApplications());
        Assert.assertEquals((long)1L, (long)origOldA1.getNumContainers());
        Assert.assertEquals((long)0L, (long)origNewA1.getNumContainers());
        Assert.assertEquals((long)1L, (long)targetNewA2.getNumContainers());
        Assert.assertEquals((long)0L, (long)targetOldA2.getNumContainers());
        Assert.assertEquals((long)3072L, (long)((UserInfo)origOldA1.getUsers().getUsersList().get(0)).getResourcesUsed().getMemory());
        Assert.assertEquals((long)1L, (long)((UserInfo)origOldA1.getUsers().getUsersList().get(0)).getResourcesUsed().getvCores());
        Assert.assertEquals((long)0L, (long)origNewA1.getUsers().getUsersList().size());
        Assert.assertEquals((long)3072L, (long)((UserInfo)targetNewA2.getUsers().getUsersList().get(0)).getResourcesUsed().getMemory());
        Assert.assertEquals((long)1L, (long)((UserInfo)targetNewA2.getUsers().getUsersList().get(0)).getResourcesUsed().getvCores());
        application_0.schedule();
        this.checkApplicationResourceUsage(3072, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(1024, application_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
    }

    private int getNumAppsInQueue(String name, List<CSQueue> queues) {
        for (CSQueue queue : queues) {
            if (!queue.getQueueName().equals(name)) continue;
            return queue.getNumApplications();
        }
        return -1;
    }

    private CapacitySchedulerQueueInfo getQueueInfo(String name, CapacitySchedulerQueueInfoList info) {
        if (info != null) {
            for (CapacitySchedulerQueueInfo queueInfo : info.getQueueInfoList()) {
                if (queueInfo.getQueueName().equals(name)) {
                    return queueInfo;
                }
                CapacitySchedulerQueueInfo result = this.getQueueInfo(name, queueInfo.getQueues());
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Test
    public void testMoveAllApps() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("a1"));
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        scheduler.moveAllApps("a1", "b1");
        Thread.sleep(1000L);
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertEquals((long)1L, (long)appsInB1.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInB1.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("b1"));
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInB.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertTrue((boolean)appsInA1.isEmpty());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        rm.stop();
    }

    @Test
    public void testMoveAllAppsInvalidDestination() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        try {
            scheduler.moveAllApps("a1", "DOES_NOT_EXIST");
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        rm.stop();
    }

    @Test
    public void testMoveAllAppsInvalidSource() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        try {
            scheduler.moveAllApps("DOES_NOT_EXIST", "b1");
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        rm.stop();
    }

    @Test
    public void testKillAllAppsInQueue() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals("a1"));
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        scheduler.killAllAppsInQueue("a1");
        rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.isEmpty());
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertTrue((boolean)appsInA1.isEmpty());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        rm.stop();
    }

    @Test
    public void testKillAllAppsInvalidSource() throws Exception {
        MockRM rm = this.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        RMApp app = rm.submitApp(1024, "test-move-1", "user_0", null, "a1");
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        try {
            scheduler.killAllAppsInQueue("DOES_NOT_EXIST");
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAppReservationWithDominantResourceCalculator() throws Exception {
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 10240, 1);
        MockNM nm2 = rm.registerNode("127.0.0.1:1235", 10240, 4);
        rm.registerNode("127.0.0.1:1236", 10240, 4);
        RMApp app1 = rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)1024L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)9216L, (long)report_nm1.getAvailableResource().getMemory());
        am1.addRequests(new String[]{HOST, "127.0.0.2"}, 1024, 1, 1);
        am1.schedule();
        nm1.nodeHeartbeat(true);
        Thread.sleep(1000L);
        AllocateResponse allocResponse = am1.schedule();
        ApplicationResourceUsageReport report = rm.getResourceScheduler().getAppResourceUsageReport(attempt1.getAppAttemptId());
        Assert.assertEquals((long)0L, (long)allocResponse.getAllocatedContainers().size());
        Assert.assertEquals((long)0L, (long)report.getNumReservedContainers());
        nm2.nodeHeartbeat(true);
        while (allocResponse.getAllocatedContainers().size() == 0) {
            Thread.sleep(100L);
            allocResponse = am1.schedule();
        }
        report = rm.getResourceScheduler().getAppResourceUsageReport(attempt1.getAppAttemptId());
        Assert.assertEquals((long)1L, (long)allocResponse.getAllocatedContainers().size());
        Assert.assertEquals((long)0L, (long)report.getNumReservedContainers());
        rm.stop();
    }

    @Test
    public void testPreemptionDisabled() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueB = this.findQueue(rootQueue, B);
        CSQueue queueB2 = this.findQueue(queueB, B2);
        Assert.assertFalse((String)"queue root.b.b2 should default to preemptable", (boolean)queueB2.getPreemptionDisabled());
        conf.setPreemptionDisabled(rootQueue.getQueuePath(), true);
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        Assert.assertTrue((String)"queue root.b.b2 should have inherited non-preemptability from root", (boolean)queueB2.getPreemptionDisabled());
        conf.setPreemptionDisabled(rootQueue.getQueuePath(), false);
        conf.setPreemptionDisabled(queueB.getQueuePath(), true);
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        Assert.assertTrue((String)"queue root.b.b2 should have inherited non-preemptability from parent", (boolean)queueB2.getPreemptionDisabled());
        conf.setPreemptionDisabled(queueB2.getQueuePath(), false);
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        Assert.assertFalse((String)"queue root.b.b2 should have been preemptable", (boolean)queueB2.getPreemptionDisabled());
    }

    @Test
    public void testRefreshQueuesMaxAllocationRefresh() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        Assert.assertEquals((String)"max allocation in CS (memory)", (long)8192L, (long)cs.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((String)"max allocation in CS (vcores)", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation in CS (disks)", (double)4.0, (double)cs.getMaximumResourceCapability().getDisks(), (double)0.01);
        Assert.assertEquals((String)"max allocation for A1 (memory)", (long)8192L, (long)conf.getMaximumAllocationPerQueue(A1).getMemory());
        Assert.assertEquals((String)"max allocation for A1 (vcores)", (long)4L, (long)conf.getMaximumAllocationPerQueue(A1).getVirtualCores());
        Assert.assertEquals((String)"max allocation for A1 (disks)", (double)4.0, (double)conf.getMaximumAllocationPerQueue(A1).getDisks(), (double)0.01);
        Assert.assertEquals((String)"max allocation (memory)", (long)8192L, (long)conf.getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"max allocation (vcores)", (long)4L, (long)conf.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation (disks)", (double)4.0, (double)conf.getMaximumAllocation().getDisks(), (double)0.01);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = this.findQueue(rootQueue, A);
        CSQueue queueA1 = this.findQueue(queueA, A1);
        Assert.assertEquals((String)"queue max allocation (memory)", (long)((LeafQueue)queueA1).getMaximumAllocation().getMemory(), (long)8192L);
        this.setMaxAllocMb(conf, A1, 8191);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (memory)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception (memory)", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        this.setMaxAllocMb(conf, A1, 8192);
        cs.reinitialize((Configuration)conf, this.mockContext);
        Assert.assertEquals((String)"queue max allocation (vcores)", (long)((LeafQueue)queueA1).getMaximumAllocation().getVirtualCores(), (long)4L);
        this.setMaxAllocVcores(conf, A1, 3);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (vcores)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception (vcores)", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        this.setMaxAllocVcores(conf, A1, 4);
        cs.reinitialize((Configuration)conf, this.mockContext);
        Assert.assertEquals((String)"queue max allocation (memory)", (double)((LeafQueue)queueA1).getMaximumAllocation().getDisks(), (double)4.0, (double)0.01);
        this.setMaxAllocDisks(conf, A1, 3.5);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (disks)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception (disks)", (boolean)e.getCause().toString().contains("not be decreased"));
        }
    }

    @Test
    public void testRefreshQueuesMaxAllocationPerQueueLarge() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.init((Configuration)conf);
        cs.start();
        this.setMaxAllocMb(conf, B3, 10240);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (memory)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"maximum allocation exception (memory)", (boolean)e.getCause().getMessage().contains("larger than the cluster setting"));
        }
        this.setMaxAllocMb(conf, B3, 8192);
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.setMaxAllocVcores(conf, B3, 5);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (vcores)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"maximum allocation exception (vcores)", (boolean)e.getCause().getMessage().contains("larger than the cluster setting"));
        }
        this.setMaxAllocVcores(conf, B3, 4);
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.setMaxAllocDisks(conf, B3, 5.0);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (disks)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"maximum allocation exception (disks)", (boolean)e.getCause().getMessage().contains("larger than the cluster setting"));
        }
    }

    @Test
    public void testRefreshQueuesMaxAllocationRefreshLarger() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        this.setMaxAllocMb((Configuration)conf, 8192);
        this.setMaxAllocVcores((Configuration)conf, 4);
        this.setMaxAllocDisks((Configuration)conf, 4.0);
        this.setMaxAllocMb(conf, A1, 4096);
        this.setMaxAllocVcores(conf, A1, 2);
        this.setMaxAllocDisks(conf, A1, 2.0);
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        Assert.assertEquals((String)"max capability MB in CS", (long)8192L, (long)cs.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((String)"max capability vcores in CS", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max capability disks in CS", (double)4.0, (double)cs.getMaximumResourceCapability().getDisks(), (double)0.01);
        Assert.assertEquals((String)"max allocation MB A1", (long)4096L, (long)conf.getMaximumAllocationPerQueue(A1).getMemory());
        Assert.assertEquals((String)"max allocation vcores A1", (long)2L, (long)conf.getMaximumAllocationPerQueue(A1).getVirtualCores());
        Assert.assertEquals((String)"max allocation disks A1", (double)2.0, (double)conf.getMaximumAllocationPerQueue(A1).getDisks(), (double)0.01);
        Assert.assertEquals((String)"cluster max allocation MB", (long)8192L, (long)conf.getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"cluster max allocation vcores", (long)4L, (long)conf.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"cluster max allocation disks", (double)4.0, (double)conf.getMaximumAllocation().getDisks(), (double)0.01);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = this.findQueue(rootQueue, A);
        CSQueue queueA1 = this.findQueue(queueA, A1);
        Assert.assertEquals((String)"queue max allocation (memory)", (long)((LeafQueue)queueA1).getMaximumAllocation().getMemory(), (long)4096L);
        Assert.assertEquals((String)"queue max allocation (vcores)", (long)((LeafQueue)queueA1).getMaximumAllocation().getVirtualCores(), (long)2L);
        Assert.assertEquals((String)"queue max allocation (disks)", (double)((LeafQueue)queueA1).getMaximumAllocation().getDisks(), (double)2.0, (double)0.01);
        this.setMaxAllocMb(conf, A1, 6144);
        this.setMaxAllocVcores(conf, A1, 3);
        this.setMaxAllocDisks(conf, A1, 3.0);
        cs.reinitialize((Configuration)conf, null);
        Assert.assertEquals((String)"max allocation MB A1", (long)6144L, (long)conf.getMaximumAllocationPerQueue(A1).getMemory());
        Assert.assertEquals((String)"max allocation vcores A1", (long)3L, (long)conf.getMaximumAllocationPerQueue(A1).getVirtualCores());
        Assert.assertEquals((String)"max allocation disks A1", (double)3.0, (double)conf.getMaximumAllocationPerQueue(A1).getDisks(), (double)0.01);
        Assert.assertEquals((String)"max allocation MB cluster", (long)8192L, (long)conf.getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"max allocation vcores cluster", (long)4L, (long)conf.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation disks cluster", (double)4.0, (double)conf.getMaximumAllocation().getDisks(), (double)0.01);
        Assert.assertEquals((String)"queue max allocation MB", (long)6144L, (long)((LeafQueue)queueA1).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue max allocation vcores", (long)3L, (long)((LeafQueue)queueA1).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue max allocation disks", (double)3.0, (double)((LeafQueue)queueA1).getMaximumAllocation().getDisks(), (double)0.01);
        Assert.assertEquals((String)"max capability MB cluster", (long)8192L, (long)cs.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((String)"cluster max capability vcores", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"cluster max capability disks", (double)4.0, (double)cs.getMaximumResourceCapability().getDisks(), (double)0.01);
    }

    @Test
    public void testRefreshQueuesMaxAllocationCSError() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        this.setMaxAllocMb((Configuration)conf, 10240);
        this.setMaxAllocVcores((Configuration)conf, 10);
        this.setMaxAllocDisks((Configuration)conf, 10.0);
        this.setMaxAllocMb(conf, A1, 4096);
        this.setMaxAllocVcores(conf, A1, 4);
        this.setMaxAllocDisks(conf, A1, 4.0);
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        Assert.assertEquals((String)"max allocation MB in CS", (long)10240L, (long)cs.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((String)"max allocation vcores in CS", (long)10L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation disks in CS", (double)10.0, (double)cs.getMaximumResourceCapability().getDisks(), (double)0.01);
        this.setMaxAllocMb((Configuration)conf, 6144);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (memory)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception (memory)", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        this.setMaxAllocMb((Configuration)conf, 10240);
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.setMaxAllocVcores((Configuration)conf, 8);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (vcores)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception (vcores)", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        this.setMaxAllocVcores((Configuration)conf, 10);
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.setMaxAllocDisks((Configuration)conf, 8.0);
        try {
            cs.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"should have thrown exception (disks)");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception (disks)", (boolean)e.getCause().toString().contains("not be decreased"));
        }
    }

    @Test
    public void testRefreshQueuesMaxAllocationCSLarger() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        this.setMaxAllocMb((Configuration)conf, 10240);
        this.setMaxAllocVcores((Configuration)conf, 10);
        this.setMaxAllocDisks((Configuration)conf, 10.0);
        this.setMaxAllocMb(conf, A1, 4096);
        this.setMaxAllocVcores(conf, A1, 4);
        this.setMaxAllocDisks(conf, A1, 4.0);
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, this.mockContext);
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        Assert.assertEquals((String)"max allocation MB in CS", (long)10240L, (long)cs.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((String)"max allocation vcores in CS", (long)10L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation disks in CS", (double)10.0, (double)cs.getMaximumResourceCapability().getDisks(), (double)0.01);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = this.findQueue(rootQueue, A);
        CSQueue queueB = this.findQueue(rootQueue, B);
        CSQueue queueA1 = this.findQueue(queueA, A1);
        CSQueue queueA2 = this.findQueue(queueA, A2);
        CSQueue queueB2 = this.findQueue(queueB, B2);
        Assert.assertEquals((String)"queue A1 max allocation MB", (long)4096L, (long)((LeafQueue)queueA1).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue A1 max allocation vcores", (long)4L, (long)((LeafQueue)queueA1).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue A1 max allocation disks", (double)4.0, (double)((LeafQueue)queueA1).getMaximumAllocation().getDisks(), (double)0.01);
        Assert.assertEquals((String)"queue A2 max allocation MB", (long)10240L, (long)((LeafQueue)queueA2).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue A2 max allocation vcores", (long)10L, (long)((LeafQueue)queueA2).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue A2 max allocation disks", (double)10.0, (double)((LeafQueue)queueA2).getMaximumAllocation().getDisks(), (double)0.01);
        Assert.assertEquals((String)"queue B2 max allocation MB", (long)10240L, (long)((LeafQueue)queueB2).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue B2 max allocation vcores", (long)10L, (long)((LeafQueue)queueB2).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue B2 max allocation disk", (double)10.0, (double)((LeafQueue)queueB2).getMaximumAllocation().getDisks(), (double)0.01);
        this.setMaxAllocMb((Configuration)conf, 12288);
        this.setMaxAllocVcores((Configuration)conf, 12);
        this.setMaxAllocDisks((Configuration)conf, 12.0);
        cs.reinitialize((Configuration)conf, null);
        Assert.assertEquals((String)"max allocation MB in CS", (long)12288L, (long)cs.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((String)"max allocation vcores in CS", (long)12L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation disks in CS", (double)12.0, (double)cs.getMaximumResourceCapability().getDisks(), (double)0.01);
        Assert.assertEquals((String)"queue A1 max MB allocation", (long)4096L, (long)((LeafQueue)queueA1).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue A1 max vcores allocation", (long)4L, (long)((LeafQueue)queueA1).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue A1 max disks allocation", (double)4.0, (double)((LeafQueue)queueA1).getMaximumAllocation().getDisks(), (double)0.01);
        Assert.assertEquals((String)"queue A2 max MB allocation", (long)12288L, (long)((LeafQueue)queueA2).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue A2 max vcores allocation", (long)12L, (long)((LeafQueue)queueA2).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue A2 max disks allocation", (double)12.0, (double)((LeafQueue)queueA2).getMaximumAllocation().getDisks(), (double)0.1);
        Assert.assertEquals((String)"queue B2 max MB allocation", (long)12288L, (long)((LeafQueue)queueB2).getMaximumAllocation().getMemory());
        Assert.assertEquals((String)"queue B2 max vcores allocation", (long)12L, (long)((LeafQueue)queueB2).getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue B2 max disks allocation", (double)12.0, (double)((LeafQueue)queueB2).getMaximumAllocation().getDisks(), (double)0.01);
    }

    private void waitContainerAllocated(MockAM am, int mem, int nContainer, int startContainerId, MockRM rm, MockNM nm) throws Exception {
        for (int cId = startContainerId; cId < startContainerId + nContainer; ++cId) {
            am.allocate("*", mem, 1, new ArrayList<ContainerId>());
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)cId);
            Assert.assertTrue((boolean)rm.waitForState(nm, containerId, RMContainerState.ALLOCATED, 10000));
        }
    }

    @Test
    public void testHierarchyQueuesCurrentLimits() throws Exception {
        YarnConfiguration conf = new YarnConfiguration((Configuration)this.setupQueueConfiguration(new CapacitySchedulerConfiguration()));
        conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 102400, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        this.waitContainerAllocated(am1, 1024, 1, 2, rm1, nm1);
        Assert.assertEquals((long)70656L, (long)am1.doHeartbeat().getAvailableResources().getMemory());
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "b2");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        this.waitContainerAllocated(am2, 8192, 5, 2, rm1, nm1);
        this.waitContainerAllocated(am1, 1024, 1, 3, rm1, nm1);
        Assert.assertEquals((long)57344L, (long)am1.doHeartbeat().getAvailableResources().getMemory());
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "a1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        this.waitContainerAllocated(am3, 8192, 3, 2, rm1, nm1);
        this.waitContainerAllocated(am1, 1024, 1, 4, rm1, nm1);
        Assert.assertEquals((long)30720L, (long)am1.doHeartbeat().getAvailableResources().getMemory());
    }

    @Test
    public void testApplicationHeadRoom() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        RMAppAttemptMetrics attemptMetric = new RMAppAttemptMetrics(appAttemptId, rm.getRMContext());
        RMAppImpl app = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        rm.getRMContext().getRMApps().put(appId, app);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "default", "user");
        cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        cs.handle((SchedulerEvent)addAttemptEvent);
        Allocation allocate = cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, null);
        Assert.assertNotNull((Object)attempt);
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)allocate.getResourceLimit());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)attemptMetric.getApplicationAttemptHeadroom());
        Resource newResource = Resource.newInstance((int)4096, (int)0, (double)0.0);
        RMNode node = MockNodes.newNodeInfo(0, newResource, 1, HOST);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        allocate = cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, null);
        Assert.assertEquals((Object)newResource, (Object)allocate.getResourceLimit());
        Assert.assertEquals((Object)newResource, (Object)attemptMetric.getApplicationAttemptHeadroom());
        rm.stop();
    }

    @Test
    public void testDefaultNodeLabelExpressionQueueConfig() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        conf.setDefaultNodeLabelExpression(A, " x");
        conf.setDefaultNodeLabelExpression(B, " y ");
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        QueueInfo queueInfoA = cs.getQueueInfo("a", true, false);
        Assert.assertEquals((Object)queueInfoA.getQueueName(), (Object)"a");
        Assert.assertEquals((Object)queueInfoA.getDefaultNodeLabelExpression(), (Object)"x");
        QueueInfo queueInfoB = cs.getQueueInfo("b", true, false);
        Assert.assertEquals((Object)queueInfoB.getQueueName(), (Object)"b");
        Assert.assertEquals((Object)queueInfoB.getDefaultNodeLabelExpression(), (Object)"y");
    }

    @Test(timeout=30000L)
    public void testAMLimitUsage() throws Exception {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.set("yarn.scheduler.capacity.resource-calculator", DefaultResourceCalculator.class.getName());
        this.verifyAMLimitForLeafQueue(config);
        config.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.verifyAMLimitForLeafQueue(config);
    }

    private void verifyAMLimitForLeafQueue(CapacitySchedulerConfiguration config) throws Exception {
        MockRM rm = this.setUpMove((Configuration)config);
        String queueName = "a1";
        String userName = "user_0";
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        LeafQueue queueA = (LeafQueue)((CapacityScheduler)scheduler).getQueue(queueName);
        Resource amResourceLimit = queueA.getAMResourceLimit();
        Resource amResource = Resource.newInstance((int)(amResourceLimit.getMemory() + 1), (int)(amResourceLimit.getVirtualCores() + 1));
        rm.submitApp(amResource.getMemory(), "app-1", userName, null, queueName);
        rm.submitApp(amResource.getMemory(), "app-1", userName, null, queueName);
        Assert.assertEquals((String)"PendingApplications should be 1", (long)1L, (long)queueA.getNumPendingApplications());
        Assert.assertEquals((String)"Active applications should be 1", (long)1L, (long)queueA.getNumActiveApplications());
        Assert.assertEquals((String)"User PendingApplications should be 1", (long)1L, (long)queueA.getUser(userName).getPendingApplications());
        Assert.assertEquals((String)"User Active applications should be 1", (long)1L, (long)queueA.getUser(userName).getActiveApplications());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAMUsedResource() throws Exception {
        int amMemory = 50;
        MockRM rm = this.setUpMove();
        Configuration conf = rm.getConfig();
        int minAllocMb = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        Assert.assertTrue((String)"AM memory is greater than or equql to minAllocation", (amMemory < minAllocMb ? 1 : 0) != 0);
        Resource minAllocResource = Resource.newInstance((int)minAllocMb, (int)1);
        String queueName = "a1";
        RMApp rmApp = rm.submitApp(amMemory, "app-1", "user_0", null, queueName);
        Assert.assertEquals((String)"RMApp does not containes minimum allocation", (Object)minAllocResource, (Object)rmApp.getAMResourceRequest().getCapability());
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        LeafQueue queueA = (LeafQueue)((CapacityScheduler)scheduler).getQueue(queueName);
        Assert.assertEquals((String)"Minimum Resource for AM is incorrect", (Object)minAllocResource, (Object)queueA.getUser("user_0").getResourceUsage().getAMUsed());
        rm.stop();
    }

    private void setMaxAllocMb(Configuration conf, int maxAllocMb) {
        conf.setInt("yarn.scheduler.maximum-allocation-mb", maxAllocMb);
    }

    private void setMaxAllocMb(CapacitySchedulerConfiguration conf, String queueName, int maxAllocMb) {
        String propName = CapacitySchedulerConfiguration.getQueuePrefix((String)queueName) + "maximum-allocation-mb";
        conf.setInt(propName, maxAllocMb);
    }

    private void setMaxAllocVcores(Configuration conf, int maxAllocVcores) {
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", maxAllocVcores);
    }

    private void setMaxAllocVcores(CapacitySchedulerConfiguration conf, String queueName, int maxAllocVcores) {
        String propName = CapacitySchedulerConfiguration.getQueuePrefix((String)queueName) + "maximum-allocation-vcores";
        conf.setInt(propName, maxAllocVcores);
    }

    private void setMaxAllocDisks(Configuration conf, double maxAllocDisks) {
        conf.setDouble("yarn.scheduler.maximum-allocation-disks", maxAllocDisks);
    }

    private void setMaxAllocDisks(CapacitySchedulerConfiguration conf, String queueName, double maxAllocDisks) {
        String propName = CapacitySchedulerConfiguration.getQueuePrefix((String)queueName) + "maximum-allocation-disks";
        conf.setDouble(propName, maxAllocDisks);
    }

    @Test
    public void testSchedulingOnRemovedNode() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        RMApp app = rm.submitApp(100);
        rm.drainEvents();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 10240, 10);
        MockAM am = MockRM.launchAndRegisterAM(app, rm, nm1);
        MockNM nm2 = rm.registerNode("127.0.0.1:1235", 10240, 10);
        am.allocate("*", 2048, 1, null);
        CapacityScheduler scheduler = (CapacityScheduler)rm.getRMContext().getScheduler();
        FiCaSchedulerNode node = (FiCaSchedulerNode)scheduler.getAllNodes().get(nm2.getNodeId());
        scheduler.handle((SchedulerEvent)new NodeRemovedSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm2.getNodeId())));
        scheduler.allocateContainersToNode(node);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        scheduler.handle((SchedulerEvent)appRemovedEvent1);
        rm.stop();
    }
}

