/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.event.Level;

public class TestNodesListManager {
    ArrayList<ApplicationId> applist = new ArrayList();
    private static final String HOST = "127.0.0.1";

    @Test(timeout=300000L)
    public void testNodeUsableEvent() throws Exception {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        final Dispatcher dispatcher = this.getDispatcher();
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected Dispatcher createDispatcher() {
                return dispatcher;
            }
        };
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 28000);
        NetUtils.addStaticResolution((String)"h1", (String)HOST);
        NodesListManager nodesListManager = rm.getNodesListManager();
        Resource clusterResource = Resource.newInstance((int)28000, (int)8);
        RMNode rmnode = MockNodes.newNodeInfo(1, clusterResource);
        RMApp killrmApp = rm.submitApp(200);
        rm.killApp(killrmApp.getApplicationId());
        rm.waitForState(killrmApp.getApplicationId(), RMAppState.KILLED);
        RMApp finshrmApp = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = finshrmApp.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        RMApp subrmApp = rm.submitApp(200);
        nodesListManager.handle(new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmnode));
        if (this.applist.size() > 0) {
            Assert.assertTrue((String)("Event based on running app expected " + subrmApp.getApplicationId()), (boolean)this.applist.contains(subrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on finish app not expected " + finshrmApp.getApplicationId()), (boolean)this.applist.contains(finshrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on killed app not expected " + killrmApp.getApplicationId()), (boolean)this.applist.contains(killrmApp.getApplicationId()));
        } else {
            Assert.fail((String)"Events received should have beeen more than 1");
        }
        this.applist.clear();
        nodesListManager.handle(new NodesListManagerEvent(NodesListManagerEventType.NODE_UNUSABLE, rmnode));
        if (this.applist.size() > 0) {
            Assert.assertTrue((String)("Event based on running app expected " + subrmApp.getApplicationId()), (boolean)this.applist.contains(subrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on finish app not expected " + finshrmApp.getApplicationId()), (boolean)this.applist.contains(finshrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on killed app not expected " + killrmApp.getApplicationId()), (boolean)this.applist.contains(killrmApp.getApplicationId()));
        } else {
            Assert.fail((String)"Events received should have beeen more than 1");
        }
    }

    private Dispatcher getDispatcher() {
        AsyncDispatcher dispatcher = new AsyncDispatcher(){

            public EventHandler getEventHandler() {
                EventHandler handler = (EventHandler)Mockito.spy((Object)super.getEventHandler());
                class EventArgMatcher
                extends ArgumentMatcher<AbstractEvent> {
                    EventArgMatcher() {
                    }

                    public boolean matches(Object argument) {
                        if (argument instanceof RMAppNodeUpdateEvent) {
                            ApplicationId appid = ((RMAppNodeUpdateEvent)argument).getApplicationId();
                            TestNodesListManager.this.applist.add(appid);
                        }
                        return false;
                    }
                }
                ((EventHandler)Mockito.doNothing().when((Object)handler)).handle((Event)Matchers.argThat((Matcher)new EventArgMatcher()));
                return handler;
            }
        };
        return dispatcher;
    }
}

