/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRLESparseResourceAllocation {
    private static final Logger LOG = LoggerFactory.getLogger(TestRLESparseResourceAllocation.class);

    @Test
    public void testBlocks() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        Resource minAlloc = Resource.newInstance((int)1, (int)1);
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc, minAlloc);
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        Set<Map.Entry<ReservationInterval, ReservationRequest>> inputs = this.generateAllocation(start, alloc, false).entrySet();
        for (Map.Entry<ReservationInterval, ReservationRequest> ip : inputs) {
            rleSparseVector.addInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        Assert.assertFalse((boolean)rleSparseVector.isEmpty());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(99L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 1)));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 2)));
        for (Map.Entry<ReservationInterval, ReservationRequest> ip : inputs) {
            rleSparseVector.removeInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testSteps() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        Resource minAlloc = Resource.newInstance((int)1, (int)1);
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc, minAlloc);
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        Set<Map.Entry<ReservationInterval, ReservationRequest>> inputs = this.generateAllocation(start, alloc, true).entrySet();
        for (Map.Entry<ReservationInterval, ReservationRequest> ip : inputs) {
            rleSparseVector.addInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        Assert.assertFalse((boolean)rleSparseVector.isEmpty());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(99L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 1)));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 2)));
        for (Map.Entry<ReservationInterval, ReservationRequest> ip : inputs) {
            rleSparseVector.removeInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testSkyline() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        Resource minAlloc = Resource.newInstance((int)1, (int)1);
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc, minAlloc);
        int[] alloc = new int[]{0, 5, 10, 10, 5, 0};
        int start = 100;
        Set<Map.Entry<ReservationInterval, ReservationRequest>> inputs = this.generateAllocation(start, alloc, true).entrySet();
        for (Map.Entry<ReservationInterval, ReservationRequest> ip : inputs) {
            rleSparseVector.addInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        Assert.assertFalse((boolean)rleSparseVector.isEmpty());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(99L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 1)));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 2)));
        for (Map.Entry<ReservationInterval, ReservationRequest> ip : inputs) {
            rleSparseVector.removeInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testZeroAlloaction() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        Resource minAlloc = Resource.newInstance((int)1, (int)1);
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc, minAlloc);
        rleSparseVector.addInterval(new ReservationInterval(0L, Long.MAX_VALUE), ReservationRequest.newInstance((Resource)Resource.newInstance((int)0, (int)0), (int)0));
        LOG.info(rleSparseVector.toString());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(new Random().nextLong()));
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    private Map<ReservationInterval, ReservationRequest> generateAllocation(int startTime, int[] alloc, boolean isStep) {
        HashMap<ReservationInterval, ReservationRequest> req = new HashMap<ReservationInterval, ReservationRequest>();
        int numContainers = 0;
        for (int i = 0; i < alloc.length; ++i) {
            numContainers = isStep ? alloc[i] + i : alloc[i];
            req.put(new ReservationInterval((long)(startTime + i), (long)(startTime + i + 1)), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers));
        }
        return req;
    }
}

