/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NodeManager
implements ContainerManagementProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(NodeManager.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final String containerManagerAddress;
    private final String nodeHttpAddress;
    private final String rackName;
    private final NodeId nodeId;
    private final Resource capability;
    private final ResourceManager resourceManager;
    Resource available = (Resource)recordFactory.newRecordInstance(Resource.class);
    Resource used = (Resource)recordFactory.newRecordInstance(Resource.class);
    final ResourceTrackerService resourceTrackerService;
    final Map<ApplicationId, List<Container>> containers = new HashMap<ApplicationId, List<Container>>();
    final Map<Container, ContainerStatus> containerStatusMap = new HashMap<Container, ContainerStatus>();
    int responseID = 0;

    public NodeManager(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability, ResourceManager resourceManager) throws IOException, YarnException {
        this.containerManagerAddress = hostName + ":" + containerManagerPort;
        this.nodeHttpAddress = hostName + ":" + httpPort;
        this.rackName = rackName;
        this.resourceTrackerService = resourceManager.getResourceTrackerService();
        this.capability = capability;
        Resources.addTo((Resource)this.available, (Resource)capability);
        this.nodeId = NodeId.newInstance((String)hostName, (int)containerManagerPort);
        RegisterNodeManagerRequest request = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        request.setHttpPort(httpPort);
        request.setResource(capability);
        request.setNodeId(this.nodeId);
        request.setNMVersion(YarnVersionInfo.getVersion());
        this.resourceTrackerService.registerNodeManager(request);
        this.resourceManager = resourceManager;
        resourceManager.getResourceScheduler().getNodeReport(this.nodeId);
    }

    public String getHostName() {
        return this.containerManagerAddress;
    }

    public String getRackName() {
        return this.rackName;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Resource getCapability() {
        return this.capability;
    }

    public Resource getAvailable() {
        return this.available;
    }

    public Resource getUsed() {
        return this.used;
    }

    private List<ContainerStatus> getContainerStatuses(Map<ApplicationId, List<Container>> containers) {
        ArrayList<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
        for (List<Container> appContainers : containers.values()) {
            for (Container container : appContainers) {
                containerStatuses.add(this.containerStatusMap.get(container));
            }
        }
        return containerStatuses;
    }

    public void heartbeat() throws IOException, YarnException {
        NodeStatus nodeStatus = NodeManager.createNodeStatus(this.nodeId, this.getContainerStatuses(this.containers));
        nodeStatus.setResponseId(this.responseID);
        NodeHeartbeatRequest request = (NodeHeartbeatRequest)recordFactory.newRecordInstance(NodeHeartbeatRequest.class);
        request.setNodeStatus(nodeStatus);
        NodeHeartbeatResponse response = this.resourceTrackerService.nodeHeartbeat(request);
        this.responseID = response.getResponseId();
    }

    public synchronized StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
        for (StartContainerRequest request : requests.getStartContainerRequests()) {
            Token containerToken = request.getContainerToken();
            ContainerTokenIdentifier tokenId = null;
            try {
                tokenId = BuilderUtils.newContainerTokenIdentifier((Token)containerToken);
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            ContainerId containerID = tokenId.getContainerID();
            ApplicationId applicationId = containerID.getApplicationAttemptId().getApplicationId();
            List<Container> applicationContainers = this.containers.get(applicationId);
            if (applicationContainers == null) {
                applicationContainers = new ArrayList<Container>();
                this.containers.put(applicationId, applicationContainers);
            }
            for (Container container : applicationContainers) {
                if (container.getId().compareTo(containerID) != 0) continue;
                throw new IllegalStateException("Container " + containerID + " already setup on node " + this.containerManagerAddress);
            }
            Container container = BuilderUtils.newContainer((ContainerId)containerID, (NodeId)this.nodeId, (String)this.nodeHttpAddress, (Resource)tokenId.getResource(), null, null);
            ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)container.getId(), (ContainerState)ContainerState.NEW, (String)"", (int)-1000);
            applicationContainers.add(container);
            this.containerStatusMap.put(container, containerStatus);
            Resources.subtractFrom((Resource)this.available, (Resource)tokenId.getResource());
            Resources.addTo((Resource)this.used, (Resource)tokenId.getResource());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("startContainer: node=" + this.containerManagerAddress + " application=" + applicationId + " container=" + container + " available=" + this.available + " used=" + this.used);
        }
        StartContainersResponse response = StartContainersResponse.newInstance(null, null, null);
        return response;
    }

    public synchronized void checkResourceUsage() {
        LOG.info("Checking resource usage for " + this.containerManagerAddress);
        Assert.assertEquals((long)this.available.getMemory(), (long)this.resourceManager.getResourceScheduler().getNodeReport(this.nodeId).getAvailableResource().getMemory());
        Assert.assertEquals((long)this.used.getMemory(), (long)this.resourceManager.getResourceScheduler().getNodeReport(this.nodeId).getUsedResource().getMemory());
    }

    public synchronized StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
        for (ContainerId containerID : request.getContainerIds()) {
            String applicationId = String.valueOf(containerID.getApplicationAttemptId().getApplicationId().getId());
            List<Container> applicationContainers = this.containers.get(containerID.getApplicationAttemptId().getApplicationId());
            for (Container c : applicationContainers) {
                if (c.getId().compareTo(containerID) != 0) continue;
                ContainerStatus containerStatus = this.containerStatusMap.get(c);
                containerStatus.setState(ContainerState.COMPLETE);
                this.containerStatusMap.put(c, containerStatus);
            }
            try {
                this.heartbeat();
            }
            catch (IOException ioe) {
                throw RPCUtil.getRemoteException((Throwable)ioe);
            }
            int ctr = 0;
            Container container = null;
            Iterator<Container> i = applicationContainers.iterator();
            while (i.hasNext()) {
                container = i.next();
                if (container.getId().compareTo(containerID) != 0) continue;
                i.remove();
                ++ctr;
            }
            if (ctr != 1) {
                throw new IllegalStateException("Container " + containerID + " stopped " + ctr + " times!");
            }
            Resources.addTo((Resource)this.available, (Resource)container.getResource());
            Resources.subtractFrom((Resource)this.used, (Resource)container.getResource());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("stopContainer: node=" + this.containerManagerAddress + " application=" + applicationId + " container=" + containerID + " available=" + this.available + " used=" + this.used);
        }
        return StopContainersResponse.newInstance(null, null);
    }

    public synchronized GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        for (ContainerId containerId : request.getContainerIds()) {
            List<Container> appContainers = this.containers.get(containerId.getApplicationAttemptId().getApplicationId());
            Container container = null;
            for (Container c : appContainers) {
                if (!c.getId().equals((Object)containerId)) continue;
                container = c;
            }
            if (container == null || this.containerStatusMap.get(container).getState() == null) continue;
            statuses.add(this.containerStatusMap.get(container));
        }
        return GetContainerStatusesResponse.newInstance(statuses, null);
    }

    public static NodeStatus createNodeStatus(NodeId nodeId, List<ContainerStatus> containers) {
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        NodeStatus nodeStatus = (NodeStatus)recordFactory.newRecordInstance(NodeStatus.class);
        nodeStatus.setNodeId(nodeId);
        nodeStatus.setContainersStatuses(containers);
        NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class);
        nodeHealthStatus.setIsNodeHealthy(true);
        nodeStatus.setNodeHealthStatus(nodeHealthStatus);
        return nodeStatus;
    }
}

