/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DefaultLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingLinuxContainerRuntime.class);
    private DefaultLinuxContainerRuntime defaultLinuxContainerRuntime;
    private DockerLinuxContainerRuntime dockerLinuxContainerRuntime;

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(conf);
        this.defaultLinuxContainerRuntime = new DefaultLinuxContainerRuntime(privilegedOperationExecutor);
        this.defaultLinuxContainerRuntime.initialize(conf);
        this.dockerLinuxContainerRuntime = new DockerLinuxContainerRuntime(privilegedOperationExecutor);
        this.dockerLinuxContainerRuntime.initialize(conf);
    }

    private LinuxContainerRuntime pickContainerRuntime(Container container) {
        Map env = container.getLaunchContext().getEnvironment();
        LinuxContainerRuntime runtime = DockerLinuxContainerRuntime.isDockerContainerRequested(env) ? this.dockerLinuxContainerRuntime : this.defaultLinuxContainerRuntime;
        if (LOG.isInfoEnabled()) {
            LOG.info("Using container runtime: " + runtime.getClass().getSimpleName());
        }
        return runtime;
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.prepareContainer(ctx);
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.launchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.signalContainer(ctx);
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.reapContainer(ctx);
    }
}

