/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationApplicationHomeSubClusterStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationMembershipStateStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationPolicyStoreInputValidator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFederationStateStoreInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(TestFederationStateStoreInputValidator.class);
    private static SubClusterId subClusterId;
    private static String amRMServiceAddress;
    private static String clientRMServiceAddress;
    private static String rmAdminServiceAddress;
    private static String rmWebServiceAddress;
    private static int lastHeartBeat;
    private static SubClusterState stateNew;
    private static SubClusterState stateLost;
    private static ApplicationId appId;
    private static int lastStartTime;
    private static String capability;
    private static String queue;
    private static String type;
    private static ByteBuffer params;
    private static SubClusterId subClusterIdInvalid;
    private static SubClusterId subClusterIdNull;
    private static int lastHeartBeatNegative;
    private static int lastStartTimeNegative;
    private static SubClusterState stateNull;
    private static ApplicationId appIdNull;
    private static String capabilityNull;
    private static String capabilityEmpty;
    private static String addressNull;
    private static String addressEmpty;
    private static String addressWrong;
    private static String addressWrongPort;
    private static String queueEmpty;
    private static String queueNull;
    private static String typeEmpty;
    private static String typeNull;

    @BeforeClass
    public static void setUp() {
        subClusterId = SubClusterId.newInstance((String)"abc");
        amRMServiceAddress = "localhost:8032";
        clientRMServiceAddress = "localhost:8034";
        rmAdminServiceAddress = "localhost:8031";
        rmWebServiceAddress = "localhost:8088";
        lastHeartBeat = 1000;
        stateNew = SubClusterState.SC_NEW;
        stateLost = SubClusterState.SC_LOST;
        lastStartTime = 1000;
        capability = "Memory VCores";
        appId = ApplicationId.newInstance((long)lastStartTime, (int)1);
        queue = "default";
        type = "random";
        params = ByteBuffer.allocate(10);
        params.put((byte)-1);
        subClusterIdInvalid = SubClusterId.newInstance((String)"");
        subClusterIdNull = null;
        lastHeartBeatNegative = -10;
        lastStartTimeNegative = -10;
        stateNull = null;
        appIdNull = null;
        capabilityNull = null;
        capabilityEmpty = "";
        addressNull = null;
        addressEmpty = "";
        addressWrong = "AddressWrong";
        addressWrongPort = "Address:WrongPort";
        queueEmpty = "";
        queueNull = null;
        typeEmpty = "";
        typeNull = null;
    }

    @Test
    public void testValidateSubClusterRegisterRequest() {
        SubClusterRegisterRequest request;
        SubClusterInfo subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubClusterRegister Request."));
        }
        subClusterInfo = null;
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterIdNull, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Id information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterIdInvalid, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid SubCluster Id information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster State information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capabilityNull);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capabilityEmpty);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testValidateSubClusterRegisterRequestTimestamp() {
        SubClusterRegisterRequest request;
        SubClusterInfo subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeatNegative, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid timestamp information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTimeNegative, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid timestamp information."));
        }
    }

    @Test
    public void testValidateSubClusterRegisterRequestAddress() {
        SubClusterRegisterRequest request;
        SubClusterInfo subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)addressNull, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)addressEmpty, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)addressNull, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)addressEmpty, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)addressNull, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)addressEmpty, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)addressNull, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)addressEmpty, (long)lastHeartBeat, (SubClusterState)stateNew, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Endpoint information."));
        }
    }

    @Test
    public void testValidateSubClusterRegisterRequestAddressInvalid() {
        SubClusterRegisterRequest request;
        SubClusterInfo subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)addressWrong, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)addressWrong, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)addressWrong, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)addressWrong, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)addressWrongPort, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)addressWrongPort, (String)rmAdminServiceAddress, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)addressWrongPort, (String)rmWebServiceAddress, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
        subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMServiceAddress, (String)clientRMServiceAddress, (String)rmAdminServiceAddress, (String)addressWrongPort, (long)lastHeartBeat, (SubClusterState)stateNull, (long)lastStartTime, (String)capability);
        try {
            request = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo);
            FederationMembershipStateStoreInputValidator.validate((SubClusterRegisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("valid host:port authority:"));
        }
    }

    @Test
    public void testValidateSubClusterDeregisterRequest() {
        SubClusterDeregisterRequest request;
        try {
            request = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)stateLost);
            FederationMembershipStateStoreInputValidator.validate((SubClusterDeregisterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationMembershipStateStoreInputValidator.validate((SubClusterDeregisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubClusterDeregister Request."));
        }
        try {
            request = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterIdNull, (SubClusterState)stateLost);
            FederationMembershipStateStoreInputValidator.validate((SubClusterDeregisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Id information."));
        }
        try {
            request = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterIdInvalid, (SubClusterState)stateLost);
            FederationMembershipStateStoreInputValidator.validate((SubClusterDeregisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid SubCluster Id information."));
        }
        try {
            request = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)stateNull);
            FederationMembershipStateStoreInputValidator.validate((SubClusterDeregisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster State information."));
        }
        try {
            request = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)stateNew);
            FederationMembershipStateStoreInputValidator.validate((SubClusterDeregisterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid non-final state: "));
        }
    }

    @Test
    public void testSubClusterHeartbeatRequest() {
        SubClusterHeartbeatRequest request;
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (long)lastHeartBeat, (SubClusterState)stateLost, (String)capability);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubClusterHeartbeat Request."));
        }
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterIdNull, (long)lastHeartBeat, (SubClusterState)stateLost, (String)capability);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Id information."));
        }
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterIdInvalid, (long)lastHeartBeat, (SubClusterState)stateLost, (String)capability);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid SubCluster Id information."));
        }
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (long)lastHeartBeat, (SubClusterState)stateNull, (String)capability);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster State information."));
        }
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (long)lastHeartBeatNegative, (SubClusterState)stateLost, (String)capability);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid timestamp information."));
        }
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (long)lastHeartBeat, (SubClusterState)stateLost, (String)capabilityNull);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid capability information."));
        }
        try {
            request = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (long)lastHeartBeat, (SubClusterState)stateLost, (String)capabilityEmpty);
            FederationMembershipStateStoreInputValidator.validate((SubClusterHeartbeatRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid capability information."));
        }
    }

    @Test
    public void testGetSubClusterInfoRequest() {
        GetSubClusterInfoRequest request;
        try {
            request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
            FederationMembershipStateStoreInputValidator.validate((GetSubClusterInfoRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationMembershipStateStoreInputValidator.validate((GetSubClusterInfoRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing GetSubClusterInfo Request."));
        }
        try {
            request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterIdNull);
            FederationMembershipStateStoreInputValidator.validate((GetSubClusterInfoRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Id information."));
        }
        try {
            request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterIdInvalid);
            FederationMembershipStateStoreInputValidator.validate((GetSubClusterInfoRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid SubCluster Id information."));
        }
    }

    @Test
    public void testAddApplicationHomeSubClusterRequest() {
        AddApplicationHomeSubClusterRequest request;
        ApplicationHomeSubCluster applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        try {
            request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((AddApplicationHomeSubClusterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationApplicationHomeSubClusterStoreInputValidator.validate((AddApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing AddApplicationHomeSubCluster Request."));
        }
        applicationHomeSubCluster = null;
        try {
            request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((AddApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing ApplicationHomeSubCluster Info."));
        }
        applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterIdNull);
        try {
            request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((AddApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Id information."));
        }
        applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterIdInvalid);
        try {
            request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((AddApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid SubCluster Id information."));
        }
        applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appIdNull, (SubClusterId)subClusterId);
        try {
            request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((AddApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Application Id."));
        }
    }

    @Test
    public void testUpdateApplicationHomeSubClusterRequest() {
        UpdateApplicationHomeSubClusterRequest request;
        ApplicationHomeSubCluster applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        try {
            request = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((UpdateApplicationHomeSubClusterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationApplicationHomeSubClusterStoreInputValidator.validate((UpdateApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing UpdateApplicationHomeSubCluster Request."));
        }
        applicationHomeSubCluster = null;
        try {
            request = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((UpdateApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing ApplicationHomeSubCluster Info."));
        }
        applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterIdNull);
        try {
            request = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((UpdateApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubCluster Id information."));
        }
        applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterIdInvalid);
        try {
            request = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((UpdateApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            LOG.info(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid SubCluster Id information."));
        }
        applicationHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appIdNull, (SubClusterId)subClusterId);
        try {
            request = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)applicationHomeSubCluster);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((UpdateApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Application Id."));
        }
    }

    @Test
    public void testGetApplicationHomeSubClusterRequest() {
        GetApplicationHomeSubClusterRequest request;
        try {
            request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((GetApplicationHomeSubClusterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationApplicationHomeSubClusterStoreInputValidator.validate((GetApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing GetApplicationHomeSubCluster Request."));
        }
        try {
            request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appIdNull);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((GetApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Application Id."));
        }
    }

    @Test
    public void testDeleteApplicationHomeSubClusterRequestNull() {
        DeleteApplicationHomeSubClusterRequest request;
        try {
            request = DeleteApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((DeleteApplicationHomeSubClusterRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationApplicationHomeSubClusterStoreInputValidator.validate((DeleteApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing DeleteApplicationHomeSubCluster Request."));
        }
        try {
            request = DeleteApplicationHomeSubClusterRequest.newInstance((ApplicationId)appIdNull);
            FederationApplicationHomeSubClusterStoreInputValidator.validate((DeleteApplicationHomeSubClusterRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Application Id."));
        }
    }

    @Test
    public void testGetSubClusterPolicyConfigurationRequest() {
        GetSubClusterPolicyConfigurationRequest request;
        try {
            request = GetSubClusterPolicyConfigurationRequest.newInstance((String)queue);
            FederationPolicyStoreInputValidator.validate((GetSubClusterPolicyConfigurationRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            request = null;
            FederationPolicyStoreInputValidator.validate((GetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing GetSubClusterPolicyConfiguration Request."));
        }
        try {
            request = GetSubClusterPolicyConfigurationRequest.newInstance((String)queueNull);
            FederationPolicyStoreInputValidator.validate((GetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Queue."));
        }
        try {
            request = GetSubClusterPolicyConfigurationRequest.newInstance((String)queueEmpty);
            FederationPolicyStoreInputValidator.validate((GetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Queue."));
        }
    }

    @Test
    public void testSetSubClusterPolicyConfigurationRequest() {
        SetSubClusterPolicyConfigurationRequest request;
        SubClusterPolicyConfiguration policy;
        try {
            policy = SubClusterPolicyConfiguration.newInstance((String)queue, (String)type, (ByteBuffer)params);
            request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)policy);
            FederationPolicyStoreInputValidator.validate((SetSubClusterPolicyConfigurationRequest)request);
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            SetSubClusterPolicyConfigurationRequest request2 = null;
            FederationPolicyStoreInputValidator.validate(request2);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SetSubClusterPolicyConfiguration Request."));
        }
        try {
            policy = null;
            request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)policy);
            FederationPolicyStoreInputValidator.validate((SetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing SubClusterPolicyConfiguration."));
        }
        try {
            policy = SubClusterPolicyConfiguration.newInstance((String)queueNull, (String)type, (ByteBuffer)params);
            request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)policy);
            FederationPolicyStoreInputValidator.validate((SetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Queue."));
        }
        try {
            policy = SubClusterPolicyConfiguration.newInstance((String)queueEmpty, (String)type, (ByteBuffer)params);
            request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)policy);
            FederationPolicyStoreInputValidator.validate((SetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Queue."));
        }
        try {
            policy = SubClusterPolicyConfiguration.newInstance((String)queue, (String)typeNull, (ByteBuffer)params);
            request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)policy);
            FederationPolicyStoreInputValidator.validate((SetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Policy Type."));
        }
        try {
            policy = SubClusterPolicyConfiguration.newInstance((String)queue, (String)typeEmpty, (ByteBuffer)params);
            request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)policy);
            FederationPolicyStoreInputValidator.validate((SetSubClusterPolicyConfigurationRequest)request);
            Assert.fail();
        }
        catch (FederationStateStoreInvalidInputException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing Policy Type."));
        }
    }
}

