/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.FederationStateStoreBaseTest;
import org.apache.hadoop.yarn.server.federation.store.impl.HSQLDBFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.SQLFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.metrics.FederationStateStoreClientMetrics;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.sql.DatabaseProduct;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationQueryRunner;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationSQLOutParameter;
import org.apache.hadoop.yarn.server.federation.store.sql.ResultSetHandler;
import org.apache.hadoop.yarn.server.federation.store.sql.RouterMasterKeyHandler;
import org.apache.hadoop.yarn.server.federation.store.sql.RouterStoreTokenHandler;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationStateStoreUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSQLFederationStateStore
extends FederationStateStoreBaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(TestSQLFederationStateStore.class);
    private static final String HSQLDB_DRIVER = "org.hsqldb.jdbc.JDBCDataSource";
    private static final String DATABASE_URL = "jdbc:hsqldb:mem:state";
    private static final String DATABASE_USERNAME = "SA";
    private static final String DATABASE_PASSWORD = "";
    private SQLFederationStateStore sqlFederationStateStore = null;

    @Override
    protected FederationStateStore createStateStore() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.federation.state-store.sql.jdbc-class", HSQLDB_DRIVER);
        conf.set("yarn.federation.state-store.sql.username", DATABASE_USERNAME);
        conf.set("yarn.federation.state-store.sql.password", DATABASE_PASSWORD);
        conf.set("yarn.federation.state-store.sql.url", DATABASE_URL + System.currentTimeMillis());
        conf.setInt("yarn.federation.state-store.max-applications", 10);
        conf.setInt("yarn.federation.state-store.sql.max-connections", 10);
        super.setConf((Configuration)conf);
        this.sqlFederationStateStore = new HSQLDBFederationStateStore();
        return this.sqlFederationStateStore;
    }

    @Test
    public void testSqlConnectionsCreatedCount() throws YarnException {
        FederationStateStore stateStore = this.getStateStore();
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
        Assert.assertEquals((Object)subClusterInfo, (Object)this.querySubClusterInfo(subClusterId));
        this.addApplicationHomeSC(appId, subClusterId);
        Assert.assertEquals((Object)subClusterId, (Object)this.queryApplicationHomeSC(appId));
        Assert.assertEquals((long)1L, (long)FederationStateStoreClientMetrics.getNumConnections());
    }

    private ReservationHomeSC addReservationHomeSubCluster(String procedure, String reservationId, String subHomeClusterId) throws SQLException, YarnException {
        CallableStatement cstmt = this.sqlFederationStateStore.getCallableStatement(procedure);
        cstmt.setString("reservationId_IN", reservationId);
        cstmt.setString("homeSubCluster_IN", subHomeClusterId);
        cstmt.registerOutParameter("storedHomeSubCluster_OUT", 12);
        cstmt.registerOutParameter("rowCount_OUT", 4);
        cstmt.executeUpdate();
        String dbStoredHomeSubCluster = cstmt.getString("storedHomeSubCluster_OUT");
        int dbRowCount = cstmt.getInt("rowCount_OUT");
        FederationStateStoreUtils.returnToPool((Logger)LOG, (CallableStatement)cstmt);
        return new ReservationHomeSC(reservationId, dbStoredHomeSubCluster, dbRowCount);
    }

    private ReservationHomeSC getReservationHomeSubCluster(String procedure, String reservationId) throws SQLException, YarnException {
        CallableStatement cstmt = this.sqlFederationStateStore.getCallableStatement(procedure);
        cstmt.setString("reservationId_IN", reservationId.toString());
        cstmt.registerOutParameter("homeSubCluster_OUT", 12);
        cstmt.execute();
        String dBSubClusterHomeId = cstmt.getString("homeSubCluster_OUT");
        FederationStateStoreUtils.returnToPool((Logger)LOG, (CallableStatement)cstmt);
        return new ReservationHomeSC(reservationId, dBSubClusterHomeId, 0);
    }

    private List<ReservationHomeSC> getReservationsHomeSubCluster(String procedure) throws SQLException, IOException, YarnException {
        ArrayList<ReservationHomeSC> results = new ArrayList<ReservationHomeSC>();
        CallableStatement cstmt = this.sqlFederationStateStore.getCallableStatement(procedure);
        ResultSet rs = cstmt.executeQuery();
        while (rs.next()) {
            String dbReservationId = rs.getString("reservationId");
            String dbHomeSubCluster = rs.getString("homeSubCluster");
            results.add(new ReservationHomeSC(dbReservationId, dbHomeSubCluster, 0));
        }
        FederationStateStoreUtils.returnToPool((Logger)LOG, (CallableStatement)cstmt);
        return results;
    }

    private ReservationHomeSC updateReservationHomeSubCluster(String procedure, String reservationId, String subHomeClusterId) throws SQLException, IOException {
        CallableStatement cstmt = this.sqlFederationStateStore.getCallableStatement(procedure);
        cstmt.setString("reservationId_IN", reservationId);
        cstmt.setString("homeSubCluster_IN", subHomeClusterId);
        cstmt.registerOutParameter("rowCount_OUT", 4);
        cstmt.executeUpdate();
        int rowCount = cstmt.getInt("rowCount_OUT");
        return new ReservationHomeSC(reservationId, subHomeClusterId, rowCount);
    }

    private ReservationHomeSC deleteReservationHomeSubCluster(String procedure, String reservationId) throws SQLException {
        CallableStatement cstmt = this.sqlFederationStateStore.getCallableStatement(procedure);
        cstmt.setString("reservationId_IN", reservationId);
        cstmt.registerOutParameter("rowCount_OUT", 4);
        cstmt.executeUpdate();
        int rowCount = cstmt.getInt("rowCount_OUT");
        return new ReservationHomeSC(reservationId, "-", rowCount);
    }

    @Test
    public void testCheckAddReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        String subHomeClusterId = "SC-1";
        ReservationHomeSC resultHC = this.addReservationHomeSubCluster("{call sp_addReservationHomeSubCluster(?, ?, ?, ?)}", reservationId.toString(), subHomeClusterId);
        Assert.assertNotNull((Object)resultHC);
        Assert.assertEquals((Object)subHomeClusterId, (Object)resultHC.subHomeClusterId);
        Assert.assertEquals((long)1L, (long)resultHC.dbUpdateCount);
    }

    @Test
    public void testCheckGetReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        String subHomeClusterId = "SC-1";
        this.addReservationHomeSubCluster("{call sp_addReservationHomeSubCluster(?, ?, ?, ?)}", reservationId.toString(), subHomeClusterId);
        ReservationHomeSC resultHC = this.getReservationHomeSubCluster("{call sp_getReservationHomeSubCluster(?, ?)}", reservationId.toString());
        Assert.assertNotNull((Object)resultHC);
        Assert.assertEquals((Object)subHomeClusterId, (Object)resultHC.subHomeClusterId);
        Assert.assertEquals((Object)reservationId.toString(), (Object)resultHC.reservationId);
    }

    @Test
    public void testCheckGetReservationsHomeSubCluster() throws Exception {
        ReservationId reservationId1 = ReservationId.newInstance((long)Time.now(), (long)1L);
        String subHomeClusterId1 = "SC-1";
        this.addReservationHomeSubCluster("{call sp_addReservationHomeSubCluster(?, ?, ?, ?)}", reservationId1.toString(), subHomeClusterId1);
        ReservationId reservationId2 = ReservationId.newInstance((long)Time.now(), (long)2L);
        String subHomeClusterId2 = "SC-2";
        this.addReservationHomeSubCluster("{call sp_addReservationHomeSubCluster(?, ?, ?, ?)}", reservationId2.toString(), subHomeClusterId2);
        List<ReservationHomeSC> reservationHomeSubClusters = this.getReservationsHomeSubCluster("{call sp_getReservationsHomeSubCluster()}");
        Assert.assertNotNull(reservationHomeSubClusters);
        Assert.assertEquals((long)2L, (long)reservationHomeSubClusters.size());
        ReservationHomeSC resultHC1 = reservationHomeSubClusters.get(0);
        Assert.assertNotNull((Object)resultHC1);
        Assert.assertEquals((Object)reservationId1.toString(), (Object)resultHC1.reservationId);
        Assert.assertEquals((Object)subHomeClusterId1, (Object)resultHC1.subHomeClusterId);
        ReservationHomeSC resultHC2 = reservationHomeSubClusters.get(1);
        Assert.assertNotNull((Object)resultHC2);
        Assert.assertEquals((Object)reservationId2.toString(), (Object)resultHC2.reservationId);
        Assert.assertEquals((Object)subHomeClusterId2, (Object)resultHC2.subHomeClusterId);
    }

    @Test
    public void testCheckUpdateReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        String subHomeClusterId = "SC-1";
        this.addReservationHomeSubCluster("{call sp_addReservationHomeSubCluster(?, ?, ?, ?)}", reservationId.toString(), subHomeClusterId);
        ReservationHomeSC resultHC = this.getReservationHomeSubCluster("{call sp_getReservationHomeSubCluster(?, ?)}", reservationId.toString());
        Assert.assertNotNull((Object)resultHC);
        Assert.assertEquals((Object)subHomeClusterId, (Object)resultHC.subHomeClusterId);
        String newSubHomeClusterId = "SC-2";
        ReservationHomeSC reservationHomeSubCluster = this.updateReservationHomeSubCluster("{call sp_updateReservationHomeSubCluster(?, ?, ?)}", reservationId.toString(), newSubHomeClusterId);
        Assert.assertNotNull((Object)reservationHomeSubCluster);
        Assert.assertEquals((long)1L, (long)reservationHomeSubCluster.dbUpdateCount);
        ReservationHomeSC resultHC2 = this.getReservationHomeSubCluster("{call sp_getReservationHomeSubCluster(?, ?)}", reservationId.toString());
        Assert.assertNotNull((Object)resultHC2);
        Assert.assertEquals((Object)newSubHomeClusterId, (Object)resultHC2.subHomeClusterId);
    }

    @Test
    public void testCheckDeleteReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        String subHomeClusterId = "SC-1";
        this.addReservationHomeSubCluster("{call sp_addReservationHomeSubCluster(?, ?, ?, ?)}", reservationId.toString(), subHomeClusterId);
        ReservationHomeSC resultHC = this.deleteReservationHomeSubCluster("{call sp_deleteReservationHomeSubCluster(?, ?)}", reservationId.toString());
        Assert.assertNotNull((Object)resultHC);
        Assert.assertEquals((long)1L, (long)resultHC.dbUpdateCount);
        ReservationHomeSC resultHC1 = this.getReservationHomeSubCluster("{call sp_getReservationHomeSubCluster(?, ?)}", reservationId.toString());
        Assert.assertNotNull((Object)resultHC1);
        Assert.assertEquals(null, (Object)resultHC1.subHomeClusterId);
    }

    @Test
    public void testAddReservationHomeSubClusterAbnormalSituation() throws Exception {
        Connection conn = this.sqlFederationStateStore.getConn();
        conn.prepareStatement("DROP PROCEDURE sp_addReservationHomeSubCluster").execute();
        conn.prepareStatement("CREATE PROCEDURE sp_addReservationHomeSubCluster( IN reservationId_IN varchar(128), IN homeSubCluster_IN varchar(256), OUT storedHomeSubCluster_OUT varchar(256), OUT rowCount_OUT int) MODIFIES SQL DATA BEGIN ATOMIC INSERT INTO reservationsHomeSubCluster  (reservationId,homeSubCluster)  (SELECT reservationId_IN, homeSubCluster_IN FROM reservationsHomeSubCluster WHERE reservationId = reservationId_IN HAVING COUNT(*) = 0 ); SELECT homeSubCluster, 2 INTO storedHomeSubCluster_OUT, rowCount_OUT FROM reservationsHomeSubCluster WHERE reservationId = reservationId_IN; END").execute();
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId);
        AddReservationHomeSubClusterRequest request = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        String errorMsg = String.format("Wrong behavior during the insertion of subCluster %s according to reservation %s. The database expects to insert 1 record, but the number of inserted changes is greater than 1, please check the records of the database.", subClusterId, reservationId);
        LambdaTestUtils.intercept(YarnException.class, (String)errorMsg, () -> this.sqlFederationStateStore.addReservationHomeSubCluster(request));
    }

    @Test
    public void testUpdateReservationHomeSubClusterAbnormalSituation() throws Exception {
        Connection conn = this.sqlFederationStateStore.getConn();
        conn.prepareStatement("DROP PROCEDURE sp_updateReservationHomeSubCluster").execute();
        conn.prepareStatement("CREATE PROCEDURE sp_updateReservationHomeSubCluster( IN reservationId_IN varchar(128), IN homeSubCluster_IN varchar(256), OUT rowCount_OUT int) MODIFIES SQL DATA BEGIN ATOMIC UPDATE reservationsHomeSubCluster SET homeSubCluster = homeSubCluster_IN WHERE reservationId = reservationId_IN; SET rowCount_OUT = 2; END").execute();
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC");
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId1);
        AddReservationHomeSubClusterRequest addRequest = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        this.sqlFederationStateStore.addReservationHomeSubCluster(addRequest);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ReservationHomeSubCluster reservationHomeSubCluster2 = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId2);
        UpdateReservationHomeSubClusterRequest updateRequest = UpdateReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster2);
        String errorMsg = String.format("Wrong behavior during update the subCluster %s according to reservation %s. The database is expected to update 1 record, but the number of database update records is greater than 1, the records of the database should be checked.", subClusterId2, reservationId);
        LambdaTestUtils.intercept(YarnException.class, (String)errorMsg, () -> this.sqlFederationStateStore.updateReservationHomeSubCluster(updateRequest));
    }

    @Test
    public void testDeleteReservationHomeSubClusterAbnormalSituation() throws Exception {
        Connection conn = this.sqlFederationStateStore.getConn();
        conn.prepareStatement("DROP PROCEDURE sp_deleteReservationHomeSubCluster").execute();
        conn.prepareStatement("CREATE PROCEDURE sp_deleteReservationHomeSubCluster( IN reservationId_IN varchar(128), OUT rowCount_OUT int) MODIFIES SQL DATA BEGIN ATOMIC DELETE FROM reservationsHomeSubCluster WHERE reservationId = reservationId_IN; SET rowCount_OUT = 2; END").execute();
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC");
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId1);
        AddReservationHomeSubClusterRequest addRequest = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        this.sqlFederationStateStore.addReservationHomeSubCluster(addRequest);
        DeleteReservationHomeSubClusterRequest delRequest = DeleteReservationHomeSubClusterRequest.newInstance((ReservationId)reservationId);
        String errorMsg = String.format("Wrong behavior during deleting the reservation %s. The database is expected to delete 1 record, but the number of deleted records returned by the database is greater than 1, indicating that a duplicate reservationId occurred during the deletion process.", reservationId);
        LambdaTestUtils.intercept(YarnException.class, (String)errorMsg, () -> this.sqlFederationStateStore.deleteReservationHomeSubCluster(delRequest));
    }

    @Override
    protected void checkRouterMasterKey(DelegationKey delegationKey, RouterMasterKey routerMasterKey) throws YarnException, IOException, SQLException {
        RouterMasterKeyRequest routerMasterKeyRequest = RouterMasterKeyRequest.newInstance((RouterMasterKey)routerMasterKey);
        Connection conn = this.sqlFederationStateStore.getConn();
        int paramKeyId = delegationKey.getKeyId();
        FederationQueryRunner runner = new FederationQueryRunner();
        FederationSQLOutParameter masterKeyOUT = new FederationSQLOutParameter("masterKey_OUT", 12, String.class);
        RouterMasterKey sqlRouterMasterKey = (RouterMasterKey)runner.execute(conn, "{call sp_getMasterKey(?, ?)}", (ResultSetHandler)new RouterMasterKeyHandler(), new Object[]{paramKeyId, masterKeyOUT});
        RouterMasterKeyResponse response = this.getStateStore().getMasterKeyByDelegationKey(routerMasterKeyRequest);
        Assert.assertNotNull((Object)response);
        RouterMasterKey respRouterMasterKey = response.getRouterMasterKey();
        Assert.assertEquals((Object)routerMasterKey, (Object)respRouterMasterKey);
        Assert.assertEquals((Object)routerMasterKey, (Object)sqlRouterMasterKey);
        Assert.assertEquals((Object)sqlRouterMasterKey, (Object)respRouterMasterKey);
    }

    @Override
    protected void checkRouterStoreToken(RMDelegationTokenIdentifier identifier, RouterStoreToken token) throws YarnException, IOException, SQLException {
        int sequenceNum = identifier.getSequenceNumber();
        Connection conn = this.sqlFederationStateStore.getConn();
        FederationQueryRunner runner = new FederationQueryRunner();
        FederationSQLOutParameter tokenIdentOUT = new FederationSQLOutParameter("tokenIdent_OUT", 12, String.class);
        FederationSQLOutParameter tokenOUT = new FederationSQLOutParameter("token_OUT", 12, String.class);
        FederationSQLOutParameter renewDateOUT = new FederationSQLOutParameter("renewDate_OUT", -5, Long.class);
        RouterStoreToken sqlRouterStoreToken = (RouterStoreToken)runner.execute(conn, "{call sp_getDelegationToken(?, ?, ?, ?)}", (ResultSetHandler)new RouterStoreTokenHandler(), new Object[]{sequenceNum, tokenIdentOUT, tokenOUT, renewDateOUT});
        Assert.assertEquals((Object)token, (Object)sqlRouterStoreToken);
    }

    @Test
    public void testCheckHSQLDB() throws SQLException {
        Connection conn = this.sqlFederationStateStore.getConn();
        DatabaseProduct.DbType dbType = DatabaseProduct.getDbType((Connection)conn);
        Assert.assertEquals((Object)DatabaseProduct.DbType.HSQLDB, (Object)dbType);
    }

    @Test
    public void testGetDbTypeNullConn() throws SQLException {
        DatabaseProduct.DbType dbType = DatabaseProduct.getDbType(null);
        Assert.assertEquals((Object)DatabaseProduct.DbType.UNDEFINED, (Object)dbType);
    }

    @Test
    public void testGetDBTypeEmptyConn() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.getDatabaseProductName()).thenReturn((Object)DATABASE_PASSWORD);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        DatabaseProduct.DbType dbType = DatabaseProduct.getDbType((Connection)connection);
        Assert.assertEquals((Object)DatabaseProduct.DbType.UNDEFINED, (Object)dbType);
    }

    @Test
    public void testCheckForHSQLDBUpdateSQL() throws SQLException {
        String sql = "select sequenceName, nextVal from sequenceTable";
        String hsqlDBSQL = DatabaseProduct.addForUpdateClause((DatabaseProduct.DbType)DatabaseProduct.DbType.HSQLDB, (String)sql);
        String expectUpdateSQL = "select sequenceName, nextVal from sequenceTable for update";
        Assert.assertEquals((Object)expectUpdateSQL, (Object)hsqlDBSQL);
    }

    @Test
    public void testCheckForSqlServerDBUpdateSQL() throws SQLException {
        String sql = "select sequenceName, nextVal from sequenceTable";
        String sqlServerDBSQL = DatabaseProduct.addForUpdateClause((DatabaseProduct.DbType)DatabaseProduct.DbType.SQLSERVER, (String)sql);
        String expectUpdateSQL = "select sequenceName, nextVal from sequenceTable with (updlock)";
        Assert.assertEquals((Object)expectUpdateSQL, (Object)sqlServerDBSQL);
    }

    @Test
    public void testCheckHikariDataSourceParam() throws SQLException {
        HikariDataSource dataSource = this.sqlFederationStateStore.getDataSource();
        long maxLifeTime = dataSource.getMaxLifetime();
        long idleTimeOut = dataSource.getIdleTimeout();
        long connTimeOut = dataSource.getConnectionTimeout();
        String poolName = dataSource.getPoolName();
        int minimumIdle = dataSource.getMinimumIdle();
        int maximumPoolSize = dataSource.getMaximumPoolSize();
        Assert.assertEquals((long)1800000L, (long)maxLifeTime);
        Assert.assertEquals((long)600000L, (long)idleTimeOut);
        Assert.assertEquals((long)10000L, (long)connTimeOut);
        Assert.assertEquals((Object)"YARN-Federation-DataBasePool", (Object)poolName);
        Assert.assertEquals((long)1L, (long)minimumIdle);
        Assert.assertEquals((long)10L, (long)maximumPoolSize);
    }

    class ReservationHomeSC {
        private String reservationId;
        private String subHomeClusterId;
        private int dbUpdateCount;

        ReservationHomeSC(String rId, String subHomeSCId, int dbUpdateCount) {
            this.reservationId = rId;
            this.subHomeClusterId = subHomeSCId;
            this.dbUpdateCount = dbUpdateCount;
        }
    }
}

