/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.federation.store.impl.HSQLDBFederationStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerFederationStateStore
extends HSQLDBFederationStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(SQLServerFederationStateStore.class);

    @Override
    public void init(Configuration conf) {
        try {
            super.initConnection(conf);
            this.extractCreateTableSQL("SQLServer", "CREATE TABLE .*\\n(.*,\\n){1,5}.*(\\n.*){1,15}\\)");
            List<String> tables = this.getTables();
            if (tables != null && !tables.isEmpty()) {
                tables = tables.stream().map(table -> {
                    String newTable = table.replace("COLLATE Latin1_General_100_BIN2", "").replace("DEFAULT GETUTCDATE()", "").replace("[dbo].", "").replace("[", "").replace("]", "");
                    return newTable;
                }).collect(Collectors.toList());
                this.setTables(tables);
            }
            LOG.info("SqlServer - tables = {}.", (Object)tables.size());
        }
        catch (IOException e) {
            LOG.error("ERROR: failed to init HSQLDB {}.", (Object)e.getMessage());
        }
    }
}

