/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import java.util.HashMap;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.HomeAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.manager.BasePolicyManagerTest;
import org.apache.hadoop.yarn.server.federation.policies.manager.WeightedHomePolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.WeightedRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWeightedHomePolicyManager
extends BasePolicyManagerTest {
    private WeightedPolicyInfo policyInfo;

    @Before
    public void setup() {
        WeightedHomePolicyManager whpm = new WeightedHomePolicyManager();
        whpm.setQueue("queue1");
        SubClusterId sc1 = SubClusterId.newInstance((String)"sc1");
        this.policyInfo = new WeightedPolicyInfo();
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        routerWeights.put(new SubClusterIdInfo(sc1), Float.valueOf(0.2f));
        this.policyInfo.setRouterPolicyWeights(routerWeights);
        whpm.setWeightedPolicyInfo(this.policyInfo);
        this.wfp = whpm;
        this.expectedPolicyManager = WeightedHomePolicyManager.class;
        this.expectedAMRMProxyPolicy = HomeAMRMProxyPolicy.class;
        this.expectedRouterPolicy = WeightedRandomRouterPolicy.class;
    }

    @Test
    public void testPolicyInfoSetCorrectly() throws Exception {
        TestWeightedHomePolicyManager.serializeAndDeserializePolicyManager(this.wfp, this.expectedPolicyManager, this.expectedAMRMProxyPolicy, this.expectedRouterPolicy);
        Assert.assertEquals((Object)((WeightedHomePolicyManager)this.wfp).getWeightedPolicyInfo(), (Object)this.policyInfo);
    }
}

