/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import java.nio.ByteBuffer;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.BasePBImplRecordsTest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.AddApplicationHomeSubClusterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.AddApplicationHomeSubClusterResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.ApplicationHomeSubClusterPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.DeleteApplicationHomeSubClusterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.DeleteApplicationHomeSubClusterResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetApplicationHomeSubClusterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetApplicationHomeSubClusterResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetApplicationsHomeSubClusterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetApplicationsHomeSubClusterResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetReservationHomeSubClusterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClusterInfoRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClusterInfoResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClusterPoliciesConfigurationsRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClusterPoliciesConfigurationsResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClusterPolicyConfigurationRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClusterPolicyConfigurationResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClustersInfoRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.GetSubClustersInfoResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.RouterMasterKeyPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.RouterMasterKeyRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.RouterMasterKeyResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.RouterRMTokenRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.RouterRMTokenResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.RouterStoreTokenPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SetSubClusterPolicyConfigurationRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SetSubClusterPolicyConfigurationResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterDeregisterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterDeregisterResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterHeartbeatRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterHeartbeatResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterIdPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterInfoPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterRegisterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterRegisterResponsePBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.UpdateApplicationHomeSubClusterRequestPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.UpdateApplicationHomeSubClusterResponsePBImpl;
import org.apache.hadoop.yarn.server.records.Version;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFederationProtocolRecords
extends BasePBImplRecordsTest {
    @BeforeClass
    public static void setup() throws Exception {
        TestFederationProtocolRecords.generateByNewInstance(ApplicationId.class);
        TestFederationProtocolRecords.generateByNewInstance(Version.class);
        TestFederationProtocolRecords.generateByNewInstance(SubClusterId.class);
        TestFederationProtocolRecords.generateByNewInstance(SubClusterInfo.class);
        TestFederationProtocolRecords.generateByNewInstance(Priority.class);
        TestFederationProtocolRecords.generateByNewInstance(URL.class);
        TestFederationProtocolRecords.generateByNewInstance(Resource.class);
        TestFederationProtocolRecords.generateByNewInstance(ContainerRetryContext.class);
        TestFederationProtocolRecords.generateByNewInstance(LocalResource.class);
        TestFederationProtocolRecords.generateByNewInstance(ContainerLaunchContext.class);
        TestFederationProtocolRecords.generateByNewInstance(LogAggregationContext.class);
        TestFederationProtocolRecords.generateByNewInstance(ApplicationSubmissionContext.class);
        TestFederationProtocolRecords.generateByNewInstance(ApplicationHomeSubCluster.class);
        TestFederationProtocolRecords.generateByNewInstance(SubClusterPolicyConfiguration.class);
        TestFederationProtocolRecords.generateByNewInstance(RouterMasterKey.class);
        TestFederationProtocolRecords.generateByNewInstance(YARNDelegationTokenIdentifier.class);
        TestFederationProtocolRecords.generateByNewInstance(RouterStoreToken.class);
        TestFederationProtocolRecords.generateByNewInstance(ReservationId.class);
    }

    @Test
    public void testSubClusterId() throws Exception {
        this.validatePBImplRecord(SubClusterIdPBImpl.class, YarnServerFederationProtos.SubClusterIdProto.class);
    }

    @Test
    public void testSubClusterInfo() throws Exception {
        this.validatePBImplRecord(SubClusterInfoPBImpl.class, YarnServerFederationProtos.SubClusterInfoProto.class);
    }

    @Test
    public void testSubClusterRegisterRequest() throws Exception {
        this.validatePBImplRecord(SubClusterRegisterRequestPBImpl.class, YarnServerFederationProtos.SubClusterRegisterRequestProto.class);
    }

    @Test
    public void testSubClusterRegisterResponse() throws Exception {
        this.validatePBImplRecord(SubClusterRegisterResponsePBImpl.class, YarnServerFederationProtos.SubClusterRegisterResponseProto.class);
    }

    @Test
    public void testSubClusterDeregisterRequest() throws Exception {
        this.validatePBImplRecord(SubClusterDeregisterRequestPBImpl.class, YarnServerFederationProtos.SubClusterDeregisterRequestProto.class);
    }

    @Test
    public void testSubClusterDeregisterResponse() throws Exception {
        this.validatePBImplRecord(SubClusterDeregisterResponsePBImpl.class, YarnServerFederationProtos.SubClusterDeregisterResponseProto.class);
    }

    @Test
    public void testSubClusterHeartbeatRequest() throws Exception {
        this.validatePBImplRecord(SubClusterHeartbeatRequestPBImpl.class, YarnServerFederationProtos.SubClusterHeartbeatRequestProto.class);
    }

    @Test
    public void testSubClusterHeartbeatResponse() throws Exception {
        this.validatePBImplRecord(SubClusterHeartbeatResponsePBImpl.class, YarnServerFederationProtos.SubClusterHeartbeatResponseProto.class);
    }

    @Test
    public void testGetSubClusterRequest() throws Exception {
        this.validatePBImplRecord(GetSubClusterInfoRequestPBImpl.class, YarnServerFederationProtos.GetSubClusterInfoRequestProto.class);
    }

    @Test
    public void testGetSubClusterResponse() throws Exception {
        this.validatePBImplRecord(GetSubClusterInfoResponsePBImpl.class, YarnServerFederationProtos.GetSubClusterInfoResponseProto.class);
    }

    @Test
    public void testGetSubClustersInfoRequest() throws Exception {
        this.validatePBImplRecord(GetSubClustersInfoRequestPBImpl.class, YarnServerFederationProtos.GetSubClustersInfoRequestProto.class);
    }

    @Test
    public void testGetSubClustersInfoResponse() throws Exception {
        this.validatePBImplRecord(GetSubClustersInfoResponsePBImpl.class, YarnServerFederationProtos.GetSubClustersInfoResponseProto.class);
    }

    @Test
    public void testAddApplicationHomeSubClusterRequest() throws Exception {
        this.validatePBImplRecord(AddApplicationHomeSubClusterRequestPBImpl.class, YarnServerFederationProtos.AddApplicationHomeSubClusterRequestProto.class);
    }

    @Test
    public void testAddApplicationHomeSubClusterResponse() throws Exception {
        this.validatePBImplRecord(AddApplicationHomeSubClusterResponsePBImpl.class, YarnServerFederationProtos.AddApplicationHomeSubClusterResponseProto.class);
    }

    @Test
    public void testUpdateApplicationHomeSubClusterRequest() throws Exception {
        this.validatePBImplRecord(UpdateApplicationHomeSubClusterRequestPBImpl.class, YarnServerFederationProtos.UpdateApplicationHomeSubClusterRequestProto.class);
    }

    @Test
    public void testUpdateApplicationHomeSubClusterResponse() throws Exception {
        this.validatePBImplRecord(UpdateApplicationHomeSubClusterResponsePBImpl.class, YarnServerFederationProtos.UpdateApplicationHomeSubClusterResponseProto.class);
    }

    @Test
    public void testGetApplicationHomeSubClusterRequest() throws Exception {
        this.validatePBImplRecord(GetApplicationHomeSubClusterRequestPBImpl.class, YarnServerFederationProtos.GetApplicationHomeSubClusterRequestProto.class);
    }

    @Test
    public void testGetApplicationHomeSubClusterResponse() throws Exception {
        this.validatePBImplRecord(GetApplicationHomeSubClusterResponsePBImpl.class, YarnServerFederationProtos.GetApplicationHomeSubClusterResponseProto.class);
    }

    @Test
    public void testGetApplicationsHomeSubClusterRequest() throws Exception {
        this.validatePBImplRecord(GetApplicationsHomeSubClusterRequestPBImpl.class, YarnServerFederationProtos.GetApplicationsHomeSubClusterRequestProto.class);
    }

    @Test
    public void testGetApplicationsHomeSubClusterResponse() throws Exception {
        this.validatePBImplRecord(GetApplicationsHomeSubClusterResponsePBImpl.class, YarnServerFederationProtos.GetApplicationsHomeSubClusterResponseProto.class);
    }

    @Test
    public void testDeleteApplicationHomeSubClusterRequest() throws Exception {
        this.validatePBImplRecord(DeleteApplicationHomeSubClusterRequestPBImpl.class, YarnServerFederationProtos.DeleteApplicationHomeSubClusterRequestProto.class);
    }

    @Test
    public void testDeleteApplicationHomeSubClusterResponse() throws Exception {
        this.validatePBImplRecord(DeleteApplicationHomeSubClusterResponsePBImpl.class, YarnServerFederationProtos.DeleteApplicationHomeSubClusterResponseProto.class);
    }

    @Test
    public void testGetSubClusterPolicyConfigurationRequest() throws Exception {
        this.validatePBImplRecord(GetSubClusterPolicyConfigurationRequestPBImpl.class, YarnServerFederationProtos.GetSubClusterPolicyConfigurationRequestProto.class);
    }

    @Test
    public void testGetSubClusterPolicyConfigurationResponse() throws Exception {
        this.validatePBImplRecord(GetSubClusterPolicyConfigurationResponsePBImpl.class, YarnServerFederationProtos.GetSubClusterPolicyConfigurationResponseProto.class);
    }

    @Test
    public void testSetSubClusterPolicyConfigurationRequest() throws Exception {
        this.validatePBImplRecord(SetSubClusterPolicyConfigurationRequestPBImpl.class, YarnServerFederationProtos.SetSubClusterPolicyConfigurationRequestProto.class);
    }

    @Test
    public void testSetSubClusterPolicyConfigurationResponse() throws Exception {
        this.validatePBImplRecord(SetSubClusterPolicyConfigurationResponsePBImpl.class, YarnServerFederationProtos.SetSubClusterPolicyConfigurationResponseProto.class);
    }

    @Test
    public void testGetSubClusterPoliciesConfigurationsRequest() throws Exception {
        this.validatePBImplRecord(GetSubClusterPoliciesConfigurationsRequestPBImpl.class, YarnServerFederationProtos.GetSubClusterPoliciesConfigurationsRequestProto.class);
    }

    @Test
    public void testGetSubClusterPoliciesConfigurationsResponse() throws Exception {
        this.validatePBImplRecord(GetSubClusterPoliciesConfigurationsResponsePBImpl.class, YarnServerFederationProtos.GetSubClusterPoliciesConfigurationsResponseProto.class);
    }

    @Test
    public void testRouterMasterKey() throws Exception {
        this.validatePBImplRecord(RouterMasterKeyPBImpl.class, YarnServerFederationProtos.RouterMasterKeyProto.class);
    }

    @Test
    public void testRouterMasterKeyRequest() throws Exception {
        this.validatePBImplRecord(RouterMasterKeyRequestPBImpl.class, YarnServerFederationProtos.RouterMasterKeyRequestProto.class);
    }

    @Test
    public void testRouterMasterKeyResponse() throws Exception {
        this.validatePBImplRecord(RouterMasterKeyResponsePBImpl.class, YarnServerFederationProtos.RouterMasterKeyResponseProto.class);
    }

    @Test
    public void testRouterStoreToken() throws Exception {
        this.validatePBImplRecord(RouterStoreTokenPBImpl.class, YarnServerFederationProtos.RouterStoreTokenProto.class);
    }

    @Test
    public void testRouterRMTokenRequest() throws Exception {
        this.validatePBImplRecord(RouterRMTokenRequestPBImpl.class, YarnServerFederationProtos.RouterRMTokenRequestProto.class);
    }

    @Test
    public void testRouterRMTokenResponse() throws Exception {
        this.validatePBImplRecord(RouterRMTokenResponsePBImpl.class, YarnServerFederationProtos.RouterRMTokenResponseProto.class);
    }

    @Test
    public void testApplicationHomeSubCluster() throws Exception {
        this.validatePBImplRecord(ApplicationHomeSubClusterPBImpl.class, YarnServerFederationProtos.ApplicationHomeSubClusterProto.class);
    }

    @Test
    public void testGetReservationHomeSubClusterRequest() throws Exception {
        this.validatePBImplRecord(GetReservationHomeSubClusterRequestPBImpl.class, YarnServerFederationProtos.GetReservationHomeSubClusterRequestProto.class);
    }

    @Test
    public void testValidateApplicationHomeSubClusterEqual() throws Exception {
        long now = Time.now();
        ApplicationId appId1 = ApplicationId.newInstance((long)now, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC-1");
        ApplicationHomeSubCluster applicationHomeSubCluster1 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId1, (SubClusterId)subClusterId1);
        ApplicationId appId2 = ApplicationId.newInstance((long)now, (int)1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC-1");
        ApplicationHomeSubCluster applicationHomeSubCluster2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (SubClusterId)subClusterId2);
        Assert.assertEquals((Object)applicationHomeSubCluster1, (Object)applicationHomeSubCluster2);
    }

    @Test
    public void testValidateReservationHomeSubClusterEqual() throws Exception {
        long now = Time.now();
        ReservationId reservationId1 = ReservationId.newInstance((long)now, (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC-1");
        ReservationHomeSubCluster reservationHomeSubCluster1 = ReservationHomeSubCluster.newInstance((ReservationId)reservationId1, (SubClusterId)subClusterId1);
        ReservationId reservationId2 = ReservationId.newInstance((long)now, (long)1L);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC-1");
        ReservationHomeSubCluster reservationHomeSubCluster2 = ReservationHomeSubCluster.newInstance((ReservationId)reservationId2, (SubClusterId)subClusterId2);
        Assert.assertEquals((Object)reservationHomeSubCluster1, (Object)reservationHomeSubCluster2);
    }

    @Test
    public void testSubClusterIdEqual() throws Exception {
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC-1");
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC-1");
        Assert.assertEquals((Object)subClusterId1, (Object)subClusterId2);
    }

    @Test
    public void testSubClusterIdInfoEqual() throws Exception {
        SubClusterIdInfo subClusterIdInfo1 = new SubClusterIdInfo("SC-1");
        SubClusterIdInfo subClusterIdInfo2 = new SubClusterIdInfo("SC-1");
        Assert.assertEquals((Object)subClusterIdInfo1, (Object)subClusterIdInfo2);
    }

    @Test
    public void testSubClusterPolicyConfigurationEqual() throws Exception {
        String queue1 = "queue1";
        WeightedPolicyInfo policyInfo1 = (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class);
        ByteBuffer buf1 = policyInfo1.toByteBuffer();
        SubClusterPolicyConfiguration configuration1 = SubClusterPolicyConfiguration.newInstance((String)queue1, (String)policyInfo1.getClass().getCanonicalName(), (ByteBuffer)buf1);
        String queue2 = "queue1";
        WeightedPolicyInfo policyInfo2 = (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class);
        ByteBuffer buf2 = policyInfo1.toByteBuffer();
        SubClusterPolicyConfiguration configuration2 = SubClusterPolicyConfiguration.newInstance((String)queue2, (String)policyInfo2.getClass().getCanonicalName(), (ByteBuffer)buf2);
        Assert.assertEquals((Object)configuration1, (Object)configuration2);
    }

    @Test
    public void testSubClusterInfoEqual() throws Exception {
        String scAmRMAddress = "5.6.7.8:5";
        String scClientRMAddress = "5.6.7.8:6";
        String scRmAdminAddress = "5.6.7.8:7";
        String scWebAppAddress = "127.0.0.1:8080";
        String capabilityJson = "-";
        SubClusterInfo sc1 = SubClusterInfo.newInstance((SubClusterId)SubClusterId.newInstance((String)"SC-1"), (String)scAmRMAddress, (String)scClientRMAddress, (String)scRmAdminAddress, (String)scWebAppAddress, (SubClusterState)SubClusterState.SC_RUNNING, (long)Time.now(), (String)capabilityJson);
        SubClusterInfo sc2 = SubClusterInfo.newInstance((SubClusterId)SubClusterId.newInstance((String)"SC-1"), (String)scAmRMAddress, (String)scClientRMAddress, (String)scRmAdminAddress, (String)scWebAppAddress, (SubClusterState)SubClusterState.SC_RUNNING, (long)Time.now(), (String)capabilityJson);
        Assert.assertEquals((Object)sc1, (Object)sc2);
    }

    @Test
    public void testApplicationHomeSubClusterEqual() throws Exception {
        ApplicationId appId1 = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC");
        ApplicationSubmissionContext context1 = ApplicationSubmissionContext.newInstance((ApplicationId)appId1, (String)"test", (String)"default", (Priority)Priority.newInstance((int)0), null, (boolean)true, (boolean)true, (int)2, (Resource)Resource.newInstance((int)10, (int)2), (String)"test");
        long createTime = Time.now();
        ApplicationHomeSubCluster ahsc1 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId1, (long)createTime, (SubClusterId)subClusterId1, (ApplicationSubmissionContext)context1);
        ApplicationId appId2 = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC");
        ApplicationSubmissionContext context2 = ApplicationSubmissionContext.newInstance((ApplicationId)appId1, (String)"test", (String)"default", (Priority)Priority.newInstance((int)0), null, (boolean)true, (boolean)true, (int)2, (Resource)Resource.newInstance((int)10, (int)2), (String)"test");
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (long)createTime, (SubClusterId)subClusterId2, (ApplicationSubmissionContext)context2);
        Assert.assertEquals((Object)ahsc1, (Object)ahsc2);
        ApplicationId appId3 = ApplicationId.newInstance((long)2L, (int)1);
        ApplicationSubmissionContext context3 = ApplicationSubmissionContext.newInstance((ApplicationId)appId3, (String)"test", (String)"default", (Priority)Priority.newInstance((int)0), null, (boolean)true, (boolean)true, (int)2, (Resource)Resource.newInstance((int)10, (int)2), (String)"test");
        ApplicationHomeSubCluster ahsc3 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId3, (long)createTime, (SubClusterId)subClusterId2, (ApplicationSubmissionContext)context3);
        Assert.assertNotEquals((Object)ahsc1, (Object)ahsc3);
        long createTime2 = Time.now() + 1000L;
        ApplicationHomeSubCluster ahsc4 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (long)createTime2, (SubClusterId)subClusterId1, (ApplicationSubmissionContext)context2);
        Assert.assertNotEquals((Object)ahsc1, (Object)ahsc4);
        ApplicationHomeSubCluster ahsc5 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (long)createTime2, (SubClusterId)subClusterId2, (ApplicationSubmissionContext)context3);
        Assert.assertNotEquals((Object)ahsc1, (Object)ahsc5);
    }
}

