/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.federation.policies.BaseFederationPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.BroadcastAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBroadcastAMRMProxyFederationPolicy
extends BaseFederationPoliciesTest {
    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new BroadcastAMRMProxyPolicy());
        this.setPolicyInfo((WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class));
        for (int i = 1; i <= 2; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            SubClusterInfo sci = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (SubClusterState)SubClusterState.SC_RUNNING, (long)System.currentTimeMillis(), (String)"something");
            this.getActiveSubclusters().put(sc.toId(), sci);
        }
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class), this.getActiveSubclusters());
    }

    @Test
    public void testSplitAllocateRequest() throws Exception {
        String[] hosts = new String[]{"host1", "host2"};
        List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
        Map response = ((FederationAMRMProxyPolicy)this.getPolicy()).splitResourceRequests(resourceRequests, new HashSet());
        Assert.assertTrue((response.size() == 2 ? 1 : 0) != 0);
        for (Map.Entry entry : response.entrySet()) {
            Assert.assertTrue((this.getActiveSubclusters().get(entry.getKey()) != null ? 1 : 0) != 0);
            for (ResourceRequest r : (List)entry.getValue()) {
                Assert.assertTrue((boolean)resourceRequests.contains(r));
            }
        }
        for (SubClusterId subClusterId : this.getActiveSubclusters().keySet()) {
            for (ResourceRequest r : (List)response.get(subClusterId)) {
                Assert.assertTrue((boolean)resourceRequests.contains(r));
            }
        }
    }

    @Test
    public void testNotifyOfResponseFromUnknownSubCluster() throws Exception {
        String[] hosts = new String[]{"host1", "host2"};
        List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
        Map response = ((FederationAMRMProxyPolicy)this.getPolicy()).splitResourceRequests(resourceRequests, new HashSet());
        ((FederationAMRMProxyPolicy)this.getPolicy()).notifyOfResponse(SubClusterId.newInstance((String)"sc3"), (AllocateResponse)Mockito.mock(AllocateResponse.class));
        ((FederationAMRMProxyPolicy)this.getPolicy()).notifyOfResponse(SubClusterId.newInstance((String)"sc1"), (AllocateResponse)Mockito.mock(AllocateResponse.class));
    }
}

