/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.cache.FederationJCache;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMDTSecretManagerState;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreTestUtil;
import org.ehcache.Cache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFederationStateStoreFacade {
    private final long clusterTs = System.currentTimeMillis();
    private final int numSubClusters = 3;
    private final int numApps = 5;
    private final int numQueues = 2;
    private Configuration conf = new Configuration();
    private FederationStateStore stateStore;
    private FederationStateStoreTestUtil stateStoreTestUtil;
    private FederationStateStoreFacade facade;
    private Boolean isCachingEnabled;

    @Parameterized.Parameters
    public static Collection<Boolean[]> getParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestFederationStateStoreFacade(Boolean isCachingEnabled) {
        if (!isCachingEnabled.booleanValue()) {
            this.conf.setInt("yarn.federation.cache-ttl.secs", 0);
        }
        this.isCachingEnabled = isCachingEnabled;
        this.facade = FederationStateStoreFacade.getInstance((Configuration)this.conf);
    }

    @Before
    public void setUp() throws IOException, YarnException {
        this.stateStore = new MemoryFederationStateStore();
        this.stateStore.init(this.conf);
        this.facade.reinitialize(this.stateStore, this.conf);
        this.stateStoreTestUtil = new FederationStateStoreTestUtil(this.stateStore);
        this.stateStoreTestUtil.registerSubClusters(3);
        this.stateStoreTestUtil.addAppsHomeSC(this.clusterTs, 5);
        this.stateStoreTestUtil.addPolicyConfigs(2);
    }

    @After
    public void tearDown() throws Exception {
        this.stateStore.close();
        this.stateStore = null;
    }

    @Test
    public void testGetSubCluster() throws YarnException {
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            Assert.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), (Object)this.facade.getSubCluster(subClusterId));
        }
    }

    @Test
    public void testInvalidGetSubCluster() throws YarnException {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"dummy");
        Assert.assertNull((Object)this.facade.getSubCluster(subClusterId));
    }

    @Test
    public void testGetSubClusterFlushCache() throws YarnException {
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            Assert.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), (Object)this.facade.getSubCluster(subClusterId, true));
        }
    }

    @Test
    public void testGetSubClusters() throws YarnException {
        Map subClusters = this.facade.getSubClusters(false);
        for (SubClusterId subClusterId : subClusters.keySet()) {
            Assert.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), subClusters.get(subClusterId));
        }
    }

    @Test
    public void testGetPolicyConfiguration() throws YarnException {
        for (int i = 0; i < 2; ++i) {
            String queue = "queue-" + i;
            Assert.assertEquals((Object)this.stateStoreTestUtil.queryPolicyConfiguration(queue), (Object)this.facade.getPolicyConfiguration(queue));
        }
    }

    @Test
    public void testSubClustersCache() throws YarnException {
        Map allClusters = this.facade.getSubClusters(false);
        Assert.assertEquals((long)3L, (long)allClusters.size());
        SubClusterId clusterId = (SubClusterId)new ArrayList(allClusters.keySet()).get(0);
        this.stateStoreTestUtil.deRegisterSubCluster(clusterId);
        Map activeClusters = this.facade.getSubClusters(true);
        Assert.assertEquals((long)2L, (long)activeClusters.size());
        allClusters = this.facade.getSubClusters(false);
        Assert.assertEquals((long)3L, (long)allClusters.size());
    }

    @Test
    public void testInvalidGetPolicyConfiguration() throws YarnException {
        Assert.assertNull((Object)this.facade.getPolicyConfiguration("dummy"));
    }

    @Test
    public void testGetPoliciesConfigurations() throws YarnException {
        Map queuePolicies = this.facade.getPoliciesConfigurations();
        for (String queue : queuePolicies.keySet()) {
            Assert.assertEquals((Object)this.stateStoreTestUtil.queryPolicyConfiguration(queue), queuePolicies.get(queue));
        }
    }

    @Test
    public void testGetHomeSubClusterForApp() throws YarnException {
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)i);
            Assert.assertEquals((Object)this.stateStoreTestUtil.queryApplicationHomeSC(appId), (Object)this.facade.getApplicationHomeSubCluster(appId));
        }
    }

    @Test
    public void testAddApplicationHomeSubCluster() throws YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)6);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"Home1");
        ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        SubClusterId result = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        Assert.assertEquals((Object)this.facade.getApplicationHomeSubCluster(appId), (Object)result);
        Assert.assertEquals((Object)subClusterId1, (Object)result);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"Home2");
        appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        result = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        Assert.assertEquals((Object)this.facade.getApplicationHomeSubCluster(appId), (Object)result);
        Assert.assertEquals((Object)subClusterId1, (Object)result);
    }

    @Test
    public void testGetApplicationHomeSubClusterCache() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)6);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"Home1");
        ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        SubClusterId subClusterIdAdd = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        SubClusterId subClusterIdByFacade = this.facade.getApplicationHomeSubCluster(appId);
        Assert.assertEquals((Object)subClusterIdByFacade, (Object)subClusterIdAdd);
        Assert.assertEquals((Object)subClusterId1, (Object)subClusterIdAdd);
        if (this.isCachingEnabled.booleanValue()) {
            FederationCache fedCache = this.facade.getFederationCache();
            assert (fedCache instanceof FederationJCache);
            FederationJCache jCache = (FederationJCache)fedCache;
            String cacheKey = jCache.getAppHomeSubClusterCacheKey(appId);
            Cache cache = jCache.getCache();
            FederationCache.CacheRequest cacheRequest = (FederationCache.CacheRequest)cache.get((Object)cacheKey);
            FederationCache.ApplicationHomeSubClusterCacheResponse response = (FederationCache.ApplicationHomeSubClusterCacheResponse)FederationCache.ApplicationHomeSubClusterCacheResponse.class.cast(cacheRequest.getValue());
            SubClusterId subClusterIdByCache = response.getItem();
            Assert.assertEquals((Object)subClusterIdByFacade, (Object)subClusterIdByCache);
            Assert.assertEquals((Object)subClusterId1, (Object)subClusterIdByCache);
        }
    }

    @Test
    public void testStoreNewMasterKey() throws YarnException, IOException {
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        this.facade.storeNewMasterKey(key);
        MemoryFederationStateStore federationStateStore = (MemoryFederationStateStore)this.facade.getStateStore();
        RouterRMDTSecretManagerState secretManagerState = federationStateStore.getRouterRMSecretManagerState();
        Assert.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
    }

    @Test
    public void testRemoveStoredMasterKey() throws YarnException, IOException {
        DelegationKey key = new DelegationKey(4567, 7654L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        this.facade.storeNewMasterKey(key);
        this.facade.removeStoredMasterKey(key);
        keySet.clear();
        MemoryFederationStateStore federationStateStore = (MemoryFederationStateStore)this.facade.getStateStore();
        RouterRMDTSecretManagerState secretManagerState = federationStateStore.getRouterRMSecretManagerState();
        Assert.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
    }

    @Test
    public void testStoreNewToken() throws YarnException, IOException {
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        int sequenceNumber = 1;
        dtId1.setSequenceNumber(sequenceNumber);
        Long renewDate1 = Time.now();
        this.facade.storeNewToken(dtId1, renewDate1.longValue());
        RouterStoreToken routerStoreToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)dtId1, (Long)renewDate1);
        RouterRMTokenRequest rmTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)routerStoreToken);
        RouterRMTokenResponse rmTokenResponse = this.stateStore.getTokenByRouterStoreToken(rmTokenRequest);
        Assert.assertNotNull((Object)rmTokenResponse);
        RouterStoreToken resultStoreToken = rmTokenResponse.getRouterStoreToken();
        YARNDelegationTokenIdentifier resultTokenIdentifier = resultStoreToken.getTokenIdentifier();
        Assert.assertNotNull((Object)resultStoreToken);
        Assert.assertNotNull((Object)resultTokenIdentifier);
        Assert.assertNotNull((Object)resultStoreToken.getRenewDate());
        Assert.assertEquals((Object)dtId1, (Object)resultTokenIdentifier);
        Assert.assertEquals((Object)renewDate1, (Object)resultStoreToken.getRenewDate());
        Assert.assertEquals((long)sequenceNumber, (long)resultTokenIdentifier.getSequenceNumber());
    }

    @Test
    public void testUpdateNewToken() throws YarnException, IOException {
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner2"), new Text("renewer2"), new Text("realuser2"));
        int sequenceNumber = 2;
        dtId1.setSequenceNumber(sequenceNumber);
        Long renewDate1 = Time.now();
        this.facade.storeNewToken(dtId1, renewDate1.longValue());
        Long renewDate2 = Time.now();
        int sequenceNumber2 = 3;
        dtId1.setSequenceNumber(sequenceNumber2);
        this.facade.updateStoredToken(dtId1, renewDate2.longValue());
        RouterStoreToken routerStoreToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)dtId1, (Long)renewDate1);
        RouterRMTokenRequest rmTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)routerStoreToken);
        RouterRMTokenResponse rmTokenResponse = this.stateStore.getTokenByRouterStoreToken(rmTokenRequest);
        Assert.assertNotNull((Object)rmTokenResponse);
        RouterStoreToken resultStoreToken = rmTokenResponse.getRouterStoreToken();
        YARNDelegationTokenIdentifier resultTokenIdentifier = resultStoreToken.getTokenIdentifier();
        Assert.assertNotNull((Object)resultStoreToken);
        Assert.assertNotNull((Object)resultTokenIdentifier);
        Assert.assertNotNull((Object)resultStoreToken.getRenewDate());
        Assert.assertEquals((Object)dtId1, (Object)resultTokenIdentifier);
        Assert.assertEquals((Object)renewDate2, (Object)resultStoreToken.getRenewDate());
        Assert.assertEquals((long)sequenceNumber2, (long)resultTokenIdentifier.getSequenceNumber());
    }

    @Test
    public void testRemoveStoredToken() throws Exception {
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner3"), new Text("renewer3"), new Text("realuser3"));
        int sequenceNumber = 3;
        dtId1.setSequenceNumber(sequenceNumber);
        Long renewDate1 = Time.now();
        this.facade.storeNewToken(dtId1, renewDate1.longValue());
        RouterStoreToken routerStoreToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)dtId1, (Long)renewDate1);
        RouterRMTokenRequest rmTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)routerStoreToken);
        RouterRMTokenResponse rmTokenResponse = this.stateStore.getTokenByRouterStoreToken(rmTokenRequest);
        Assert.assertNotNull((Object)rmTokenResponse);
        RouterStoreToken resultStoreToken = rmTokenResponse.getRouterStoreToken();
        YARNDelegationTokenIdentifier resultTokenIdentifier = resultStoreToken.getTokenIdentifier();
        Assert.assertNotNull((Object)resultStoreToken);
        Assert.assertNotNull((Object)resultTokenIdentifier);
        Assert.assertNotNull((Object)resultStoreToken.getRenewDate());
        Assert.assertEquals((Object)dtId1, (Object)resultTokenIdentifier);
        Assert.assertEquals((Object)renewDate1, (Object)resultStoreToken.getRenewDate());
        Assert.assertEquals((long)sequenceNumber, (long)resultTokenIdentifier.getSequenceNumber());
        this.facade.removeStoredToken(dtId1);
        LambdaTestUtils.intercept(IOException.class, (String)("RMDelegationToken: " + dtId1 + " does not exist."), () -> this.stateStore.getTokenByRouterStoreToken(rmTokenRequest));
    }
}

