/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.util.MonotonicClock;

public class FederationStateStoreTestUtil {
    private static final MonotonicClock CLOCK = new MonotonicClock();
    public static final String SC_PREFIX = "SC-";
    public static final String Q_PREFIX = "queue-";
    public static final String POLICY_PREFIX = "policy-";
    public static final String INVALID = "dummy";
    private FederationStateStore stateStore;

    public FederationStateStoreTestUtil(FederationStateStore stateStore) {
        this.stateStore = stateStore;
    }

    private SubClusterInfo createSubClusterInfo(SubClusterId subClusterId) {
        String amRMAddress = "1.2.3.4:1";
        String clientRMAddress = "1.2.3.4:2";
        String rmAdminAddress = "1.2.3.4:3";
        String webAppAddress = "1.2.3.4:4";
        return SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMAddress, (String)clientRMAddress, (String)rmAdminAddress, (String)webAppAddress, (SubClusterState)SubClusterState.SC_RUNNING, (long)CLOCK.getTime(), (String)"capability");
    }

    public void registerSubCluster(SubClusterId subClusterId) throws YarnException {
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
    }

    public void registerSubClusters(int numSubClusters) throws YarnException {
        for (int i = 0; i < numSubClusters; ++i) {
            this.registerSubCluster(SubClusterId.newInstance((String)(SC_PREFIX + i)));
        }
    }

    private void addApplicationHomeSC(ApplicationId appId, SubClusterId subClusterId) throws YarnException {
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        AddApplicationHomeSubClusterRequest request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        this.stateStore.addApplicationHomeSubCluster(request);
    }

    public void addAppsHomeSC(long clusterTs, int numApps) throws YarnException {
        for (int i = 0; i < numApps; ++i) {
            this.addApplicationHomeSC(ApplicationId.newInstance((long)clusterTs, (int)i), SubClusterId.newInstance((String)(SC_PREFIX + i)));
        }
    }

    public List<SubClusterId> getAllSubClusterIds(boolean filterInactiveSubclusters) throws YarnException {
        List infos = this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance((boolean)filterInactiveSubclusters)).getSubClusters();
        ArrayList<SubClusterId> ids = new ArrayList<SubClusterId>();
        for (SubClusterInfo s : infos) {
            ids.add(s.getSubClusterId());
        }
        return ids;
    }

    private SubClusterPolicyConfiguration createSCPolicyConf(String queueName, String policyType) {
        return SubClusterPolicyConfiguration.newInstance((String)queueName, (String)policyType, (ByteBuffer)ByteBuffer.allocate(1));
    }

    private void setPolicyConf(String queue, String policyType) throws YarnException {
        SetSubClusterPolicyConfigurationRequest request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf(queue, policyType));
        this.stateStore.setPolicyConfiguration(request);
    }

    public void addPolicyConfigs(int numQueues) throws YarnException {
        for (int i = 0; i < numQueues; ++i) {
            this.setPolicyConf(Q_PREFIX + i, POLICY_PREFIX + i);
        }
    }

    public SubClusterInfo querySubClusterInfo(SubClusterId subClusterId) throws YarnException {
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        return this.stateStore.getSubCluster(request).getSubClusterInfo();
    }

    public SubClusterId queryApplicationHomeSC(ApplicationId appId) throws YarnException {
        GetApplicationHomeSubClusterRequest request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(request);
        return response.getApplicationHomeSubCluster().getHomeSubCluster();
    }

    public SubClusterPolicyConfiguration queryPolicyConfiguration(String queue) throws YarnException {
        GetSubClusterPolicyConfigurationRequest request = GetSubClusterPolicyConfigurationRequest.newInstance((String)queue);
        GetSubClusterPolicyConfigurationResponse result = this.stateStore.getPolicyConfiguration(request);
        return result.getPolicyConfiguration();
    }

    public void deregisterAllSubClusters() throws YarnException {
        for (SubClusterId sc : this.getAllSubClusterIds(true)) {
            this.deRegisterSubCluster(sc);
        }
    }

    public void deRegisterSubCluster(SubClusterId subClusterId) throws YarnException {
        this.stateStore.deregisterSubCluster(SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED));
    }
}

