/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class BasePolicyManagerTest {
    protected FederationPolicyManager wfp = null;
    protected Class expectedPolicyManager;
    protected Class expectedAMRMProxyPolicy;
    protected Class expectedRouterPolicy;

    @Test
    public void testSerializeAndInstantiate() throws Exception {
        BasePolicyManagerTest.serializeAndDeserializePolicyManager(this.wfp, this.expectedPolicyManager, this.expectedAMRMProxyPolicy, this.expectedRouterPolicy);
    }

    @Test(expected=FederationPolicyInitializationException.class)
    public void testSerializeAndInstantiateBad1() throws Exception {
        BasePolicyManagerTest.serializeAndDeserializePolicyManager(this.wfp, String.class, this.expectedAMRMProxyPolicy, this.expectedRouterPolicy);
    }

    @Test(expected=AssertionError.class)
    public void testSerializeAndInstantiateBad2() throws Exception {
        BasePolicyManagerTest.serializeAndDeserializePolicyManager(this.wfp, this.expectedPolicyManager, String.class, this.expectedRouterPolicy);
    }

    @Test(expected=AssertionError.class)
    public void testSerializeAndInstantiateBad3() throws Exception {
        BasePolicyManagerTest.serializeAndDeserializePolicyManager(this.wfp, this.expectedPolicyManager, this.expectedAMRMProxyPolicy, String.class);
    }

    protected static void serializeAndDeserializePolicyManager(FederationPolicyManager wfp, Class policyManagerType, Class expAMRMProxyPolicy, Class expRouterPolicy) throws Exception {
        SubClusterPolicyConfiguration fpc = wfp.serializeConf();
        fpc.setType(policyManagerType.getCanonicalName());
        FederationPolicyInitializationContext context = new FederationPolicyInitializationContext();
        context.setSubClusterPolicyConfiguration(fpc);
        context.setFederationStateStoreFacade(FederationPoliciesTestUtil.initFacade());
        context.setFederationSubclusterResolver(FederationPoliciesTestUtil.initResolver());
        context.setHomeSubcluster(SubClusterId.newInstance((String)"homesubcluster"));
        Class<?> c = Class.forName(wfp.getClass().getCanonicalName());
        FederationPolicyManager wfp2 = (FederationPolicyManager)c.newInstance();
        FederationAMRMProxyPolicy federationAMRMProxyPolicy = wfp2.getAMRMPolicy(context, null);
        FederationRouterPolicy federationRouterPolicy = wfp2.getRouterPolicy(context, null);
        Assertions.assertThat((Object)federationAMRMProxyPolicy).isExactlyInstanceOf(expAMRMProxyPolicy);
        Assertions.assertThat((Object)federationRouterPolicy).isExactlyInstanceOf(expRouterPolicy);
    }
}

