/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTimelineDataManager
extends TimelineStoreTestUtils {
    private FileContext fsContext;
    private File fsPath;
    private TimelineDataManager dataManaer;
    private static TimelineACLsManager aclsManager;
    private static AdminACLsManager adminACLsManager;

    @BeforeEach
    public void setup() throws Exception {
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.timeline-service.leveldb-timeline-store.path", this.fsPath.getAbsolutePath());
        conf.setBoolean("yarn.timeline-service.ttl-enable", false);
        this.store = new LeveldbTimelineStore();
        this.store.init((Configuration)conf);
        this.store.start();
        this.loadTestEntityData();
        this.loadVerificationEntityData();
        this.loadTestDomainData();
        conf.setBoolean("yarn.acl.enable", false);
        aclsManager = new TimelineACLsManager((Configuration)conf);
        aclsManager.setTimelineStore(this.store);
        this.dataManaer = new TimelineDataManager(this.store, aclsManager);
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        this.dataManaer.init((Configuration)conf);
        adminACLsManager = new AdminACLsManager((Configuration)conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.store != null) {
            this.store.stop();
        }
        if (this.fsContext != null) {
            this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        }
    }

    @Test
    void testGetOldEntityWithOutDomainId() throws Exception {
        TimelineEntity entity = this.dataManaer.getEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1", null, UserGroupInformation.getCurrentUser());
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"OLD_ENTITY_ID_1", (Object)entity.getEntityId());
        Assertions.assertEquals((Object)"OLD_ENTITY_TYPE_1", (Object)entity.getEntityType());
        Assertions.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
    }

    @Test
    void testGetEntitiesAclEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = aclsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = this.dataManaer.getEntities("ACL_ENTITY_TYPE_1", null, null, null, null, null, null, Long.valueOf(1L), null, UserGroupInformation.createUserForTesting((String)"owner_1", (String[])new String[]{"group1"}));
            Assertions.assertEquals((int)1, (int)entities.getEntities().size());
            Assertions.assertEquals((Object)"ACL_ENTITY_ID_11", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        }
        finally {
            aclsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    void testGetOldEntitiesWithOutDomainId() throws Exception {
        TimelineEntities entities = this.dataManaer.getEntities("OLD_ENTITY_TYPE_1", null, null, null, null, null, null, null, null, UserGroupInformation.getCurrentUser());
        Assertions.assertEquals((int)2, (int)entities.getEntities().size());
        Assertions.assertEquals((Object)"OLD_ENTITY_ID_2", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        Assertions.assertEquals((Object)"OLD_ENTITY_TYPE_1", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType());
        Assertions.assertEquals((Object)"DEFAULT", (Object)((TimelineEntity)entities.getEntities().get(0)).getDomainId());
        Assertions.assertEquals((Object)"OLD_ENTITY_ID_1", (Object)((TimelineEntity)entities.getEntities().get(1)).getEntityId());
        Assertions.assertEquals((Object)"OLD_ENTITY_TYPE_1", (Object)((TimelineEntity)entities.getEntities().get(1)).getEntityType());
        Assertions.assertEquals((Object)"DEFAULT", (Object)((TimelineEntity)entities.getEntities().get(1)).getDomainId());
    }

    @Test
    void testUpdatingOldEntityWithoutDomainId() throws Exception {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("OLD_ENTITY_TYPE_1");
        entity.setEntityId("OLD_ENTITY_ID_1");
        entity.setDomainId("DEFAULT");
        entity.addOtherInfo("NEW_OTHER_INFO_KEY", (Object)"NEW_OTHER_INFO_VALUE");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entity);
        TimelinePutResponse response = this.dataManaer.postEntities(entities, UserGroupInformation.getCurrentUser());
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        entity = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
        Assertions.assertEquals((int)1, (int)entity.getOtherInfo().size());
        Assertions.assertEquals((Object)"NEW_OTHER_INFO_KEY", entity.getOtherInfo().keySet().iterator().next());
        Assertions.assertEquals((Object)"NEW_OTHER_INFO_VALUE", entity.getOtherInfo().values().iterator().next());
        entity = new TimelineEntity();
        entity.setEntityType("OLD_ENTITY_TYPE_1");
        entity.setEntityId("OLD_ENTITY_ID_2");
        entity.setDomainId("NON_DEFAULT");
        entity.addOtherInfo("NEW_OTHER_INFO_KEY", (Object)"NEW_OTHER_INFO_VALUE");
        entities = new TimelineEntities();
        entities.addEntity(entity);
        response = this.dataManaer.postEntities(entities, UserGroupInformation.getCurrentUser());
        Assertions.assertEquals((int)1, (int)response.getErrors().size());
        Assertions.assertEquals((int)4, (int)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        entity = this.store.getEntity("OLD_ENTITY_ID_2", "OLD_ENTITY_TYPE_1", null);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNull((Object)entity.getDomainId());
        Assertions.assertEquals((int)0, (int)entity.getOtherInfo().size());
    }
}

