/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.recovery;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.timeline.recovery.LeveldbTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLeveldbTimelineStateStore {
    private FileContext fsContext;
    private File fsPath;
    private Configuration conf;
    private TimelineStateStore store;

    @BeforeEach
    public void setup() throws Exception {
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.recovery.enabled", true);
        this.conf.setClass("yarn.timeline-service.state-store-class", LeveldbTimelineStateStore.class, TimelineStateStore.class);
        this.conf.set("yarn.timeline-service.leveldb-state-store.path", this.fsPath.getAbsolutePath());
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.store != null) {
            this.store.stop();
        }
        if (this.fsContext != null) {
            this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        }
    }

    private LeveldbTimelineStateStore initAndStartTimelineServiceStateStoreService() {
        this.store = new LeveldbTimelineStateStore();
        this.store.init(this.conf);
        this.store.start();
        return (LeveldbTimelineStateStore)this.store;
    }

    @Test
    void testTokenStore() throws Exception {
        this.initAndStartTimelineServiceStateStoreService();
        TimelineStateStore.TimelineServiceState state = this.store.loadState();
        Assertions.assertTrue((boolean)state.tokenState.isEmpty(), (String)"token state not empty");
        Assertions.assertTrue((boolean)state.tokenMasterKeyState.isEmpty(), (String)"key state not empty");
        DelegationKey key1 = new DelegationKey(1, 2L, "keyData1".getBytes());
        TimelineDelegationTokenIdentifier token1 = new TimelineDelegationTokenIdentifier(new Text("tokenOwner1"), new Text("tokenRenewer1"), new Text("tokenUser1"));
        token1.setSequenceNumber(1);
        token1.getBytes();
        Long tokenDate1 = 1L;
        TimelineDelegationTokenIdentifier token2 = new TimelineDelegationTokenIdentifier(new Text("tokenOwner2"), new Text("tokenRenewer2"), new Text("tokenUser2"));
        token2.setSequenceNumber(12345678);
        token2.getBytes();
        Long tokenDate2 = 87654321L;
        this.store.storeTokenMasterKey(key1);
        try {
            this.store.storeTokenMasterKey(key1);
            Assertions.fail((String)"redundant store of key undetected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.store.storeToken(token1, tokenDate1);
        this.store.storeToken(token2, tokenDate2);
        try {
            this.store.storeToken(token1, tokenDate1);
            Assertions.fail((String)"redundant store of token undetected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.store.close();
        this.initAndStartTimelineServiceStateStoreService();
        state = this.store.loadState();
        Assertions.assertEquals((int)2, (int)state.tokenState.size(), (String)"incorrect loaded token count");
        Assertions.assertTrue((boolean)state.tokenState.containsKey(token1), (String)"missing token 1");
        Assertions.assertEquals((Long)tokenDate1, (Long)((Long)state.tokenState.get(token1)), (String)"incorrect token 1 date");
        Assertions.assertTrue((boolean)state.tokenState.containsKey(token2), (String)"missing token 2");
        Assertions.assertEquals((Long)tokenDate2, (Long)((Long)state.tokenState.get(token2)), (String)"incorrect token 2 date");
        Assertions.assertEquals((int)1, (int)state.tokenMasterKeyState.size(), (String)"incorrect master key count");
        Assertions.assertTrue((boolean)state.tokenMasterKeyState.contains(key1), (String)"missing master key 1");
        Assertions.assertEquals((int)12345678, (int)state.getLatestSequenceNumber(), (String)"incorrect latest sequence number");
        DelegationKey key2 = new DelegationKey(3, 4L, "keyData2".getBytes());
        DelegationKey key3 = new DelegationKey(5, 6L, "keyData3".getBytes());
        TimelineDelegationTokenIdentifier token3 = new TimelineDelegationTokenIdentifier(new Text("tokenOwner3"), new Text("tokenRenewer3"), new Text("tokenUser3"));
        token3.setSequenceNumber(12345679);
        token3.getBytes();
        Long tokenDate3 = 87654321L;
        this.store.removeToken(token1);
        this.store.storeTokenMasterKey(key2);
        Long newTokenDate2 = 975318642L;
        this.store.updateToken(token2, newTokenDate2);
        this.store.removeTokenMasterKey(key1);
        this.store.storeTokenMasterKey(key3);
        this.store.storeToken(token3, tokenDate3);
        this.store.close();
        this.initAndStartTimelineServiceStateStoreService();
        state = this.store.loadState();
        Assertions.assertEquals((int)2, (int)state.tokenState.size(), (String)"incorrect loaded token count");
        Assertions.assertFalse((boolean)state.tokenState.containsKey(token1), (String)"token 1 not removed");
        Assertions.assertTrue((boolean)state.tokenState.containsKey(token2), (String)"missing token 2");
        Assertions.assertEquals((Long)newTokenDate2, (Long)((Long)state.tokenState.get(token2)), (String)"incorrect token 2 date");
        Assertions.assertTrue((boolean)state.tokenState.containsKey(token3), (String)"missing token 3");
        Assertions.assertEquals((Long)tokenDate3, (Long)((Long)state.tokenState.get(token3)), (String)"incorrect token 3 date");
        Assertions.assertEquals((int)2, (int)state.tokenMasterKeyState.size(), (String)"incorrect master key count");
        Assertions.assertFalse((boolean)state.tokenMasterKeyState.contains(key1), (String)"master key 1 not removed");
        Assertions.assertTrue((boolean)state.tokenMasterKeyState.contains(key2), (String)"missing master key 2");
        Assertions.assertTrue((boolean)state.tokenMasterKeyState.contains(key3), (String)"missing master key 3");
        Assertions.assertEquals((int)12345679, (int)state.getLatestSequenceNumber(), (String)"incorrect latest sequence number");
        this.store.close();
    }

    @Test
    void testCheckVersion() throws IOException {
        LeveldbTimelineStateStore store = this.initAndStartTimelineServiceStateStoreService();
        Version defaultVersion = store.getCurrentVersion();
        Assertions.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        store.storeVersion(compatibleVersion);
        Assertions.assertEquals((Object)compatibleVersion, (Object)store.loadVersion());
        store.stop();
        store = this.initAndStartTimelineServiceStateStoreService();
        Assertions.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 1), (int)defaultVersion.getMinorVersion());
        store.storeVersion(incompatibleVersion);
        store.stop();
        try {
            this.initAndStartTimelineServiceStateStoreService();
            Assertions.fail((String)"Incompatible version, should expect fail here.");
        }
        catch (ServiceStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Incompatible version for timeline state store"), (String)"Exception message mismatch");
        }
    }
}

