/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestApplicationHistoryManagerImpl
extends ApplicationHistoryStoreTestUtils {
    private ApplicationHistoryManagerImpl applicationHistoryManagerImpl = null;

    @BeforeEach
    public void setup() throws Exception {
        Configuration config = new Configuration();
        config.setClass("yarn.timeline-service.generic-application-history.store-class", MemoryApplicationHistoryStore.class, ApplicationHistoryStore.class);
        this.applicationHistoryManagerImpl = new ApplicationHistoryManagerImpl();
        this.applicationHistoryManagerImpl.init(config);
        this.applicationHistoryManagerImpl.start();
        this.store = this.applicationHistoryManagerImpl.getHistoryStore();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.applicationHistoryManagerImpl.stop();
    }

    @Test
    void testApplicationReport() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        this.writeApplicationFinishData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        this.writeApplicationAttemptStartData(appAttemptId);
        this.writeApplicationAttemptFinishData(appAttemptId);
        ApplicationReport appReport = this.applicationHistoryManagerImpl.getApplication(appId);
        Assertions.assertNotNull((Object)appReport);
        Assertions.assertEquals((Object)appId, (Object)appReport.getApplicationId());
        Assertions.assertEquals((Object)appAttemptId, (Object)appReport.getCurrentApplicationAttemptId());
        Assertions.assertEquals((Object)appAttemptId.toString(), (Object)appReport.getHost());
        Assertions.assertEquals((Object)"test type", (Object)appReport.getApplicationType().toString());
        Assertions.assertEquals((Object)"test queue", (Object)appReport.getQueue().toString());
    }

    @Test
    void testApplications() throws IOException {
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)0L, (int)2);
        ApplicationId appId3 = ApplicationId.newInstance((long)0L, (int)3);
        this.writeApplicationStartData(appId1, 1000L);
        this.writeApplicationFinishData(appId1);
        this.writeApplicationStartData(appId2, 3000L);
        this.writeApplicationFinishData(appId2);
        this.writeApplicationStartData(appId3, 4000L);
        this.writeApplicationFinishData(appId3);
        Map reports = this.applicationHistoryManagerImpl.getApplications(2L, 2000L, 5000L);
        Assertions.assertNotNull((Object)reports);
        Assertions.assertEquals((int)2, (int)reports.size());
        Assertions.assertNull(reports.get("1"));
        Assertions.assertNull(reports.get("2"));
        Assertions.assertNull(reports.get("3"));
    }
}

