/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.timeline.RollingLevelDBTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.eclipse.jetty.util.log.Log;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.Options;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TestRollingLevelDBTimelineStore
extends TimelineStoreTestUtils {
    private FileContext fsContext;
    private File fsPath;
    private Configuration config = new YarnConfiguration();

    @Before
    public void setup() throws Exception {
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        this.config.set("yarn.timeline-service.leveldb-timeline-store.path", this.fsPath.getAbsolutePath());
        this.config.setBoolean("yarn.timeline-service.ttl-enable", false);
        this.store = new RollingLevelDBTimelineStore();
        this.store.init(this.config);
        this.store.start();
        this.loadTestEntityData();
        this.loadVerificationEntityData();
        this.loadTestDomainData();
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
    }

    @Test
    public void testRootDirPermission() throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new YarnConfiguration());
        FileStatus file = fs.getFileStatus(new Path(this.fsPath.getAbsolutePath(), "leveldb-timeline-store"));
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)RollingLevelDBTimelineStore.LEVELDB_DIR_UMASK, (Object)file.getPermission());
    }

    @Override
    @Test
    public void testGetSingleEntity() throws IOException {
        super.testGetSingleEntity();
        ((RollingLevelDBTimelineStore)this.store).clearStartTimeCache();
        super.testGetSingleEntity();
        this.loadTestEntityData();
    }

    @Override
    @Test
    public void testGetEntities() throws IOException {
        super.testGetEntities();
    }

    @Override
    @Test
    public void testGetEntitiesWithFromId() throws IOException {
        super.testGetEntitiesWithFromId();
    }

    @Override
    @Test
    public void testGetEntitiesWithFromTs() throws IOException {
    }

    @Override
    @Test
    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        super.testGetEntitiesWithPrimaryFilters();
    }

    @Override
    @Test
    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        super.testGetEntitiesWithSecondaryFilters();
    }

    @Override
    @Test
    public void testGetEvents() throws IOException {
        super.testGetEvents();
    }

    @Test
    public void testCacheSizes() {
        Configuration conf = new Configuration();
        Assert.assertEquals((long)10000L, (long)RollingLevelDBTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        Assert.assertEquals((long)10000L, (long)RollingLevelDBTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10001);
        Assert.assertEquals((long)10001L, (long)RollingLevelDBTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        conf = new Configuration();
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10002);
        Assert.assertEquals((long)10002L, (long)RollingLevelDBTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
    }

    @Test
    public void testCheckVersion() throws IOException {
        RollingLevelDBTimelineStore dbStore = (RollingLevelDBTimelineStore)this.store;
        Version defaultVersion = dbStore.getCurrentVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)dbStore.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        dbStore.storeVersion(compatibleVersion);
        Assert.assertEquals((Object)compatibleVersion, (Object)dbStore.loadVersion());
        this.restartTimelineStore();
        dbStore = (RollingLevelDBTimelineStore)this.store;
        Assert.assertEquals((Object)defaultVersion, (Object)dbStore.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 1), (int)defaultVersion.getMinorVersion());
        dbStore.storeVersion(incompatibleVersion);
        try {
            this.restartTimelineStore();
            Assert.fail((String)"Incompatible version, should expect fail here.");
        }
        catch (ServiceStateException e) {
            Assert.assertTrue((String)"Exception message mismatch", (boolean)e.getMessage().contains("Incompatible version for timeline store"));
        }
    }

    @Test
    public void testValidateConfig() throws IOException {
        YarnConfiguration newConfig;
        YarnConfiguration copyConfig = new YarnConfiguration(this.config);
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.ttl-ms", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.ttl-ms"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.read-cache-size", -1L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.read-cache-size"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size"));
        }
        this.config = copyConfig;
        this.restartTimelineStore();
    }

    private void restartTimelineStore() throws IOException {
        if (this.store != null) {
            this.store.close();
        }
        this.store = new RollingLevelDBTimelineStore();
        this.store.init(this.config);
        this.store.start();
    }

    @Override
    @Test
    public void testGetDomain() throws IOException {
        super.testGetDomain();
    }

    @Override
    @Test
    public void testGetDomains() throws IOException {
        super.testGetDomains();
    }

    @Test
    public void testRelatingToNonExistingEntity() throws IOException {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("TEST_ENTITY_TYPE_1");
        entityToStore.setEntityId("TEST_ENTITY_ID_1");
        entityToStore.setDomainId("DEFAULT");
        entityToStore.addRelatedEntity("TEST_ENTITY_TYPE_2", "TEST_ENTITY_ID_2");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("TEST_ENTITY_ID_2", "TEST_ENTITY_TYPE_2", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertEquals((Object)"DEFAULT", (Object)entityToGet.getDomainId());
        Assert.assertEquals((Object)"TEST_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assert.assertEquals((Object)"TEST_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
    }

    @Test
    public void testRelatingToEntityInSamePut() throws IOException {
        TimelineEntity entityToRelate = new TimelineEntity();
        entityToRelate.setEntityType("TEST_ENTITY_TYPE_2");
        entityToRelate.setEntityId("TEST_ENTITY_ID_2");
        entityToRelate.setDomainId("TEST_DOMAIN");
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("TEST_ENTITY_TYPE_1");
        entityToStore.setEntityId("TEST_ENTITY_ID_1");
        entityToStore.setDomainId("TEST_DOMAIN");
        entityToStore.addRelatedEntity("TEST_ENTITY_TYPE_2", "TEST_ENTITY_ID_2");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        entities.addEntity(entityToRelate);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("TEST_ENTITY_ID_2", "TEST_ENTITY_TYPE_2", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertEquals((Object)"TEST_DOMAIN", (Object)entityToGet.getDomainId());
        Assert.assertEquals((Object)"TEST_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assert.assertEquals((Object)"TEST_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
    }

    @Test
    public void testRelatingToOldEntityWithoutDomainId() throws IOException {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("NEW_ENTITY_TYPE_1");
        entityToStore.setEntityId("NEW_ENTITY_ID_1");
        entityToStore.setDomainId("DEFAULT");
        entityToStore.addRelatedEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertEquals((Object)"DEFAULT", (Object)entityToGet.getDomainId());
        Assert.assertEquals((Object)"NEW_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assert.assertEquals((Object)"NEW_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
        entityToStore = new TimelineEntity();
        entityToStore.setEntityType("NEW_ENTITY_TYPE_2");
        entityToStore.setEntityId("NEW_ENTITY_ID_2");
        entityToStore.setDomainId("NON_DEFAULT");
        entityToStore.addRelatedEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1");
        entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        TimelinePutResponse response = this.store.put(entities);
        Assert.assertEquals((long)1L, (long)response.getErrors().size());
        Assert.assertEquals((long)6L, (long)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        entityToGet = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertEquals((Object)"DEFAULT", (Object)entityToGet.getDomainId());
        Assert.assertEquals((long)1L, (long)entityToGet.getRelatedEntities().keySet().size());
        Assert.assertEquals((long)1L, (long)((Set)entityToGet.getRelatedEntities().values().iterator().next()).size());
    }

    public void testStorePerformance() throws IOException {
        TimelineEntity entityToStorePrep = new TimelineEntity();
        entityToStorePrep.setEntityType("TEST_ENTITY_TYPE_PREP");
        entityToStorePrep.setEntityId("TEST_ENTITY_ID_PREP");
        entityToStorePrep.setDomainId("TEST_DOMAIN");
        entityToStorePrep.addRelatedEntity("TEST_ENTITY_TYPE_2", "TEST_ENTITY_ID_2");
        entityToStorePrep.setStartTime(Long.valueOf(0L));
        TimelineEntities entitiesPrep = new TimelineEntities();
        entitiesPrep.addEntity(entityToStorePrep);
        this.store.put(entitiesPrep);
        long start = System.currentTimeMillis();
        int num = 1000000;
        Log.getLog().info("Start test for " + num, new Object[0]);
        String tezTaskAttemptId = "TEZ_TA";
        String tezEntityId = "attempt_1429158534256_0001_1_00_000000_";
        String tezTaskId = "TEZ_T";
        String tezDomainId = "Tez_ATS_application_1429158534256_0001";
        TimelineEntity entityToStore = new TimelineEntity();
        TimelineEvent startEvt = new TimelineEvent();
        entityToStore.setEntityType("TEZ_TA");
        startEvt.setEventType("TASK_ATTEMPT_STARTED");
        startEvt.setTimestamp(0L);
        entityToStore.addEvent(startEvt);
        entityToStore.setDomainId("Tez_ATS_application_1429158534256_0001");
        entityToStore.addPrimaryFilter("status", (Object)"SUCCEEDED");
        entityToStore.addPrimaryFilter("applicationId", (Object)"application_1429158534256_0001");
        entityToStore.addPrimaryFilter("TEZ_VERTEX_ID", (Object)"vertex_1429158534256_0001_1_00");
        entityToStore.addPrimaryFilter("TEZ_DAG_ID", (Object)"dag_1429158534256_0001_1");
        entityToStore.addPrimaryFilter("TEZ_TASK_ID", (Object)"task_1429158534256_0001_1_00_000000");
        entityToStore.setStartTime(Long.valueOf(0L));
        entityToStore.addOtherInfo("startTime", (Object)0);
        entityToStore.addOtherInfo("inProgressLogsURL", (Object)"localhost:8042/inProgressLogsURL");
        entityToStore.addOtherInfo("completedLogsURL", (Object)"");
        entityToStore.addOtherInfo("nodeId", (Object)"localhost:54450");
        entityToStore.addOtherInfo("nodeHttpAddress", (Object)"localhost:8042");
        entityToStore.addOtherInfo("containerId", (Object)"container_1429158534256_0001_01_000002");
        entityToStore.addOtherInfo("status", (Object)"RUNNING");
        entityToStore.addRelatedEntity("TEZ_T", "TEZ_TASK_ID_1");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        for (int i = 0; i < num; ++i) {
            entityToStore.setEntityId("attempt_1429158534256_0001_1_00_000000_" + i);
            this.store.put(entities);
        }
        long duration = System.currentTimeMillis() - start;
        Log.getLog().info("Duration for " + num + ": " + duration, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLevelDbRepair() throws IOException {
        RollingLevelDBTimelineStore store = new RollingLevelDBTimelineStore();
        JniDBFactory factory = (JniDBFactory)Mockito.mock(JniDBFactory.class);
        Mockito.when((Object)factory.open((File)Mockito.any(File.class), (Options)Mockito.any(Options.class))).thenThrow(new Throwable[]{new IOException()}).thenCallRealMethod();
        store.setFactory(factory);
        File path = new File("target", this.getClass().getSimpleName() + "-tmpDir2").getAbsoluteFile();
        Configuration conf = new Configuration(this.config);
        conf.set("yarn.timeline-service.leveldb-timeline-store.path", path.getAbsolutePath());
        try {
            store.init(conf);
            ((JniDBFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).repair((File)Mockito.any(File.class), (Options)Mockito.any(Options.class));
            WildcardFileFilter fileFilter = new WildcardFileFilter("*.backup-*");
            Assert.assertTrue((new File(path.getAbsolutePath(), "leveldb-timeline-store").list((FilenameFilter)fileFilter).length > 0 ? 1 : 0) != 0);
        }
        finally {
            store.close();
            this.fsContext.delete(new Path(path.getAbsolutePath()), true);
        }
    }

    public static void main(String[] args) throws Exception {
        TestRollingLevelDBTimelineStore store = new TestRollingLevelDBTimelineStore();
        store.setup();
        store.testStorePerformance();
        store.tearDown();
    }
}

