/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnDefaultProperties;
import org.apache.hadoop.yarn.server.volume.VolumeManager;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.LoggerFactory;

public class HSVolumeManager
extends VolumeManager {
    public static final String HS_WORK_DIR = "yarn.app.mapreduce.am.staging-dir";
    private String rmDir;
    private String rmStagingDir;
    private String hsWorkDir;

    public HSVolumeManager() {
        super("HSVolumeManager");
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.LOG = LoggerFactory.getLogger(HSVolumeManager.class);
        this.rmStagingDir = conf.get("yarn.resourcemanager.staging", YarnDefaultProperties.DEFAULT_RM_STAGING_DIR);
        this.rmDir = conf.get("yarn.resourcemanager.dir", YarnDefaultProperties.DEFAULT_RM_DIR);
        this.hsWorkDir = conf.get(HS_WORK_DIR);
        this.mountPath = conf.get("yarn.timeline-service.generic-application-history.staging", YarnDefaultProperties.DEFAULT_APP_HISTORY_STAGING_DIR);
        this.volumeMode = "hs";
        this.volumeLogfilePath = this.volumeLogfilePath + "/logs/createJHSVolume.log";
        if (this.newVolumePathSupportEnabled) {
            this.verifyHSVolumeMountPoint();
            this.createVolumes(conf);
            this.fs.setPermission(new Path(this.mountPath), YarnAppUtil.RM_STAGING_DIR_PERMISSION);
            if (this.mountPath.equals(this.hsWorkDir) && !this.hsWorkDir.equals(this.rmStagingDir)) {
                this.moveHistoryData(new Path(this.rmStagingDir), new Path(this.mountPath), conf);
            } else {
                this.moveHistoryData(new Path(this.mountPath), new Path(this.rmStagingDir), conf);
            }
        } else {
            this.waitForRMVolume();
            Map hsVolumeInfo = this.getVolumeInfo("mapr.historyserver.volume");
            if (hsVolumeInfo != null) {
                String volumeName = (String)hsVolumeInfo.get("name");
                String volumePath = (String)hsVolumeInfo.get("path");
                int mounted = Integer.parseInt((String)hsVolumeInfo.get("mounted"));
                if (volumeName.equals("mapr.historyserver.volume")) {
                    if (mounted == 1 && !volumePath.equals(this.mountPath)) {
                        this.LOG.info("Volume mapr.historyserver.volume already exist and is mounted at " + volumePath + ". Remounting to default path " + this.mountPath);
                        this.unmountVolume("mapr.historyserver.volume");
                    }
                    this.createVolumes(conf);
                    if (this.hsWorkDir.equals(this.rmStagingDir)) {
                        this.moveHistoryData(new Path(this.mountPath), new Path(this.rmStagingDir), conf);
                    } else {
                        this.moveHistoryData(new Path(this.rmStagingDir), new Path(this.mountPath), conf);
                    }
                }
            }
        }
    }

    public void createVolumes(Configuration conf) throws Exception {
        this.waitForYarnPathCreated();
        if (!this.isVolumeMounted("mapr.historyserver.volume")) {
            this.createVolume("");
        }
    }

    private void moveHistoryData(Path srcPath, Path dstPath, Configuration conf) throws Exception {
        this.waitForRMVolume();
        List historyData = Arrays.asList(this.fs.listStatus(srcPath)).stream().filter(volume -> !volume.getPath().getName().startsWith("application_")).collect(Collectors.toList());
        for (FileStatus srcDir : historyData) {
            Path dstDir;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("History dir " + srcDir.getPath().toUri().getRawPath() + " is moved to " + dstPath.toUri().getRawPath());
            }
            if (this.fs.exists(dstDir = new Path(dstPath, srcDir.getPath().getName()))) {
                this.deepCopy(srcDir.getPath(), dstDir, conf);
                if (!this.fs.isDirectory(srcDir.getPath()) || !this.fs.isDirectory(dstDir)) continue;
                this.fs.delete(srcDir.getPath(), true);
                continue;
            }
            this.copyAsMove(srcDir, dstDir, conf);
        }
    }

    private void deepCopy(Path src, Path dst, Configuration conf) throws Exception {
        if (this.fs.isDirectory(src) && this.fs.isDirectory(dst)) {
            FileStatus[] srcFiles;
            this.LOG.warn(src + " already exists in path " + dst + ", data will be merged");
            for (FileStatus srcFileStatus : srcFiles = this.fs.listStatus(src)) {
                Path dstFile = new Path(dst, srcFileStatus.getPath().getName());
                if (this.fs.exists(dstFile)) {
                    this.deepCopy(srcFileStatus.getPath(), dstFile, conf);
                    this.fs.delete(srcFileStatus.getPath(), true);
                    continue;
                }
                this.LOG.info(srcFileStatus.getPath() + " is moved to " + dstFile);
                this.copyAsMove(srcFileStatus, dstFile, conf);
            }
        } else {
            FileStatus srcFileStatus = this.fs.getFileStatus(src);
            if (this.fs.exists(dst)) {
                long dstFileModTime;
                FileStatus dstFileStatus = this.fs.getFileStatus(dst);
                long srcFileModTime = srcFileStatus.getModificationTime();
                if (srcFileModTime > (dstFileModTime = dstFileStatus.getModificationTime())) {
                    this.LOG.info(srcFileStatus.getPath() + " is replacing " + dst + " due most recent modification time");
                    this.LOG.debug(srcFileStatus.getPath() + " modification time = " + srcFileModTime + dst + "modification time = " + dstFileModTime);
                    this.fs.delete(dst, true);
                    this.copyAsMove(srcFileStatus, dst, conf);
                } else {
                    this.LOG.info(dst + " is not replaced by " + srcFileStatus.getPath() + " due most recent modification time");
                    this.LOG.debug(srcFileStatus.getPath() + " modification time = " + srcFileModTime + dst + "modification time = " + dstFileModTime);
                    this.fs.delete(srcFileStatus.getPath(), true);
                }
            } else {
                this.LOG.info(srcFileStatus.getPath() + " is moved to " + dst);
                this.copyAsMove(srcFileStatus, dst, conf);
            }
        }
    }

    private void copyAsMove(FileStatus srcFile, Path dstFile, Configuration conf) throws Exception {
        FileUtil.copy((FileSystem)this.fs, (FileStatus)srcFile, (FileSystem)this.fs, (Path)dstFile, (boolean)false, (boolean)true, (Configuration)conf);
        this.copyPermissionsIfNeeded(srcFile, dstFile);
        this.fs.delete(srcFile.getPath(), true);
    }

    private void waitForRMVolume() throws Exception {
        int waitTimeTotal = 600;
        int waitTime = 0;
        Path rmStagingDirPath = new Path(this.rmStagingDir);
        while (!this.isRMVolumeMounted()) {
            this.LOG.info("Waiting for RM volume mapr.resourcemanager.volume mount finish");
            TimeUnit.SECONDS.sleep(10L);
            if ((waitTime += 10) <= waitTimeTotal) continue;
            throw new RuntimeException("HSVolumeManager launch failed, mapr.resourcemanager.volume is not mounted or mount point is incorrect");
        }
        while (!this.fs.exists(rmStagingDirPath)) {
            this.LOG.info("Waiting for RM staging directory creation");
            TimeUnit.SECONDS.sleep(10L);
            if ((waitTime += 10) <= waitTimeTotal) continue;
            throw new RuntimeException("HSVolumeManager launch failed, staging directory " + this.rmStagingDir + " does not exist");
        }
        Path oldRMDir = new Path(this.rmDir + "/rm");
        while (this.fs.exists(oldRMDir) && this.fs.listStatus(oldRMDir).length > 0) {
            this.LOG.info("Waiting for RM data migration to new volume");
            TimeUnit.SECONDS.sleep(10L);
            if ((waitTime += 10) <= waitTimeTotal) continue;
            throw new RuntimeException("HSVolumeManager launch failed, data migration from old RM volume " + oldRMDir + " is not finished");
        }
    }

    private boolean isRMVolumeMounted() {
        try {
            Map volumeInfo = this.getVolumeInfo("mapr.resourcemanager.volume");
            if (volumeInfo != null) {
                String volumeName = (String)volumeInfo.get("name");
                String rmVolumePath = (String)volumeInfo.get("path");
                int mounted = Integer.parseInt((String)volumeInfo.get("mounted"));
                if (volumeName.equals("mapr.resourcemanager.volume") && mounted == 1 && rmVolumePath.equals(this.rmDir)) {
                    return true;
                }
                if (!this.newVolumePathSupportEnabled && rmVolumePath.equals(new Path(this.rmDir).getParent().toUri().getRawPath()) && volumeName.equals("mapr.resourcemanager.volume") && mounted == 1) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.LOG.error("", (Throwable)e);
        }
        return false;
    }

    private void verifyHSVolumeMountPoint() throws IOException {
        Map volumeInfo = this.getVolumeInfo("mapr.historyserver.volume");
        if (volumeInfo != null) {
            String volumeName = (String)volumeInfo.get("name");
            String hsVolumePath = (String)volumeInfo.get("path");
            int mounted = Integer.parseInt((String)volumeInfo.get("mounted"));
            if (!hsVolumePath.equals(this.mountPath) && volumeName.equals("mapr.historyserver.volume") && mounted == 1) {
                this.LOG.info("Volume mapr.historyserver.volume is mounted at " + hsVolumePath + ". Mount path is configured as " + this.mountPath);
                this.unmountVolume("mapr.historyserver.volume");
            }
        }
    }
}

