/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.impl.zk.CuratorService;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.impl.zk.ZKPathDumper;
import org.apache.hadoop.registry.secure.AbstractSecureRegistryTest;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.zookeeper.CreateMode;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSecureRegistry
extends AbstractSecureRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureRegistry.class);

    @Before
    public void beforeTestSecureZKService() throws Throwable {
        TestSecureRegistry.enableKerberosDebugging();
    }

    @After
    public void afterTestSecureZKService() throws Throwable {
        TestSecureRegistry.disableKerberosDebugging();
        RegistrySecurity.clearZKSaslClientProperties();
    }

    @Test
    public void testCreateSecureZK() throws Throwable {
        this.startSecureZK();
        this.secureZK.stop();
    }

    @Test
    public void testInsecureClientToZK() throws Throwable {
        this.startSecureZK();
        this.userZookeeperToCreateRoot();
        RegistrySecurity.clearZKSaslClientProperties();
        CuratorService curatorService = this.startCuratorServiceInstance("insecure client", false);
        curatorService.zkList("/");
        curatorService.zkMkPath("", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
    }

    @Test
    public void testZookeeperCanWrite() throws Throwable {
        System.setProperty("curator-log-events", "true");
        this.startSecureZK();
        CuratorService curator = null;
        LoginContext login = this.login("zookeeper/localhost", "zookeeper", keytab_zk);
        try {
            TestSecureRegistry.logLoginDetails("zookeeper", login);
            RegistrySecurity.setZKSaslClientProperties((String)"zookeeper", (String)"zookeeper");
            curator = this.startCuratorServiceInstance("ZK", true);
            LOG.info(curator.toString());
            this.addToTeardown((Service)curator);
            curator.zkMkPath("/", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
            curator.zkList("/");
            curator.zkMkPath("/zookeeper", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
        }
        catch (Throwable throwable) {
            TestSecureRegistry.logout(login);
            ServiceOperations.stop(curator);
            throw throwable;
        }
        TestSecureRegistry.logout(login);
        ServiceOperations.stop((Service)curator);
    }

    protected CuratorService startCuratorServiceInstance(String name, boolean secure) {
        Configuration clientConf = new Configuration();
        clientConf.set("hadoop.registry.zk.root", "/");
        clientConf.setBoolean("hadoop.registry.secure", secure);
        TestSecureRegistry.describe(LOG, "Starting Curator service", new Object[0]);
        CuratorService curatorService = new CuratorService(name, (RegistryBindingSource)this.secureZK);
        curatorService.init(clientConf);
        curatorService.start();
        LOG.info("Curator Binding {}", (Object)curatorService.bindingDiagnosticDetails());
        return curatorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userZookeeperToCreateRoot() throws Throwable {
        System.setProperty("curator-log-events", "true");
        CuratorService curator = null;
        LoginContext login = this.login("zookeeper/localhost", "zookeeper", keytab_zk);
        try {
            TestSecureRegistry.logLoginDetails("zookeeper", login);
            RegistrySecurity.setZKSaslClientProperties((String)"zookeeper", (String)"zookeeper");
            curator = this.startCuratorServiceInstance("ZK", true);
            LOG.info(curator.toString());
            this.addToTeardown((Service)curator);
            curator.zkMkPath("/", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
            ZKPathDumper pathDumper = curator.dumpPath(true);
            LOG.info(pathDumper.toString());
        }
        catch (Throwable throwable) {
            TestSecureRegistry.logout(login);
            ServiceOperations.stop(curator);
            throw throwable;
        }
        TestSecureRegistry.logout(login);
        ServiceOperations.stop((Service)curator);
    }
}

