/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal.LogAggregationNodeLocalTFileController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LogAggregationFileControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationFileControllerFactory.class);
    private final Pattern p = Pattern.compile("^[A-Za-z_]+[A-Za-z0-9_]*$");
    private final LinkedList<LogAggregationFileController> controllers = new LinkedList();
    private final Configuration conf;

    public LogAggregationFileControllerFactory(Configuration conf) {
        this.conf = conf;
        Collection fileControllers = conf.getStringCollection("yarn.log-aggregation.file-formats");
        HashMap<String, String> controllerChecker = new HashMap<String, String>();
        for (String controllerName : fileControllers) {
            this.validateAggregatedFileControllerName(controllerName);
            this.validateConflictingControllers(conf, controllerChecker, controllerName);
            DeterminedControllerClassName className = new DeterminedControllerClassName(conf, controllerName);
            LogAggregationFileController controller = this.createFileControllerInstance(conf, controllerName, className);
            controller.initialize(conf, controllerName);
            this.controllers.add(controller);
        }
    }

    private LogAggregationFileController createFileControllerInstance(Configuration conf, String fileController, DeterminedControllerClassName className) {
        Class clazz = conf.getClass(className.configKey, null, LogAggregationFileController.class);
        if (clazz == null) {
            throw new RuntimeException("No class defined for " + fileController);
        }
        LogAggregationFileController instance = (LogAggregationFileController)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        if (instance == null) {
            throw new RuntimeException("No object created for " + className.value);
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateConflictingControllers(Configuration conf, Map<String, String> controllerChecker, String fileController) {
        block4: {
            DeterminedLogAggregationRemoteDir remoteDir = new DeterminedLogAggregationRemoteDir(conf, fileController);
            DeterminedLogAggregationSuffix suffix = new DeterminedLogAggregationSuffix(conf, fileController);
            String dirSuffix = remoteDir.value + "-" + suffix.value;
            if (controllerChecker.containsKey(dirSuffix)) {
                if (remoteDir.usingDefault && suffix.usingDefault) {
                    String fileControllerStr = controllerChecker.get(dirSuffix);
                    ArrayList<String> controllersList = new ArrayList<String>();
                    controllersList.add(fileControllerStr);
                    controllersList.add(fileController);
                    fileControllerStr = StringUtils.join(controllersList, (String)",");
                    controllerChecker.put(dirSuffix, fileControllerStr);
                    break block4;
                } else {
                    String conflictController = controllerChecker.get(dirSuffix);
                    throw new RuntimeException(String.format("The combined value of %s and %s should not be the same as the value set for %s", remoteDir.configKey, suffix.configKey, conflictController));
                }
            }
            controllerChecker.put(dirSuffix, fileController);
        }
        if (YarnConfiguration.isNodeLocalAggregationEnabled((Configuration)conf) && this.controllers.stream().noneMatch(c -> c.getFileControllerName().equals("nodeLocal"))) {
            LogAggregationFileController localNodeLogController = (LogAggregationFileController)ReflectionUtils.newInstance(LogAggregationNodeLocalTFileController.class, (Configuration)conf);
            localNodeLogController.initialize(conf, "nodeLocal");
            this.controllers.add(localNodeLogController);
        }
    }

    public LogAggregationFileController getFileControllerForWrite() {
        if (YarnConfiguration.isNodeLocalAggregationEnabled((Configuration)this.conf)) {
            for (LogAggregationFileController fileController : this.controllers) {
                if (!(fileController instanceof LogAggregationNodeLocalTFileController)) continue;
                return fileController;
            }
        }
        return this.controllers.getFirst();
    }

    public LogAggregationFileController getFileControllerForRead(ApplicationId appId, String appOwner) throws IOException {
        Path remoteAppLogDir;
        StringBuilder diagnosticsMsg = new StringBuilder();
        if (YarnConfiguration.isNodeLocalAggregationEnabled((Configuration)this.conf)) {
            try {
                for (LogAggregationFileController fileController : this.controllers) {
                    if (!(fileController instanceof LogAggregationNodeLocalTFileController)) continue;
                    return fileController;
                }
            }
            catch (Exception ex) {
                diagnosticsMsg.append(ex.getMessage() + "\n");
            }
        }
        if (LogAggregationUtils.isOlderPathEnabled(this.conf)) {
            for (LogAggregationFileController fileController : this.controllers) {
                try {
                    remoteAppLogDir = fileController.getOlderRemoteAppLogDir(appId, appOwner);
                    if (!LogAggregationUtils.getNodeFiles(this.conf, remoteAppLogDir, appId, appOwner).hasNext()) continue;
                    return fileController;
                }
                catch (Exception ex) {
                    diagnosticsMsg.append(ex.getMessage()).append("\n");
                }
            }
        }
        for (LogAggregationFileController fileController : this.controllers) {
            try {
                remoteAppLogDir = fileController.getRemoteAppLogDir(appId, appOwner);
                if (!LogAggregationUtils.getNodeFiles(this.conf, remoteAppLogDir, appId, appOwner).hasNext()) continue;
                return fileController;
            }
            catch (Exception ex) {
                diagnosticsMsg.append(ex.getMessage()).append("\n");
            }
        }
        throw new IOException(diagnosticsMsg.toString());
    }

    private void validateAggregatedFileControllerName(String name) {
        boolean valid = name == null || name.trim().isEmpty() ? false : this.p.matcher(name).matches();
        Preconditions.checkArgument((boolean)valid, (Object)String.format("The FileControllerName: %s set in %s is invalid.The valid File Controller name should only contain a-zA-Z0-9_ and cannot start with numbers", name, "yarn.log-aggregation.file-formats"));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public LinkedList<LogAggregationFileController> getConfiguredLogAggregationFileControllerList() {
        return this.controllers;
    }

    private static class DeterminedControllerClassName {
        private final String configKey;
        private final String value;

        DeterminedControllerClassName(Configuration conf, String fileController) {
            this.configKey = String.format("yarn.log-aggregation.file-controller.%s.class", fileController);
            this.value = conf.get(this.configKey);
            if (this.value == null || this.value.isEmpty()) {
                throw new RuntimeException("No class configured for " + fileController);
            }
        }
    }

    private static class DeterminedLogAggregationSuffix {
        private String value;
        private boolean usingDefault = false;
        private final String configKey;

        DeterminedLogAggregationSuffix(Configuration conf, String fileController) {
            this.configKey = String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", fileController);
            String suffix = conf.get(this.configKey);
            if (suffix == null || suffix.isEmpty()) {
                this.value = conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
                this.usingDefault = true;
            } else {
                this.value = suffix;
            }
        }
    }

    private static class DeterminedLogAggregationRemoteDir {
        private String value;
        private boolean usingDefault = false;
        private final String configKey;

        DeterminedLogAggregationRemoteDir(Configuration conf, String fileController) {
            this.configKey = String.format("yarn.log-aggregation.%s.remote-app-log-dir", fileController);
            String remoteDir = conf.get(this.configKey);
            if (remoteDir == null || remoteDir.isEmpty()) {
                this.value = conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
                this.usingDefault = true;
            } else {
                this.value = remoteDir;
            }
        }
    }
}

