/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.webapp.util.WebServiceClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWebServiceClient {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestWebServiceClient.class.getSimpleName();
    static final String SSL_SERVER_KEYSTORE_PROP_PREFIX = "ssl.server.keystore";
    static final String SSL_SERVER_TRUSTSTORE_PROP_PREFIX = "ssl.server.truststore";
    static final String SERVLET_NAME_ECHO = "echo";
    static final String SERVLET_PATH_ECHO = "/echo";

    @Test
    void testGetWebServiceClient() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.http.policy", "HTTPS_ONLY");
        WebServiceClient.initialize((Configuration)conf);
        WebServiceClient client = WebServiceClient.getWebServiceClient();
        Assertions.assertNotNull((Object)client.getSSLFactory());
        WebServiceClient.destroy();
    }

    @Test
    void testCreateClient() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.http.policy", "HTTPS_ONLY");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestWebServiceClient.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false, (boolean)true);
        Configuration sslConf = KeyStoreTestUtil.getSslConfig();
        sslConf.set("yarn.http.policy", "HTTPS_ONLY");
        HttpServer2 server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(sslConf).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list")).includeCiphers(sslConf.get("ssl.server.include.cipher.list")).build();
        server.addServlet(SERVLET_NAME_ECHO, SERVLET_PATH_ECHO, TestHttpServer.EchoServlet.class);
        server.start();
        URL baseUrl = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        URL u = new URL(baseUrl, "/echo?a=b&c=d");
        WebServiceClient.initialize((Configuration)sslConf);
        WebServiceClient client = WebServiceClient.getWebServiceClient();
        HttpURLConnection conn = client.getHttpURLConnectionFactory().getHttpURLConnection(u);
        Assertions.assertEquals((int)200, (int)conn.getResponseCode());
        WebServiceClient.destroy();
        server.stop();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }
}

