/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestYARNTokenIdentifier {
    @Test
    void testNMTokenIdentifier() throws IOException {
        this.testNMTokenIdentifier(false);
    }

    @Test
    void testNMTokenIdentifierOldFormat() throws IOException {
        this.testNMTokenIdentifier(true);
    }

    public void testNMTokenIdentifier(boolean oldFormat) throws IOException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        NodeId nodeId = NodeId.newInstance((String)"host0", (int)0);
        String applicationSubmitter = "usr0";
        int masterKeyId = 1;
        NMTokenIdentifier token = new NMTokenIdentifier(appAttemptId, nodeId, applicationSubmitter, masterKeyId);
        NMTokenIdentifier anotherToken = new NMTokenIdentifier();
        byte[] tokenContent = oldFormat ? this.writeInOldFormat(token) : token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)token, (Object)anotherToken, (String)"Token is not the same after serialization and deserialization.");
        Assertions.assertEquals((Object)anotherToken.getApplicationAttemptId(), (Object)appAttemptId, (String)"appAttemptId from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getNodeId(), (Object)nodeId, (String)"NodeId from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getApplicationSubmitter(), (Object)applicationSubmitter, (String)"applicationSubmitter from proto is not the same with original token");
        Assertions.assertEquals((int)anotherToken.getKeyId(), (int)masterKeyId, (String)"masterKeyId from proto is not the same with original token");
    }

    @Test
    void testAMRMTokenIdentifier() throws IOException {
        this.testAMRMTokenIdentifier(false);
    }

    @Test
    void testAMRMTokenIdentifierOldFormat() throws IOException {
        this.testAMRMTokenIdentifier(true);
    }

    public void testAMRMTokenIdentifier(boolean oldFormat) throws IOException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        int masterKeyId = 1;
        AMRMTokenIdentifier token = new AMRMTokenIdentifier(appAttemptId, masterKeyId);
        AMRMTokenIdentifier anotherToken = new AMRMTokenIdentifier();
        byte[] tokenContent = oldFormat ? this.writeInOldFormat(token) : token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)token, (Object)anotherToken, (String)"Token is not the same after serialization and deserialization.");
        Assertions.assertEquals((Object)anotherToken.getApplicationAttemptId(), (Object)appAttemptId, (String)"ApplicationAttemptId from proto is not the same with original token");
        Assertions.assertEquals((int)anotherToken.getKeyId(), (int)masterKeyId, (String)"masterKeyId from proto is not the same with original token");
    }

    @Test
    void testClientToAMTokenIdentifier() throws IOException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        String clientName = "user";
        ClientToAMTokenIdentifier token = new ClientToAMTokenIdentifier(appAttemptId, clientName);
        ClientToAMTokenIdentifier anotherToken = new ClientToAMTokenIdentifier();
        byte[] tokenContent = token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)token, (Object)anotherToken, (String)"Token is not the same after serialization and deserialization.");
        Assertions.assertEquals((Object)anotherToken.getApplicationAttemptID(), (Object)appAttemptId, (String)"ApplicationAttemptId from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getClientName(), (Object)clientName, (String)"clientName from proto is not the same with original token");
    }

    @Test
    void testContainerTokenIdentifierProtoMissingFields() throws IOException {
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.newBuilder();
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto proto = builder.build();
        Assertions.assertFalse((boolean)proto.hasContainerType());
        Assertions.assertFalse((boolean)proto.hasExecutionType());
        Assertions.assertFalse((boolean)proto.hasNodeLabelExpression());
        byte[] tokenData = proto.toByteArray();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenData, tokenData.length);
        ContainerTokenIdentifier tid = new ContainerTokenIdentifier();
        tid.readFields((DataInput)dib);
        Assertions.assertEquals((Object)ContainerType.TASK, (Object)tid.getContainerType(), (String)"container type");
        Assertions.assertEquals((Object)ExecutionType.GUARANTEED, (Object)tid.getExecutionType(), (String)"execution type");
        Assertions.assertEquals((Object)"", (Object)tid.getNodeLabelExpression(), (String)"node label expression");
    }

    @Test
    void testContainerTokenIdentifier() throws IOException {
        this.testContainerTokenIdentifier(false, false);
    }

    @Test
    void testContainerTokenIdentifierOldFormat() throws IOException {
        this.testContainerTokenIdentifier(true, true);
        this.testContainerTokenIdentifier(true, false);
    }

    public void testContainerTokenIdentifier(boolean oldFormat, boolean withLogAggregation) throws IOException {
        ContainerId containerID = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)1L);
        String hostName = "host0";
        String appSubmitter = "usr0";
        Resource r = Resource.newInstance((int)1024, (int)1);
        long expiryTimeStamp = 1000L;
        int masterKeyId = 1;
        long rmIdentifier = 1L;
        Priority priority = Priority.newInstance((int)1);
        long creationTime = 1000L;
        ContainerTokenIdentifier token = new ContainerTokenIdentifier(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime);
        ContainerTokenIdentifier anotherToken = new ContainerTokenIdentifier();
        byte[] tokenContent = oldFormat ? this.writeInOldFormat(token, withLogAggregation) : token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)token, (Object)anotherToken, (String)"Token is not the same after serialization and deserialization.");
        Assertions.assertEquals((Object)anotherToken.getContainerID(), (Object)containerID, (String)"ContainerID from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getNmHostAddress(), (Object)hostName, (String)"Hostname from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getApplicationSubmitter(), (Object)appSubmitter, (String)"ApplicationSubmitter from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getResource(), (Object)r, (String)"Resource from proto is not the same with original token");
        Assertions.assertEquals((long)anotherToken.getExpiryTimeStamp(), (long)expiryTimeStamp, (String)"expiryTimeStamp from proto is not the same with original token");
        Assertions.assertEquals((int)anotherToken.getMasterKeyId(), (int)masterKeyId, (String)"KeyId from proto is not the same with original token");
        Assertions.assertEquals((long)anotherToken.getRMIdentifier(), (long)rmIdentifier, (String)"RMIdentifier from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getPriority(), (Object)priority, (String)"Priority from proto is not the same with original token");
        Assertions.assertEquals((long)anotherToken.getCreationTime(), (long)creationTime, (String)"CreationTime from proto is not the same with original token");
        Assertions.assertNull((Object)anotherToken.getLogAggregationContext());
        Assertions.assertEquals((Object)"", (Object)anotherToken.getNodeLabelExpression());
        Assertions.assertEquals((Object)ContainerType.TASK, (Object)anotherToken.getContainerType());
        Assertions.assertEquals((Object)ExecutionType.GUARANTEED, (Object)anotherToken.getExecutionType());
    }

    @Test
    void testRMDelegationTokenIdentifier() throws IOException {
        this.testRMDelegationTokenIdentifier(false);
    }

    @Test
    void testRMDelegationTokenIdentifierOldFormat() throws IOException {
        this.testRMDelegationTokenIdentifier(true);
    }

    public void testRMDelegationTokenIdentifier(boolean oldFormat) throws IOException {
        Text owner = new Text("user1");
        Text renewer = new Text("user2");
        Text realUser = new Text("user3");
        long issueDate = 1L;
        long maxDate = 2L;
        int sequenceNumber = 3;
        int masterKeyId = 4;
        RMDelegationTokenIdentifier originalToken = new RMDelegationTokenIdentifier(owner, renewer, realUser);
        originalToken.setIssueDate(issueDate);
        originalToken.setMaxDate(maxDate);
        originalToken.setSequenceNumber(sequenceNumber);
        originalToken.setMasterKeyId(masterKeyId);
        RMDelegationTokenIdentifier anotherToken = new RMDelegationTokenIdentifier();
        if (oldFormat) {
            DataInputBuffer inBuf = new DataInputBuffer();
            DataOutputBuffer outBuf = new DataOutputBuffer();
            originalToken.writeInOldFormat((DataOutput)outBuf);
            inBuf.reset(outBuf.getData(), 0, outBuf.getLength());
            anotherToken.readFieldsInOldFormat((DataInput)inBuf);
            inBuf.close();
        } else {
            byte[] tokenContent = originalToken.getBytes();
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(tokenContent, tokenContent.length);
            anotherToken.readFields((DataInput)dib);
            dib.close();
        }
        Assertions.assertEquals((Object)originalToken, (Object)anotherToken, (String)"Token is not the same after serialization and deserialization.");
        Assertions.assertEquals((Object)owner, (Object)anotherToken.getOwner(), (String)"owner from proto is not the same with original token");
        Assertions.assertEquals((Object)renewer, (Object)anotherToken.getRenewer(), (String)"renewer from proto is not the same with original token");
        Assertions.assertEquals((Object)realUser, (Object)anotherToken.getRealUser(), (String)"realUser from proto is not the same with original token");
        Assertions.assertEquals((long)issueDate, (long)anotherToken.getIssueDate(), (String)"issueDate from proto is not the same with original token");
        Assertions.assertEquals((long)maxDate, (long)anotherToken.getMaxDate(), (String)"maxDate from proto is not the same with original token");
        Assertions.assertEquals((int)sequenceNumber, (int)anotherToken.getSequenceNumber(), (String)"sequenceNumber from proto is not the same with original token");
        Assertions.assertEquals((int)masterKeyId, (int)anotherToken.getMasterKeyId(), (String)"masterKeyId from proto is not the same with original token");
        YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto tokenProto = originalToken.getProto();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        tokenProto.writeTo((OutputStream)out);
        byte[] tokenData = baos.toByteArray();
        RMDelegationTokenIdentifier readToken = new RMDelegationTokenIdentifier();
        DataInputBuffer db = new DataInputBuffer();
        db.reset(tokenData, tokenData.length);
        readToken.readFields((DataInput)db);
        Assertions.assertEquals((Object)originalToken, (Object)readToken, (String)"Token from getProto is not the same after serialization and deserialization.");
        db.close();
        out.close();
    }

    @Test
    void testTimelineDelegationTokenIdentifier() throws IOException {
        Text owner = new Text("user1");
        Text renewer = new Text("user2");
        Text realUser = new Text("user3");
        long issueDate = 1L;
        long maxDate = 2L;
        int sequenceNumber = 3;
        int masterKeyId = 4;
        TimelineDelegationTokenIdentifier token = new TimelineDelegationTokenIdentifier(owner, renewer, realUser);
        token.setIssueDate(issueDate);
        token.setMaxDate(maxDate);
        token.setSequenceNumber(sequenceNumber);
        token.setMasterKeyId(masterKeyId);
        TimelineDelegationTokenIdentifier anotherToken = new TimelineDelegationTokenIdentifier();
        byte[] tokenContent = token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)token, (Object)anotherToken, (String)"Token is not the same after serialization and deserialization.");
        Assertions.assertEquals((Object)anotherToken.getOwner(), (Object)owner, (String)"owner from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getRenewer(), (Object)renewer, (String)"renewer from proto is not the same with original token");
        Assertions.assertEquals((Object)anotherToken.getRealUser(), (Object)realUser, (String)"realUser from proto is not the same with original token");
        Assertions.assertEquals((long)anotherToken.getIssueDate(), (long)issueDate, (String)"issueDate from proto is not the same with original token");
        Assertions.assertEquals((long)anotherToken.getMaxDate(), (long)maxDate, (String)"maxDate from proto is not the same with original token");
        Assertions.assertEquals((int)anotherToken.getSequenceNumber(), (int)sequenceNumber, (String)"sequenceNumber from proto is not the same with original token");
        Assertions.assertEquals((int)anotherToken.getMasterKeyId(), (int)masterKeyId, (String)"masterKeyId from proto is not the same with original token");
    }

    @Test
    void testParseTimelineDelegationTokenIdentifierRenewer() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0]([nr]m@.*EXAMPLE.COM)s/.*/yarn/");
        HadoopKerberosName.setConfiguration((Configuration)conf);
        Text owner = new Text("owner");
        Text renewer = new Text("rm/localhost@EXAMPLE.COM");
        Text realUser = new Text("realUser");
        TimelineDelegationTokenIdentifier token = new TimelineDelegationTokenIdentifier(owner, renewer, realUser);
        Assertions.assertEquals((Object)new Text("yarn"), (Object)token.getRenewer());
    }

    @Test
    void testAMContainerTokenIdentifier() throws IOException {
        ContainerId containerID = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)1L);
        String hostName = "host0";
        String appSubmitter = "usr0";
        Resource r = Resource.newInstance((int)1024, (int)1);
        long expiryTimeStamp = 1000L;
        int masterKeyId = 1;
        long rmIdentifier = 1L;
        Priority priority = Priority.newInstance((int)1);
        long creationTime = 1000L;
        ContainerTokenIdentifier token = new ContainerTokenIdentifier(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, null, "", ContainerType.APPLICATION_MASTER);
        ContainerTokenIdentifier anotherToken = new ContainerTokenIdentifier();
        byte[] tokenContent = token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)ContainerType.APPLICATION_MASTER, (Object)anotherToken.getContainerType());
        Assertions.assertEquals((Object)ExecutionType.GUARANTEED, (Object)anotherToken.getExecutionType());
        token = new ContainerTokenIdentifier(containerID, 0, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, null, "", ContainerType.TASK, ExecutionType.OPPORTUNISTIC);
        anotherToken = new ContainerTokenIdentifier();
        tokenContent = token.getBytes();
        dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assertions.assertEquals((Object)ContainerType.TASK, (Object)anotherToken.getContainerType());
        Assertions.assertEquals((Object)ExecutionType.OPPORTUNISTIC, (Object)anotherToken.getExecutionType());
    }

    private byte[] writeInOldFormat(ContainerTokenIdentifier token, boolean withLogAggregation) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ApplicationAttemptId applicationAttemptId = token.getContainerID().getApplicationAttemptId();
        ApplicationId applicationId = applicationAttemptId.getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(applicationAttemptId.getAttemptId());
        out.writeLong(token.getContainerID().getContainerId());
        out.writeUTF(token.getNmHostAddress());
        out.writeUTF(token.getApplicationSubmitter());
        out.writeInt(token.getResource().getMemory());
        out.writeInt(token.getResource().getVirtualCores());
        out.writeLong(token.getExpiryTimeStamp());
        out.writeInt(token.getMasterKeyId());
        out.writeLong(token.getRMIdentifier());
        out.writeInt(token.getPriority().getPriority());
        out.writeLong(token.getCreationTime());
        if (withLogAggregation) {
            if (token.getLogAggregationContext() == null) {
                out.writeInt(-1);
            } else {
                byte[] logAggregationContext = ((LogAggregationContextPBImpl)token.getLogAggregationContext()).getProto().toByteArray();
                out.writeInt(logAggregationContext.length);
                out.write(logAggregationContext);
            }
        }
        out.close();
        return baos.toByteArray();
    }

    private byte[] writeInOldFormat(NMTokenIdentifier token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ApplicationId applicationId = token.getApplicationAttemptId().getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(token.getApplicationAttemptId().getAttemptId());
        out.writeUTF(token.getNodeId().toString());
        out.writeUTF(token.getApplicationSubmitter());
        out.writeInt(token.getKeyId());
        out.close();
        return baos.toByteArray();
    }

    private byte[] writeInOldFormat(AMRMTokenIdentifier token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ApplicationId applicationId = token.getApplicationAttemptId().getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(token.getApplicationAttemptId().getAttemptId());
        out.writeInt(token.getKeyId());
        out.close();
        return baos.toByteArray();
    }
}

