/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.apache.hadoop.yarn.nodelabels.NonAppendableFSNodeLabelStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFileSystemNodeLabelsStore
extends NodeLabelTestBase {
    MockNodeLabelManager mgr = null;
    Configuration conf = null;
    String storeClassName = null;

    public void initTestFileSystemNodeLabelsStore(String className) throws IOException {
        this.storeClassName = className;
        this.mgr = new MockNodeLabelManager();
        this.conf = new Configuration();
        this.conf.setBoolean("yarn.node-labels.enabled", true);
        this.conf.set("yarn.node-labels.fs-store.impl.class", this.storeClassName);
        File tempDir = File.createTempFile("nlb", ".tmp");
        tempDir.delete();
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        this.conf.set("yarn.node-labels.fs-store.root-dir", tempDir.getAbsolutePath());
        this.mgr.init(this.conf);
        this.mgr.start();
    }

    public static Collection<String[]> getParameters() {
        return Arrays.asList({FileSystemNodeLabelsStore.class.getCanonicalName()}, {NonAppendableFSNodeLabelStore.class.getCanonicalName()});
    }

    @AfterEach
    public void after() throws IOException {
        if (this.mgr.store instanceof FileSystemNodeLabelsStore) {
            FileSystemNodeLabelsStore fsStore = (FileSystemNodeLabelsStore)this.mgr.store;
            fsStore.getFs().delete(fsStore.getFsWorkingPath(), true);
        }
        this.mgr.stop();
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=10000L)
    void testRecoverWithMirror(String className) throws Exception {
        this.initTestFileSystemNodeLabelsStore(className);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p1", "p2", "p3"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p4"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p5", "p6"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assertions.assertEquals((int)3, (int)this.mgr.getClusterNodeLabelNames().size());
        Assertions.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        TestFileSystemNodeLabelsStore.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p6", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n6"), this.toNodeId("n7")), (Object)"p4", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n4")), (Object)"p2", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n2"))));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assertions.assertEquals((int)3, (int)this.mgr.getClusterNodeLabelNames().size());
        Assertions.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        TestFileSystemNodeLabelsStore.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p6", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n6"), this.toNodeId("n7")), (Object)"p4", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n4")), (Object)"p2", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n2"))));
        this.mgr.stop();
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=10000L)
    void testRecoverWithDistributedNodeLabels(String className) throws Exception {
        this.initTestFileSystemNodeLabelsStore(className);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p1", "p2", "p3"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p4"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p5", "p6"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        Configuration cf = new Configuration(this.conf);
        cf.set("yarn.node-labels.configuration-type", "distributed");
        this.mgr.init(cf);
        this.mgr.start();
        Assertions.assertEquals((int)3, (int)this.mgr.getClusterNodeLabels().size());
        Assertions.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("p2", "p4", "p6")));
        Assertions.assertTrue((this.mgr.getNodeLabels().size() == 0 ? 1 : 0) != 0, (String)"During recovery in distributed node-labels setup, node to labels mapping should not be recovered ");
        this.mgr.stop();
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=10000L)
    void testEditlogRecover(String className) throws Exception {
        this.initTestFileSystemNodeLabelsStore(className);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p1", "p2", "p3"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p4"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p5", "p6"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assertions.assertEquals((int)3, (int)this.mgr.getClusterNodeLabelNames().size());
        Assertions.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        TestFileSystemNodeLabelsStore.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p6", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n6"), this.toNodeId("n7")), (Object)"p4", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n4")), (Object)"p2", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n2"))));
        this.mgr.stop();
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=10000L)
    void testSerilizationAfterRecovery(String className) throws Exception {
        this.initTestFileSystemNodeLabelsStore(className);
        this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"p1", (boolean)true), NodeLabel.newInstance((String)"p2", (boolean)false), NodeLabel.newInstance((String)"p3", (boolean)true), NodeLabel.newInstance((String)"p4", (boolean)true), NodeLabel.newInstance((String)"p5", (boolean)true), NodeLabel.newInstance((String)"p6", (boolean)false)));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestFileSystemNodeLabelsStore.toSet("p1"), (Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestFileSystemNodeLabelsStore.toSet("p3"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n5"), TestFileSystemNodeLabelsStore.toSet("p5"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        this.mgr.removeFromClusterNodeLabels(TestFileSystemNodeLabelsStore.toSet("p1"));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assertions.assertEquals((int)3, (int)this.mgr.getClusterNodeLabelNames().size());
        Assertions.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestFileSystemNodeLabelsStore.toSet("p2"), (Object)this.toNodeId("n4"), TestFileSystemNodeLabelsStore.toSet("p4"), (Object)this.toNodeId("n6"), TestFileSystemNodeLabelsStore.toSet("p6"), (Object)this.toNodeId("n7"), TestFileSystemNodeLabelsStore.toSet("p6")));
        TestFileSystemNodeLabelsStore.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p6", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n6"), this.toNodeId("n7")), (Object)"p4", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n4")), (Object)"p2", TestFileSystemNodeLabelsStore.toSet(this.toNodeId("n2"))));
        Assertions.assertFalse((boolean)this.mgr.isExclusiveNodeLabel("p2"));
        Assertions.assertTrue((boolean)this.mgr.isExclusiveNodeLabel("p4"));
        Assertions.assertFalse((boolean)this.mgr.isExclusiveNodeLabel("p6"));
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p7", "p8"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestFileSystemNodeLabelsStore.toSet("p9"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assertions.assertEquals((int)6, (int)this.mgr.getClusterNodeLabelNames().size());
        Assertions.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("p2", "p4", "p6", "p7", "p8", "p9")));
        this.mgr.stop();
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    void testRootMkdirOnInitStore(String className) throws Exception {
        this.initTestFileSystemNodeLabelsStore(className);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemNodeLabelsStore mockStore = this.createMockNodeLabelsStore(mockFs);
        boolean expectedMkdirsCount = true;
        Mockito.when((Object)mockStore.getFs().mkdirs((Path)Mockito.any(Path.class))).thenReturn((Object)true);
        this.verifyMkdirsCount(mockStore, 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    void testRootMkdirOnInitStoreRetryLogic(String className) throws Exception {
        this.initTestFileSystemNodeLabelsStore(className);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemNodeLabelsStore mockStore = this.createMockNodeLabelsStore(mockFs);
        int expectedMkdirsCount = 3;
        Mockito.when((Object)mockStore.getFs().mkdirs((Path)Mockito.any(Path.class))).thenThrow(SafeModeException.class).thenThrow(SafeModeException.class).thenReturn((Object)true);
        this.verifyMkdirsCount(mockStore, 3);
    }

    private FileSystemNodeLabelsStore createMockNodeLabelsStore(final FileSystem mockFs) {
        FileSystemNodeLabelsStore mockStore = new FileSystemNodeLabelsStore(){

            public void initFileSystem(Configuration config) throws IOException {
                this.setFs(mockFs);
            }
        };
        mockStore.setFs(mockFs);
        return mockStore;
    }

    private void verifyMkdirsCount(FileSystemNodeLabelsStore store, int expectedNumOfCalls) throws Exception {
        store.init(this.conf, (CommonNodeLabelsManager)this.mgr);
        ((FileSystem)Mockito.verify((Object)store.getFs(), (VerificationMode)Mockito.times((int)expectedNumOfCalls))).mkdirs((Path)Mockito.any(Path.class));
    }

    private static class MockNodeLabelManager
    extends CommonNodeLabelsManager {
        private MockNodeLabelManager() {
        }

        protected void initDispatcher(Configuration conf) {
            this.dispatcher = new InlineDispatcher();
        }

        protected void startDispatcher() {
        }

        protected void stopDispatcher() {
        }
    }
}

