/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.nio.channels.ClosedChannelException;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSerializedExceptionPBImpl {
    @Test
    void testSerializedException() throws Exception {
        SerializedExceptionPBImpl orig = new SerializedExceptionPBImpl();
        orig.init((Throwable)new Exception("test exception"));
        YarnProtos.SerializedExceptionProto proto = orig.getProto();
        SerializedExceptionPBImpl deser = new SerializedExceptionPBImpl(proto);
        Assertions.assertEquals((Object)orig, (Object)deser);
        Assertions.assertEquals((Object)orig.getMessage(), (Object)deser.getMessage());
        Assertions.assertEquals((Object)orig.getRemoteTrace(), (Object)deser.getRemoteTrace());
        Assertions.assertEquals((Object)orig.getCause(), (Object)deser.getCause());
    }

    @Test
    void testDeserialize() throws Exception {
        Exception ex = new Exception("test exception");
        SerializedExceptionPBImpl pb = new SerializedExceptionPBImpl();
        try {
            pb.deSerialize();
            Assertions.fail((String)"deSerialize should throw YarnRuntimeException");
        }
        catch (YarnRuntimeException e) {
            Assertions.assertEquals(ClassNotFoundException.class, e.getCause().getClass());
        }
        pb.init((Throwable)ex);
        Assertions.assertEquals((Object)ex.toString(), (Object)pb.deSerialize().toString());
    }

    @Test
    void testDeserializeWithDefaultConstructor() {
        ClosedChannelException ex = new ClosedChannelException();
        SerializedExceptionPBImpl pb = new SerializedExceptionPBImpl();
        pb.init((Throwable)ex);
        Assertions.assertEquals(ex.getClass(), pb.deSerialize().getClass());
    }

    @Test
    void testBeforeInit() throws Exception {
        YarnProtos.SerializedExceptionProto defaultProto = YarnProtos.SerializedExceptionProto.newBuilder().build();
        SerializedExceptionPBImpl pb1 = new SerializedExceptionPBImpl();
        Assertions.assertNull((Object)pb1.getCause());
        SerializedExceptionPBImpl pb2 = new SerializedExceptionPBImpl();
        Assertions.assertEquals((Object)defaultProto, (Object)pb2.getProto());
        SerializedExceptionPBImpl pb3 = new SerializedExceptionPBImpl();
        Assertions.assertEquals((Object)defaultProto.getTrace(), (Object)pb3.getRemoteTrace());
    }

    @Test
    void testThrowableDeserialization() {
        Error ex = new Error();
        SerializedExceptionPBImpl pb = new SerializedExceptionPBImpl();
        pb.init((Throwable)ex);
        Assertions.assertEquals(ex.getClass(), pb.deSerialize().getClass());
    }
}

