/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.lang3.Range;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGetApplicationsRequest {
    @Test
    void testGetApplicationsRequest() {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        EnumSet<YarnApplicationState> appStates = EnumSet.of(YarnApplicationState.ACCEPTED);
        request.setApplicationStates(appStates);
        HashSet<String> tags = new HashSet<String>();
        tags.add("tag1");
        request.setApplicationTags(tags);
        HashSet<String> types = new HashSet<String>();
        types.add("type1");
        request.setApplicationTypes(types);
        long startBegin = System.currentTimeMillis();
        long startEnd = System.currentTimeMillis() + 1L;
        request.setStartRange(startBegin, startEnd);
        long finishBegin = System.currentTimeMillis() + 2L;
        long finishEnd = System.currentTimeMillis() + 3L;
        request.setFinishRange(finishBegin, finishEnd);
        long limit = 100L;
        request.setLimit(limit);
        HashSet<String> queues = new HashSet<String>();
        queues.add("queue1");
        request.setQueues(queues);
        HashSet<String> users = new HashSet<String>();
        users.add("user1");
        request.setUsers(users);
        ApplicationsRequestScope scope = ApplicationsRequestScope.ALL;
        request.setScope(scope);
        GetApplicationsRequestPBImpl requestFromProto = new GetApplicationsRequestPBImpl(((GetApplicationsRequestPBImpl)request).getProto());
        Assertions.assertEquals((Object)requestFromProto, (Object)request);
        Assertions.assertEquals((Object)requestFromProto.getApplicationStates(), appStates, (String)"ApplicationStates from proto is not the same with original request");
        Assertions.assertEquals((Object)requestFromProto.getApplicationTags(), tags, (String)"ApplicationTags from proto is not the same with original request");
        Assertions.assertEquals((Object)requestFromProto.getApplicationTypes(), types, (String)"ApplicationTypes from proto is not the same with original request");
        Assertions.assertEquals((Object)requestFromProto.getStartRange(), (Object)Range.between((Comparable)Long.valueOf(startBegin), (Comparable)Long.valueOf(startEnd)), (String)"StartRange from proto is not the same with original request");
        Assertions.assertEquals((Object)requestFromProto.getFinishRange(), (Object)Range.between((Comparable)Long.valueOf(finishBegin), (Comparable)Long.valueOf(finishEnd)), (String)"FinishRange from proto is not the same with original request");
        Assertions.assertEquals((long)requestFromProto.getLimit(), (long)limit, (String)"Limit from proto is not the same with original request");
        Assertions.assertEquals((Object)requestFromProto.getQueues(), queues, (String)"Queues from proto is not the same with original request");
        Assertions.assertEquals((Object)requestFromProto.getUsers(), users, (String)"Users from proto is not the same with original request");
    }
}

