/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestApplicationACLsManager {
    private static final String ADMIN_USER = "adminuser";
    private static final String APP_OWNER = "appuser";
    private static final String TESTUSER1 = "testuser1";
    private static final String TESTUSER2 = "testuser2";
    private static final String TESTUSER3 = "testuser3";

    @Test
    void testCheckAccess() {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", ADMIN_USER);
        ApplicationACLsManager aclManager = new ApplicationACLsManager(conf);
        HashMap<ApplicationAccessType, String> aclMap = new HashMap<ApplicationAccessType, String>();
        aclMap.put(ApplicationAccessType.VIEW_APP, "testuser1,testuser3");
        aclMap.put(ApplicationAccessType.MODIFY_APP, TESTUSER1);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        aclManager.addApplication(appId, aclMap);
        UserGroupInformation testUser1 = UserGroupInformation.createRemoteUser((String)TESTUSER1);
        Assertions.assertTrue((boolean)aclManager.checkAccess(testUser1, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(testUser1, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation testUser2 = UserGroupInformation.createRemoteUser((String)TESTUSER2);
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser2, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser2, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation testUser3 = UserGroupInformation.createRemoteUser((String)TESTUSER3);
        Assertions.assertTrue((boolean)aclManager.checkAccess(testUser3, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser3, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation appOwner = UserGroupInformation.createRemoteUser((String)APP_OWNER);
        Assertions.assertTrue((boolean)aclManager.checkAccess(appOwner, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(appOwner, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation adminUser = UserGroupInformation.createRemoteUser((String)ADMIN_USER);
        Assertions.assertTrue((boolean)aclManager.checkAccess(adminUser, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(adminUser, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
    }

    @Test
    void testCheckAccessWithNullACLS() {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", ADMIN_USER);
        ApplicationACLsManager aclManager = new ApplicationACLsManager(conf);
        UserGroupInformation appOwner = UserGroupInformation.createRemoteUser((String)APP_OWNER);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        Assertions.assertTrue((boolean)aclManager.checkAccess(appOwner, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(appOwner, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        UserGroupInformation adminUser = UserGroupInformation.createRemoteUser((String)ADMIN_USER);
        Assertions.assertTrue((boolean)aclManager.checkAccess(adminUser, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(adminUser, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation testUser1 = UserGroupInformation.createRemoteUser((String)TESTUSER1);
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser1, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser1, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
    }

    @Test
    void testCheckAccessWithPartialACLS() {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", ADMIN_USER);
        ApplicationACLsManager aclManager = new ApplicationACLsManager(conf);
        UserGroupInformation appOwner = UserGroupInformation.createRemoteUser((String)APP_OWNER);
        HashMap<ApplicationAccessType, String> aclMap = new HashMap<ApplicationAccessType, String>();
        aclMap.put(ApplicationAccessType.VIEW_APP, TESTUSER1);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        aclManager.addApplication(appId, aclMap);
        Assertions.assertTrue((boolean)aclManager.checkAccess(appOwner, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(appOwner, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        UserGroupInformation adminUser = UserGroupInformation.createRemoteUser((String)ADMIN_USER);
        Assertions.assertTrue((boolean)aclManager.checkAccess(adminUser, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertTrue((boolean)aclManager.checkAccess(adminUser, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation testUser1 = UserGroupInformation.createRemoteUser((String)TESTUSER1);
        Assertions.assertTrue((boolean)aclManager.checkAccess(testUser1, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser1, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
        UserGroupInformation testUser2 = UserGroupInformation.createRemoteUser((String)TESTUSER2);
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser2, ApplicationAccessType.VIEW_APP, APP_OWNER, appId));
        Assertions.assertFalse((boolean)aclManager.checkAccess(testUser2, ApplicationAccessType.MODIFY_APP, APP_OWNER, appId));
    }
}

