/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationTestUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.LogAggregationTFileController;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogAggregationFileControllerFactory
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(TestLogAggregationFileControllerFactory.class);
    private static final String REMOTE_DEFAULT_DIR = "default/";
    private static final String APP_OWNER = "test";
    private static final String WRONG_ROOT_LOG_DIR_MSG = "Wrong remote root log directory found.";
    private static final String WRONG_ROOT_LOG_DIR_SUFFIX_MSG = "Wrong remote root log directory suffix found.";
    private static final List<Class<? extends LogAggregationFileController>> ALL_FILE_CONTROLLERS = Arrays.asList(TestLogAggregationFileController.class, LogAggregationIndexedFileController.class, LogAggregationTFileController.class);
    private static final List<String> ALL_FILE_CONTROLLER_NAMES = Arrays.asList("TestLogAggregationFileController", "IFile", "TFile");
    private ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);

    @BeforeEach
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.set("yarn.nodemanager.remote-app-log-dir", "target/app-logs/default/");
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", "log");
        this.setConf((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFileControllerInstance(LogAggregationFileControllerFactory factory, Class<? extends LogAggregationFileController> className) throws IOException {
        LinkedList fileControllers = factory.getConfiguredLogAggregationFileControllerList();
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path logPath = ((LogAggregationFileController)fileControllers.get(0)).getRemoteAppLogDir(this.appId, APP_OWNER);
        LOG.debug("Checking " + logPath);
        try {
            if (fs.exists(logPath)) {
                fs.delete(logPath, true);
            }
            Assertions.assertTrue((boolean)fs.mkdirs(logPath));
            try (FileWriter writer = new FileWriter(new File(logPath.toString(), "testLog"));){
                writer.write(APP_OWNER);
            }
            Assertions.assertTrue((boolean)className.isInstance(factory.getFileControllerForRead(this.appId, APP_OWNER)), (String)("The used LogAggregationFileController is not instance of " + className.getSimpleName()));
        }
        finally {
            fs.delete(logPath, true);
        }
    }

    @Test
    void testDefaultLogAggregationFileControllerFactory() throws IOException {
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LinkedList list = factory.getConfiguredLogAggregationFileControllerList();
        Assertions.assertEquals((int)1, (int)list.size(), (String)"Only one LogAggregationFileController is expected!");
        Assertions.assertTrue((boolean)(list.get(0) instanceof LogAggregationTFileController), (String)"TFile format is expected to be the first LogAggregationFileController!");
        Assertions.assertTrue((boolean)(factory.getFileControllerForWrite() instanceof LogAggregationTFileController), (String)"TFile format is expected to be used for writing!");
        this.verifyFileControllerInstance(factory, LogAggregationTFileController.class);
    }

    @Test
    void testLogAggregationFileControllerFactoryClassNotSet() {
        Assertions.assertThrows(Exception.class, () -> {
            Configuration conf = this.getConf();
            conf.set("yarn.log-aggregation.file-formats", "TestLogAggregationFileController");
            new LogAggregationFileControllerFactory(conf);
            Assertions.fail((String)"TestLogAggregationFileController's class was not set, but the factory creation did not fail.");
        });
    }

    @Test
    void testLogAggregationFileControllerFactory() throws Exception {
        LogAggregationTestUtils.enableFileControllers(this.getConf(), ALL_FILE_CONTROLLERS, ALL_FILE_CONTROLLER_NAMES);
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LinkedList list = factory.getConfiguredLogAggregationFileControllerList();
        Assertions.assertEquals((int)3, (int)list.size(), (String)"The expected number of LogAggregationFileController is not 3!");
        Assertions.assertTrue((boolean)(list.get(0) instanceof TestLogAggregationFileController), (String)"Test format is expected to be the first LogAggregationFileController!");
        Assertions.assertTrue((boolean)(list.get(1) instanceof LogAggregationIndexedFileController), (String)"IFile format is expected to be the second LogAggregationFileController!");
        Assertions.assertTrue((boolean)(list.get(2) instanceof LogAggregationTFileController), (String)"TFile format is expected to be the first LogAggregationFileController!");
        Assertions.assertTrue((boolean)(factory.getFileControllerForWrite() instanceof TestLogAggregationFileController), (String)"Test format is expected to be used for writing!");
        this.verifyFileControllerInstance(factory, TestLogAggregationFileController.class);
    }

    @Test
    void testClassConfUsed() {
        LogAggregationTestUtils.enableFileControllers(this.getConf(), Collections.singletonList(LogAggregationTFileController.class), Collections.singletonList("TFile"));
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LogAggregationFileController fc = factory.getFileControllerForWrite();
        Assertions.assertEquals((Object)"target/app-logs/TFile", (Object)fc.getRemoteRootLogDir().toString(), (String)WRONG_ROOT_LOG_DIR_MSG);
        Assertions.assertEquals((Object)"TFile", (Object)fc.getRemoteRootLogDirSuffix(), (String)WRONG_ROOT_LOG_DIR_SUFFIX_MSG);
    }

    @Test
    void testNodemanagerConfigurationIsUsed() {
        Configuration conf = this.getConf();
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(conf);
        LogAggregationFileController fc = factory.getFileControllerForWrite();
        Assertions.assertEquals((Object)"target/app-logs/default", (Object)fc.getRemoteRootLogDir().toString(), (String)WRONG_ROOT_LOG_DIR_MSG);
        Assertions.assertEquals((Object)"log-tfile", (Object)fc.getRemoteRootLogDirSuffix(), (String)WRONG_ROOT_LOG_DIR_SUFFIX_MSG);
    }

    @Test
    void testDefaultConfUsed() {
        Configuration conf = this.getConf();
        conf.unset("yarn.nodemanager.remote-app-log-dir");
        conf.unset("yarn.nodemanager.remote-app-log-dir-suffix");
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LogAggregationFileController fc = factory.getFileControllerForWrite();
        Assertions.assertEquals((Object)"/tmp/logs", (Object)fc.getRemoteRootLogDir().toString(), (String)WRONG_ROOT_LOG_DIR_MSG);
        Assertions.assertEquals((Object)"logs-tfile", (Object)fc.getRemoteRootLogDirSuffix(), (String)WRONG_ROOT_LOG_DIR_SUFFIX_MSG);
    }

    private static class TestLogAggregationFileController
    extends LogAggregationFileController {
        private TestLogAggregationFileController() {
        }

        public void initInternal(Configuration conf) {
        }

        public void closeWriter() {
        }

        public void write(AggregatedLogFormat.LogKey logKey, AggregatedLogFormat.LogValue logValue) throws IOException {
        }

        public void postWrite(LogAggregationFileControllerContext record) throws Exception {
        }

        public void initializeWriter(LogAggregationFileControllerContext context) {
        }

        public boolean readAggregatedLogs(ContainerLogsRequest logRequest, OutputStream os) {
            return false;
        }

        public List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest logRequest) {
            return null;
        }

        public void renderAggregatedLogsBlock(HtmlBlock.Block html, View.ViewContext context) {
        }

        public String getApplicationOwner(Path aggregatedLogPath, ApplicationId appId) throws IOException {
            return null;
        }

        public Map<ApplicationAccessType, String> getApplicationAcls(Path aggregatedLogPath, ApplicationId appId) throws IOException {
            return null;
        }
    }
}

