/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHAUtil {
    private Configuration conf;
    private static final String RM1_ADDRESS_UNTRIMMED = "  \t\t\n 1.2.3.4:8021  \n\t ";
    private static final String RM1_ADDRESS = "  \t\t\n 1.2.3.4:8021  \n\t ".trim();
    private static final String RM2_ADDRESS = "localhost:8022";
    private static final String RM3_ADDRESS = "localhost:8033";
    private static final String RM1_NODE_ID_UNTRIMMED = "rm1 ";
    private static final String RM1_NODE_ID = "rm1 ".trim();
    private static final String RM2_NODE_ID = "rm2";
    private static final String RM3_NODE_ID = "rm3";
    private static final String RM_INVALID_NODE_ID = ".rm";
    private static final String RM_NODE_IDS_UNTRIMMED = "rm1 ,rm2";
    private static final String RM_NODE_IDS = RM1_NODE_ID + "," + "rm2";

    @BeforeEach
    public void setUp() {
        this.conf = new Configuration();
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM_NODE_IDS_UNTRIMMED);
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID_UNTRIMMED);
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.conf)) {
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS_UNTRIMMED);
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
        }
    }

    @Test
    void testGetRMServiceId() throws Exception {
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        Collection rmhaIds = HAUtil.getRMHAIds((Configuration)this.conf);
        Assertions.assertEquals((int)2, (int)rmhaIds.size());
        String[] ids = rmhaIds.toArray(new String[0]);
        Assertions.assertEquals((Object)RM1_NODE_ID, (Object)ids[0]);
        Assertions.assertEquals((Object)RM2_NODE_ID, (Object)ids[1]);
    }

    @Test
    void testGetRMId() throws Exception {
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
        Assertions.assertEquals((Object)RM1_NODE_ID, (Object)HAUtil.getRMHAId((Configuration)this.conf), (String)"Does not honor yarn.resourcemanager.ha.id");
        this.conf.clear();
        Assertions.assertNull((Object)HAUtil.getRMHAId((Configuration)this.conf), (String)"Return null when yarn.resourcemanager.ha.id is not set");
    }

    @Test
    void testVerifyAndSetConfiguration() throws Exception {
        Configuration myConf = new Configuration(this.conf);
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
        }
        catch (YarnRuntimeException e) {
            Assertions.fail((String)"Should not throw any exceptions.");
        }
        Assertions.assertEquals((Object)StringUtils.getStringCollection((String)RM_NODE_IDS), (Object)HAUtil.getRMHAIds((Configuration)myConf), (String)"Should be saved as Trimmed collection");
        Assertions.assertEquals((Object)RM1_NODE_ID, (Object)HAUtil.getRMHAId((Configuration)myConf), (String)"Should be saved as Trimmed string");
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)myConf)) {
            Assertions.assertEquals((Object)RM1_ADDRESS, (Object)myConf.get(confKey), (String)("RPC address not set for " + confKey));
        }
        myConf = new Configuration(this.conf);
        myConf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID);
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
        }
        catch (YarnRuntimeException e) {
            Assertions.assertEquals((Object)("Invalid configuration! " + HAUtil.getInvalidValueMessage((String)"yarn.resourcemanager.ha.rm-ids", (String)(myConf.get("yarn.resourcemanager.ha.rm-ids") + "\nHA mode requires atleast two RMs"))), (Object)e.getMessage(), (String)"YarnRuntimeException by verifyAndSetRMHAIds()");
        }
        myConf = new Configuration(this.conf);
        myConf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)myConf)) {
            myConf.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS);
            myConf.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
        }
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
        }
        catch (YarnRuntimeException e) {
            Assertions.assertEquals((Object)("Invalid configuration! " + HAUtil.getNeedToSetValueMessage((String)"yarn.resourcemanager.ha.id")), (Object)e.getMessage(), (String)"YarnRuntimeException by getRMId()");
        }
        myConf = new Configuration(this.conf);
        myConf.set("yarn.resourcemanager.ha.id", RM_INVALID_NODE_ID);
        myConf.set("yarn.resourcemanager.ha.rm-ids", ".rm," + RM1_NODE_ID);
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)myConf)) {
            myConf.set(confKey + RM_INVALID_NODE_ID, RM_INVALID_NODE_ID);
        }
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
        }
        catch (YarnRuntimeException e) {
            Assertions.assertEquals((Object)("Invalid configuration! " + HAUtil.getInvalidValueMessage((String)"yarn.resourcemanager.ha.id", (String)RM_INVALID_NODE_ID)), (Object)e.getMessage(), (String)"YarnRuntimeException by addSuffix()");
        }
        myConf = new Configuration();
        myConf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
        myConf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
            Assertions.fail((String)"Should throw YarnRuntimeException. by Configuration#set()");
        }
        catch (YarnRuntimeException e) {
            String confKey;
            confKey = HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM1_NODE_ID);
            Assertions.assertEquals((Object)("Invalid configuration! " + HAUtil.getNeedToSetValueMessage((String)(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)RM1_NODE_ID) + " or " + confKey))), (Object)e.getMessage(), (String)"YarnRuntimeException by Configuration#set()");
        }
        myConf = new Configuration(this.conf);
        myConf.set("yarn.resourcemanager.ha.rm-ids", "rm2,rm3");
        myConf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID_UNTRIMMED);
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)myConf)) {
            myConf.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS_UNTRIMMED);
            myConf.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
            myConf.set(HAUtil.addSuffix((String)confKey, (String)RM3_NODE_ID), RM3_ADDRESS);
        }
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
        }
        catch (YarnRuntimeException e) {
            Assertions.assertEquals((Object)("Invalid configuration! " + HAUtil.getRMHAIdNeedToBeIncludedMessage((String)"[rm2, rm3]", (String)RM1_NODE_ID)), (Object)e.getMessage(), (String)"YarnRuntimeException by getRMId()'s validation");
        }
        myConf = new Configuration(this.conf);
        myConf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        myConf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        myConf.setBoolean("yarn.resourcemanager.ha.automatic-failover.embedded", false);
        myConf.setBoolean("yarn.resourcemanager.ha.curator-leader-elector.enabled", false);
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)myConf);
        }
        catch (YarnRuntimeException e) {
            Assertions.assertEquals((Object)"Invalid configuration! The yarn.resourcemanager.ha.automatic-failover.embedded and yarn.resourcemanager.ha.curator-leader-elector.enabled properties are both false. One of these two properties must be true when yarn.resourcemanager.ha.automatic-failover.enabled is true", (Object)e.getMessage(), (String)"YarnRuntimeException by getRMId()'s validation");
        }
    }

    @Test
    void testGetConfKeyForRMInstance() {
        Assertions.assertTrue((boolean)HAUtil.getConfKeyForRMInstance((String)"yarn.resourcemanager.address", (Configuration)this.conf).contains(HAUtil.getRMHAId((Configuration)this.conf)), (String)"RM instance id is not suffixed");
        Assertions.assertFalse((boolean)HAUtil.getConfKeyForRMInstance((String)"yarn.nodemanager.address", (Configuration)this.conf).contains(HAUtil.getRMHAId((Configuration)this.conf)), (String)"RM instance id is suffixed");
    }
}

