/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event.multidispatcher;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.multidispatcher.MockEvent;
import org.apache.hadoop.yarn.event.multidispatcher.MockEventType;
import org.apache.hadoop.yarn.event.multidispatcher.MultiDispatcher;
import org.junit.Assert;
import org.junit.Test;

public class TestMultiDispatcher {
    @Test(timeout=5000L)
    public void testHandle() {
        MultiDispatcher dispatcher = new MultiDispatcher("Test");
        Assert.assertEquals((Object)Service.STATE.NOTINITED, (Object)dispatcher.getServiceState());
        dispatcher.init(new Configuration());
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)dispatcher.getServiceState());
        dispatcher.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)dispatcher.getServiceState());
        AtomicInteger handledEvent = new AtomicInteger();
        dispatcher.register(MockEventType.class, event -> handledEvent.incrementAndGet());
        IntStream.range(0, 1000).forEach(value -> dispatcher.getEventHandler().handle((Event)new MockEvent()));
        dispatcher.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)dispatcher.getServiceState());
        Assert.assertEquals((long)1000L, (long)handledEvent.get());
    }

    @Test(timeout=5000L, expected=Error.class)
    public void testMissingHandler() {
        MultiDispatcher dispatcher = new MultiDispatcher("Test");
        Assert.assertEquals((Object)Service.STATE.NOTINITED, (Object)dispatcher.getServiceState());
        dispatcher.init(new Configuration());
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)dispatcher.getServiceState());
        dispatcher.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)dispatcher.getServiceState());
        dispatcher.getEventHandler().handle((Event)new MockEvent());
    }

    @Test(timeout=5000L)
    public void testBlocksNewOnStop() {
        MultiDispatcher dispatcher = new MultiDispatcher("Test");
        Assert.assertEquals((Object)Service.STATE.NOTINITED, (Object)dispatcher.getServiceState());
        dispatcher.init(new Configuration());
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)dispatcher.getServiceState());
        AtomicInteger handledEvent = new AtomicInteger();
        dispatcher.register(MockEventType.class, event -> handledEvent.incrementAndGet());
        dispatcher.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)dispatcher.getServiceState());
        dispatcher.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)dispatcher.getServiceState());
        dispatcher.getEventHandler().handle((Event)new MockEvent());
        Assert.assertEquals((long)0L, (long)handledEvent.get());
    }
}

